/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import se.ericsson.lte.rbs.omf.em.ImageHelper;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.irbs.util.ToolTipScreen;
import se.ericsson.lte.rbs.omf.em.validator.ValidListener;
import se.ericsson.lte.rbs.omf.em.validator.Validator;

public abstract class AbstractDataPage
extends JPanel
implements ValidListener {
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    public static final transient int AUTO_PAGE_INDEX = 0;
    public static final transient int NETWORK_CONFIGURATION_PAGE_INDEX = 1;
    public static final transient int CONFIGURATION_FILES_PAGE_INDEX = 2;
    public static final transient int STATE_CORRECT = 1;
    public static final transient int STATE_INACTIVE = 2;
    public static final transient int STATE_INCORRECT = 3;
    protected final transient JPanel contentPanel;
    protected final transient String pageName;
    protected final transient JLabel label;
    protected transient int currentState = 3;
    protected transient boolean inActive = false;
    protected transient boolean integrationStarted = false;
    protected transient boolean mandatoryAttributesSet = false;
    protected transient boolean connected = false;

    public AbstractDataPage(String inputPageName, String pageText) {
        super(new GridBagLayout());
        this.pageName = inputPageName;
        this.label = new JLabel(inputPageName, ImageHelper.CORRECT_ICON, 10);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.gridwidth = 1;
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.insets = new Insets(0, 10, 0, 0);
        constraints.weighty = 0.0;
        constraints.weightx = 0.0;
        JPanel infoPane = new JPanel(new GridBagLayout());
        infoPane.setBorder(new EtchedBorder());
        infoPane.setBackground(Color.WHITE);
        JLabel helpTextLabel = new JLabel(irbsBundle.getString("pageHelpText"));
        infoPane.add((Component)helpTextLabel, constraints);
        JPanel test = new JPanel();
        test.add(new JButton("Hello there"));
        JOptionPane.getRootFrame().add(test);
        test.setVisible(true);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        infoPane.add((Component)new JLabel(), constraints);
        JLabel helpIconLabel = new JLabel(ImageHelper.HELP_ICON);
        String title = irbsBundle.getString("pageHelpTitle") + " " + inputPageName;
        new ToolTipScreen(helpIconLabel, title, pageText);
        constraints.insets = new Insets(0, 0, 0, 10);
        constraints.gridx = 2;
        constraints.weightx = 0.0;
        infoPane.add((Component)helpIconLabel, constraints);
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.weighty = 0.0;
        constraints.weightx = 1.0;
        this.add((Component)infoPane, constraints);
        this.contentPanel = new JPanel();
        constraints.weighty = 1.0;
        ++constraints.gridy;
        this.add((Component)this.contentPanel, constraints);
        this.setBorder(new TitledBorder(new EtchedBorder(), inputPageName));
        this.setPreferredSize(new Dimension(200, 400));
    }

    public final void setConnected(boolean inputConnected) {
        this.connected = inputConnected;
    }

    public void setIntegrationStarted(boolean inputIntegrationStarted) {
        this.integrationStarted = inputIntegrationStarted;
    }

    public abstract boolean holdsData();

    public abstract void clearAllData();

    public abstract boolean allDataValid();

    public abstract boolean allDataSpecifiedAndValid();

    public final JLabel getLabel() {
        return this.label;
    }

    public final JPanel getPanel() {
        return this;
    }

    public final String getPageName() {
        return this.pageName;
    }

    public abstract void setEnabled(boolean var1);

    public final void updateState() {
        if (this.inActive) {
            this.setState(2);
        } else if (this.allDataValid()) {
            this.setState(1);
        } else {
            this.setState(3);
        }
    }

    protected final void setState(int state) {
        this.currentState = state;
        switch (state) {
            case 1: {
                this.label.setIcon(ImageHelper.CORRECT_ICON);
                this.setEnabled(true);
                break;
            }
            case 2: {
                this.label.setIcon(ImageHelper.INACTIVE_ICON);
                this.setEnabled(false);
                break;
            }
            case 3: {
                this.label.setIcon(ImageHelper.INCORRECT_ICON);
                this.setEnabled(true);
                break;
            }
            default: {
                IrbsLogger.logError(this.getClass(), "Unknow state received: \"" + state + "\"");
            }
        }
    }

    public final Icon getCurrentIcon() {
        return this.label.getIcon();
    }

    public void setInActive(boolean inputInActive) {
        this.inActive = inputInActive;
        this.setEnabled(!inputInActive);
        this.updateState();
    }

    public void validityChanged(Component component, Validator validator) {
        this.updateState();
    }
}

