/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.ericsson.lte.rbs.omf.em.component.LteButton;
import se.ericsson.lte.rbs.omf.em.component.panel.InputDataException;
import se.ericsson.lte.rbs.omf.em.component.panel.ValidatedFieldBrowsePanel;
import se.ericsson.lte.rbs.omf.em.component.panel.ValidatedFieldPanel;
import se.ericsson.lte.rbs.omf.em.irbs.InputParametersRecoverer;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.ConfigFilesInformer;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.AbstractDataPage;
import se.ericsson.lte.rbs.omf.em.validator.EmptyValidator;
import se.ericsson.lte.rbs.omf.em.validator.IntegerValidator;
import se.ericsson.lte.rbs.omf.em.validator.LocalFilePathValidator;
import se.ericsson.lte.rbs.omf.em.validator.ValidListener;

public class AutoPage
extends AbstractDataPage
implements ValidListener {
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    private final transient JLabel filePathLabel;
    private final transient ValidatedFieldBrowsePanel siteInstallFilePanel;
    private final transient JLabel vLanIdLabel;
    private final transient ValidatedFieldPanel vLanIdPanel;
    private final transient JLabel smrsUserNameLabel;
    private final transient ValidatedFieldPanel smrsUserNamePanel;
    private final transient JLabel smrsPasswordLabel;
    private final transient ValidatedFieldPanel smrsPasswordPanel;
    private final transient JLabel logicalNameLabel;
    private final transient ValidatedFieldPanel logicalNamePanel;
    private final transient JLabel integrationCodeLabel;
    private final transient ValidatedFieldPanel integrationCodePanel;
    private final transient JCheckBox skipSecurityCheckBox;
    private final transient JCheckBox skipIpSecurityCheckBox;
    private final transient LteButton advancedButton;
    private boolean enabled = true;
    private final ConfigFilesInformer configFilesInformer;

    public AutoPage(InputParametersRecoverer inputParametersRecoverer, ValidListener validListener, ConfigFilesInformer inputConfigFilesInformer) throws InputDataException {
        super(irbsBundle.getString("pageAuto"), irbsBundle.getString("autoPanelInfo"));
        this.configFilesInformer = inputConfigFilesInformer;
        this.contentPanel.setLayout(new GridBagLayout());
        JPanel innerDataPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.gridwidth = 1;
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.weighty = 0.0;
        constraints.weightx = 0.0;
        this.filePathLabel = new JLabel(irbsBundle.getString("siteInstFilePath"));
        this.siteInstallFilePanel = new ValidatedFieldBrowsePanel(new LocalFilePathValidator(true, ".xml"), ".xml", irbsBundle.getString("variousXmlFiles"));
        this.getSiteInstallFilePanel().addValidityListener(validListener);
        constraints.weighty = 0.0;
        constraints.insets = new Insets(20, 5, 15, 0);
        innerDataPanel.add((Component)this.filePathLabel, constraints);
        constraints.weightx = 1.0;
        constraints.insets = new Insets(20, 0, 15, 5);
        constraints.gridx = 1;
        constraints.gridwidth = 3;
        innerDataPanel.add((Component)this.getSiteInstallFilePanel(), constraints);
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.insets = new Insets(10, 5, 5, 5);
        constraints.weightx = 0.0;
        this.smrsUserNameLabel = new JLabel(irbsBundle.getString("smrsParamUserName"));
        innerDataPanel.add((Component)this.smrsUserNameLabel, constraints);
        this.smrsUserNamePanel = new ValidatedFieldPanel(new EmptyValidator(false));
        this.smrsUserNamePanel.addValidityListener(validListener);
        constraints.gridx = 1;
        constraints.insets = new Insets(10, 0, 5, 5);
        constraints.weightx = 0.5;
        innerDataPanel.add((Component)this.smrsUserNamePanel, constraints);
        constraints.weightx = 0.0;
        constraints.gridx = 2;
        constraints.insets = new Insets(10, 5, 5, 5);
        this.smrsPasswordLabel = new JLabel(irbsBundle.getString("smrsParamPassword"));
        innerDataPanel.add((Component)this.smrsPasswordLabel, constraints);
        this.smrsPasswordPanel = new ValidatedFieldPanel(new EmptyValidator(false), true);
        this.smrsPasswordPanel.addValidityListener(validListener);
        constraints.insets = new Insets(10, 0, 5, 5);
        constraints.weightx = 0.5;
        constraints.gridx = 3;
        innerDataPanel.add((Component)this.smrsPasswordPanel, constraints);
        this.logicalNameLabel = new JLabel(irbsBundle.getString("irbsInputLogicalName"));
        constraints.gridx = 0;
        constraints.weightx = 0.0;
        constraints.insets = new Insets(5, 5, 5, 5);
        ++constraints.gridy;
        innerDataPanel.add((Component)this.logicalNameLabel, constraints);
        this.logicalNamePanel = new ValidatedFieldPanel(new EmptyValidator(false));
        this.logicalNamePanel.setSize(this.logicalNamePanel.getSize().width, 100);
        this.logicalNamePanel.addValidityListener(this);
        this.logicalNamePanel.addValidityListener(validListener);
        constraints.insets = new Insets(5, 0, 5, 5);
        constraints.gridx = 1;
        constraints.weightx = 0.5;
        innerDataPanel.add((Component)this.logicalNamePanel, constraints);
        this.vLanIdLabel = new JLabel(irbsBundle.getString("irbsInputVLanId"));
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.weightx = 0.0;
        ++constraints.gridy;
        innerDataPanel.add((Component)this.vLanIdLabel, constraints);
        this.vLanIdPanel = new ValidatedFieldPanel(new IntegerValidator(irbsBundle.getString("integerValidatorDesc"), -1, 4094));
        this.vLanIdPanel.setSize(this.vLanIdPanel.getSize().width, 100);
        this.vLanIdPanel.addValidityListener(this);
        this.vLanIdPanel.addValidityListener(validListener);
        constraints.gridx = 1;
        constraints.weightx = 0.5;
        constraints.insets = new Insets(5, 0, 5, 5);
        innerDataPanel.add((Component)this.vLanIdPanel, constraints);
        this.skipSecurityCheckBox = new JCheckBox(irbsBundle.getString("irbsSkipSecurity"), true);
        this.skipSecurityCheckBox.setSelected(false);
        this.skipSecurityCheckBox.addActionListener(this.createSecurityCheckBoxListener());
        constraints.insets = new Insets(20, 5, 0, 5);
        constraints.weightx = 0.0;
        constraints.gridx = 0;
        constraints.gridwidth = 2;
        ++constraints.gridy;
        innerDataPanel.add((Component)this.skipSecurityCheckBox, constraints);
        this.skipIpSecurityCheckBox = new JCheckBox(irbsBundle.getString("irbsSkipIpSecurity"), true);
        this.skipIpSecurityCheckBox.setSelected(false);
        this.skipIpSecurityCheckBox.addActionListener(this.createIpSecurityCheckBoxListener());
        constraints.insets = new Insets(5, 5, 0, 5);
        constraints.weightx = 0.0;
        constraints.gridx = 0;
        constraints.gridwidth = 2;
        ++constraints.gridy;
        innerDataPanel.add((Component)this.skipIpSecurityCheckBox, constraints);
        this.integrationCodeLabel = new JLabel(irbsBundle.getString("irbsInputIntegrationCode"));
        constraints.gridx = 0;
        constraints.weightx = 0.0;
        constraints.gridwidth = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridy += 2;
        innerDataPanel.add((Component)this.integrationCodeLabel, constraints);
        EmptyValidator integrationCodeValidator = new EmptyValidator(false);
        integrationCodeValidator.setHint(irbsBundle.getString("irbsIntegrationCodeHint"));
        this.integrationCodePanel = new ValidatedFieldPanel(integrationCodeValidator, true);
        this.integrationCodePanel.setSize(this.integrationCodePanel.getSize().width, 100);
        this.integrationCodePanel.addValidityListener(this);
        this.integrationCodePanel.addValidityListener(validListener);
        constraints.insets = new Insets(5, 0, 5, 5);
        constraints.gridx = 1;
        constraints.weightx = 0.5;
        innerDataPanel.add((Component)this.integrationCodePanel, constraints);
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.gridwidth = 1;
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.weighty = 0.0;
        constraints.weightx = 1.0;
        this.contentPanel.add((Component)innerDataPanel, constraints);
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.contentPanel.add((Component)new JLabel(), constraints);
        String advancedButtonText = irbsBundle.getString("pageAdvancedButton");
        this.advancedButton = new LteButton(advancedButtonText);
        this.advancedButton.setMnemonic(advancedButtonText.charAt(0));
        this.advancedButton.setPreferredSize(LteButton.STANDARD_BUTTON_SIZE);
        constraints.fill = 0;
        constraints.gridwidth = 1;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.weighty = 0.0;
        ++constraints.gridy;
        this.contentPanel.add((Component)this.advancedButton, constraints);
        this.getSiteInstallFilePanel().setText(inputParametersRecoverer.getSiteInstallationFilePath());
        int previousVLanId = inputParametersRecoverer.getvLanId();
        if (previousVLanId != -10) {
            this.vLanIdPanel.setText(Integer.toString(inputParametersRecoverer.getvLanId()));
        }
        this.skipSecurityCheckBox.setSelected(inputParametersRecoverer.dontUseSecurityActivation());
        this.skipIpSecurityCheckBox.setSelected(inputParametersRecoverer.dontUseIpSecurityActivation());
        this.updateState();
    }

    public void fileDropped(File droppedFile) {
        this.siteInstallFilePanel.setText("");
        this.vLanIdPanel.setText("");
        this.smrsUserNamePanel.setText("");
        this.smrsPasswordPanel.setText("");
        this.logicalNamePanel.setText("");
        this.integrationCodePanel.setText("");
        this.skipSecurityCheckBox.setSelected(false);
        this.skipIpSecurityCheckBox.setSelected(false);
        this.siteInstallFilePanel.setText(droppedFile.getAbsolutePath());
    }

    private ActionListener createSecurityCheckBoxListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                AutoPage.this.setEnabled(AutoPage.this.isEnabled());
                AutoPage.this.updateState();
            }
        };
    }

    private ActionListener createIpSecurityCheckBoxListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                AutoPage.this.setEnabled(AutoPage.this.isEnabled());
                AutoPage.this.updateState();
            }
        };
    }

    public void clearAllData() {
        this.siteInstallFilePanel.setText("");
    }

    public boolean holdsData() {
        return false;
    }

    public LteButton getAdvancedButton() {
        return this.advancedButton;
    }

    public ValidatedFieldPanel getVLanIdPanel() {
        return this.vLanIdPanel;
    }

    public JLabel getSmrsUserNameLabel() {
        return this.smrsUserNameLabel;
    }

    public JLabel getSmrsPasswordLabel() {
        return this.smrsPasswordLabel;
    }

    public ValidatedFieldPanel getSmrsUserNamePanel() {
        return this.smrsUserNamePanel;
    }

    public ValidatedFieldPanel getSmrsPasswordPanel() {
        return this.smrsPasswordPanel;
    }

    public ValidatedFieldPanel getLogicalNamePanel() {
        return this.logicalNamePanel;
    }

    public ValidatedFieldPanel getIntegrationCodePanel() {
        return this.integrationCodePanel;
    }

    public final ValidatedFieldBrowsePanel getSiteInstallFilePanel() {
        return this.siteInstallFilePanel;
    }

    public final JCheckBox getSecurityCheckBox() {
        return this.skipSecurityCheckBox;
    }

    public final JCheckBox getIpSecurityCheckBox() {
        return this.skipIpSecurityCheckBox;
    }

    public final boolean isSkipSecurity() {
        return this.skipSecurityCheckBox.isSelected();
    }

    public final boolean isSkipIpSecurity() {
        return this.skipIpSecurityCheckBox.isSelected();
    }

    public boolean allDataValid() {
        boolean result = false;
        if (!this.isEnabled()) {
            result = true;
        } else if (this.logicalNameValid() && this.vLanIdValid() && (this.integrationCodeValid() || this.isSkipSecurity() && this.isSkipIpSecurity()) && this.smrsUserNamePanel.validValue() && this.smrsPasswordPanel.validValue()) {
            result = true;
        }
        return result;
    }

    private boolean integrationCodeValid() {
        boolean integrationCodeOk = this.integrationCodePanel == null ? false : this.integrationCodePanel.validValue();
        return integrationCodeOk;
    }

    private boolean vLanIdValid() {
        boolean vLanIdOk = this.vLanIdPanel == null ? false : this.vLanIdPanel.validValue();
        return vLanIdOk;
    }

    private boolean logicalNameValid() {
        boolean logicalNameOk = this.logicalNamePanel == null ? false : this.logicalNamePanel.validValue();
        return logicalNameOk;
    }

    public boolean allDataSpecifiedAndValid() {
        boolean result = !this.isEnabled() || this.logicalNameOk() && this.vLanIdOk() && (this.integrationCodeOk() || this.isSkipSecurity() && this.isSkipIpSecurity()) && !this.smrsUserNamePanel.getText().equals("") && this.smrsUserNamePanel.validValue() && !this.smrsPasswordPanel.getText().equals("") && this.smrsPasswordPanel.validValue();
        return result;
    }

    private boolean integrationCodeOk() {
        boolean integrationCodeOk = this.integrationCodePanel == null ? false : !this.integrationCodePanel.getText().equals("") && this.integrationCodePanel.validValue();
        return integrationCodeOk;
    }

    private boolean vLanIdOk() {
        boolean vLanIdOk = this.vLanIdPanel == null ? false : !this.vLanIdPanel.getText().equals("") && this.vLanIdPanel.validValue();
        return vLanIdOk;
    }

    private boolean logicalNameOk() {
        boolean logicalNameOk = this.logicalNamePanel == null ? false : !this.logicalNamePanel.getText().equals("") && this.logicalNamePanel.validValue();
        return logicalNameOk;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean inputEnabled) {
        this.enabled = inputEnabled && this.connected && !this.integrationStarted;
        this.filePathLabel.setEnabled(this.enabled);
        this.siteInstallFilePanel.setEnabled(this.enabled);
        this.smrsUserNameLabel.setEnabled(this.enabled && !this.configFilesInformer.isAllConfigFilesDataSpecifiedAndValid());
        this.smrsUserNamePanel.setEnabled(this.enabled && !this.configFilesInformer.isAllConfigFilesDataSpecifiedAndValid());
        this.smrsPasswordLabel.setEnabled(this.enabled && !this.configFilesInformer.isAllConfigFilesDataSpecifiedAndValid());
        this.smrsPasswordPanel.setEnabled(this.enabled && !this.configFilesInformer.isAllConfigFilesDataSpecifiedAndValid());
        this.logicalNameLabel.setEnabled(this.enabled);
        this.logicalNamePanel.setEnabled(this.enabled);
        this.integrationCodeLabel.setEnabled(this.enabled && (!this.skipSecurityCheckBox.isSelected() || !this.skipIpSecurityCheckBox.isSelected()));
        this.integrationCodePanel.setEnabled(this.enabled && (!this.skipSecurityCheckBox.isSelected() || !this.skipIpSecurityCheckBox.isSelected()));
        this.vLanIdLabel.setEnabled(this.enabled);
        this.vLanIdPanel.setEnabled(this.enabled);
        this.skipSecurityCheckBox.setEnabled(this.enabled);
        this.skipIpSecurityCheckBox.setEnabled(this.enabled);
    }
}

