/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import se.ericsson.lte.rbs.omf.em.component.panel.InputDataException;
import se.ericsson.lte.rbs.omf.em.component.panel.ValidatedFieldPanel;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.DhcpInformer;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.DhcpRegExpValidator;
import se.ericsson.lte.rbs.omf.em.validator.RegExpValidator;

public class DnsServerHolder {
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    private final transient JLabel dnsServerLabel = new JLabel(irbsBundle.getString("irbsOptionDnsServer"));
    private final transient ValidatedFieldPanel dnsServerPanel;

    public DnsServerHolder(DhcpInformer dhcpInformer) throws InputDataException {
        this.dnsServerPanel = new ValidatedFieldPanel(new DhcpRegExpValidator(RegExpValidator.EMPTY_IP_ADDRESS_PATTERN, dhcpInformer));
    }

    public JLabel getDnsServerLabel() {
        return this.dnsServerLabel;
    }

    public ValidatedFieldPanel getDnsServerPanel() {
        return this.dnsServerPanel;
    }

    public boolean correctDnsServer() {
        return this.dnsServerPanel.validValue();
    }

    public void setEnabled(boolean enabled) {
        this.dnsServerLabel.setEnabled(enabled);
        this.dnsServerPanel.setEnabled(enabled);
    }

    public boolean validValue() {
        return this.dnsServerPanel.validValue();
    }

    public boolean dnsServerValid() {
        return this.dnsServerPanel.getTextField().isEnabled() && this.dnsServerPanel.validValue();
    }
}

