/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import se.ericsson.lte.rbs.omf.em.component.panel.InputDataException;
import se.ericsson.lte.rbs.omf.em.irbs.InputParametersRecoverer;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.ConfigFilesInformer;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.DhcpInformer;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.AbstractDataPage;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.DefaultRouterHolder;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.DhcpClientIdentifierHolder;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.DhcpRegExpValidator;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.DnsServerHolder;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.DomainNameHolder;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.NetworkPrefixLengthHolder;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.RbsIpAddressHolder;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.RbsIpv6AddressHolder;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.SmrsHolder;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.SubnetMaskHolder;
import se.ericsson.lte.rbs.omf.em.validator.RegExpValidator;
import se.ericsson.lte.rbs.omf.em.validator.ValidListener;

public class NetworkConfigurationPage
extends AbstractDataPage
implements ValidListener,
DhcpInformer {
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    private final transient JCheckBox dhcpCheckBox;
    private final transient ButtonGroup buttonGroup;
    private final transient JRadioButton ipv4RadionButton;
    private final transient JRadioButton ipv6RadionButton;
    private final transient DhcpClientIdentifierHolder dhcpClientIdentifierHolder;
    private final transient RbsIpAddressHolder rbsIpAddressHolder;
    private final transient RbsIpv6AddressHolder rbsIpv6AddressHolder;
    private final transient SubnetMaskHolder subnetMaskHolder;
    private final transient NetworkPrefixLengthHolder networkPrefixLengthHolder;
    private final transient DefaultRouterHolder defaultRouterHolder;
    private final transient DnsServerHolder dnsServerHolder;
    private final transient DomainNameHolder domainNameHolder;
    private final transient SmrsHolder smrsHolder;
    private final transient Component[] tabPolicyArray;
    private final transient TabPolicy tabPolicy;
    private boolean enabled = true;
    private final ConfigFilesInformer configFilesInformer;

    public NetworkConfigurationPage(InputParametersRecoverer inputParametersRecoverer, ValidListener validListener, ConfigFilesInformer inputConfigFilesInformer) throws InputDataException {
        super(irbsBundle.getString("pageNetworkConfiguration"), irbsBundle.getString("networkConfigurationPanelInfo"));
        this.configFilesInformer = inputConfigFilesInformer;
        this.contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.gridwidth = 4;
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.weighty = 0.0;
        constraints.weightx = 1.0;
        this.dhcpCheckBox = new JCheckBox(irbsBundle.getString("pageNetworkConfigurationUseDhcp"), true);
        this.dhcpCheckBox.addActionListener(this.createDhcpListener());
        constraints.insets = new Insets(20, 5, 0, 5);
        constraints.weightx = 0.0;
        constraints.gridx = 0;
        ++constraints.gridy;
        this.contentPanel.add((Component)this.dhcpCheckBox, constraints);
        Insets labelInsets = new Insets(10, 5, 5, 2);
        Insets fieldInsets = new Insets(10, 2, 5, 10);
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.insets = labelInsets;
        this.dhcpClientIdentifierHolder = new DhcpClientIdentifierHolder();
        this.contentPanel.add((Component)this.dhcpClientIdentifierHolder.getDhcpClientIdentifierLabel(), constraints);
        this.dhcpClientIdentifierHolder.getDhcpClientIdentifierPanel().addValidityListener(validListener);
        constraints.weightx = 0.5;
        constraints.gridx = 1;
        constraints.insets = fieldInsets;
        this.contentPanel.add((Component)this.dhcpClientIdentifierHolder.getDhcpClientIdentifierPanel(), constraints);
        this.buttonGroup = new ButtonGroup();
        JPanel panel = new JPanel(new GridLayout(0, 1));
        this.ipv4RadionButton = new JRadioButton(irbsBundle.getString("pageNetworkConfigurationUseIpv4"), true);
        this.ipv4RadionButton.addActionListener(this.createIpv4Listener());
        this.ipv6RadionButton = new JRadioButton(irbsBundle.getString("pageNetworkConfigurationUseIpv6"));
        this.ipv6RadionButton.addActionListener(this.createIpv6Listener());
        panel.add(this.ipv4RadionButton);
        this.buttonGroup.add(this.ipv4RadionButton);
        panel.add(this.ipv6RadionButton);
        this.buttonGroup.add(this.ipv6RadionButton);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        this.contentPanel.add((Component)panel, constraints);
        this.rbsIpAddressHolder = new RbsIpAddressHolder(this);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.insets = labelInsets;
        this.contentPanel.add((Component)this.rbsIpAddressHolder.getRbsIpLabel(), constraints);
        this.rbsIpAddressHolder.getRbsIpPanel().addValidityListener(validListener);
        constraints.weightx = 0.5;
        constraints.gridx = 1;
        constraints.insets = fieldInsets;
        this.contentPanel.add((Component)this.rbsIpAddressHolder.getRbsIpPanel(), constraints);
        this.rbsIpv6AddressHolder = new RbsIpv6AddressHolder(this);
        constraints.gridx = 0;
        constraints.weightx = 0.0;
        constraints.insets = labelInsets;
        this.contentPanel.add((Component)this.rbsIpv6AddressHolder.getRbsIpLabel(), constraints);
        this.rbsIpv6AddressHolder.getRbsIpPanel().addValidityListener(validListener);
        constraints.weightx = 0.5;
        constraints.gridx = 1;
        constraints.insets = fieldInsets;
        this.contentPanel.add((Component)this.rbsIpv6AddressHolder.getRbsIpPanel(), constraints);
        this.rbsIpv6AddressHolder.showRbsIpPanel(false);
        this.dnsServerHolder = new DnsServerHolder(this);
        constraints.weighty = 0.0;
        constraints.weightx = 0.0;
        constraints.gridx = 2;
        constraints.insets = labelInsets;
        this.contentPanel.add((Component)this.dnsServerHolder.getDnsServerLabel(), constraints);
        this.dnsServerHolder.getDnsServerPanel().addValidityListener(validListener);
        constraints.gridx = 3;
        constraints.weightx = 0.5;
        constraints.insets = fieldInsets;
        this.contentPanel.add((Component)this.dnsServerHolder.getDnsServerPanel(), constraints);
        this.subnetMaskHolder = new SubnetMaskHolder(this);
        constraints.weightx = 0.0;
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.insets = labelInsets;
        this.contentPanel.add((Component)this.subnetMaskHolder.getSubnetMaskLabel(), constraints);
        this.subnetMaskHolder.getSubnetMaskPanel().addValidityListener(validListener);
        constraints.gridx = 1;
        constraints.weightx = 0.5;
        constraints.insets = fieldInsets;
        this.contentPanel.add((Component)this.subnetMaskHolder.getSubnetMaskPanel(), constraints);
        this.networkPrefixLengthHolder = new NetworkPrefixLengthHolder(this);
        constraints.weightx = 0.0;
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.insets = labelInsets;
        this.contentPanel.add((Component)this.networkPrefixLengthHolder.getNetworkPrefixLengthLabel(), constraints);
        this.networkPrefixLengthHolder.getNetworkPrefixLengthPanel().addValidityListener(validListener);
        constraints.gridx = 1;
        constraints.weightx = 0.5;
        constraints.insets = fieldInsets;
        this.contentPanel.add((Component)this.networkPrefixLengthHolder.getNetworkPrefixLengthPanel(), constraints);
        this.domainNameHolder = new DomainNameHolder(this);
        constraints.weightx = 0.0;
        constraints.gridx = 2;
        constraints.insets = labelInsets;
        this.contentPanel.add((Component)this.domainNameHolder.getDomainNameLabel(), constraints);
        this.domainNameHolder.getDomainNamePanel().addValidityListener(validListener);
        constraints.gridx = 3;
        constraints.weightx = 0.5;
        constraints.insets = fieldInsets;
        this.contentPanel.add((Component)this.domainNameHolder.getDomainNamePanel(), constraints);
        this.defaultRouterHolder = new DefaultRouterHolder(this);
        constraints.weightx = 0.0;
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.insets = labelInsets;
        this.contentPanel.add((Component)this.defaultRouterHolder.getDefaultRouterLabel(), constraints);
        this.defaultRouterHolder.getDefaultRouterPanel().addValidityListener(validListener);
        constraints.gridx = 1;
        constraints.weightx = 0.5;
        constraints.insets = fieldInsets;
        this.contentPanel.add((Component)this.defaultRouterHolder.getDefaultRouterPanel(), constraints);
        constraints.gridx = 3;
        constraints.gridwidth = 1;
        ++constraints.gridy;
        this.contentPanel.add((Component)new JLabel(), constraints);
        this.smrsHolder = new SmrsHolder(this);
        constraints.weightx = 0.0;
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.insets = labelInsets;
        constraints.gridwidth = 1;
        constraints.insets = labelInsets;
        this.contentPanel.add((Component)this.smrsHolder.getSmrsServerLabel(), constraints);
        this.smrsHolder.getSmrsServerPanel().addValidityListener(validListener);
        constraints.gridx = 1;
        constraints.weightx = 0.5;
        constraints.insets = fieldInsets;
        this.contentPanel.add((Component)this.smrsHolder.getSmrsServerPanel(), constraints);
        constraints.weightx = 0.0;
        constraints.gridx = 2;
        this.contentPanel.add((Component)new JLabel(), constraints);
        constraints.weightx = 0.0;
        constraints.gridx = 2;
        this.contentPanel.add((Component)new JLabel(), constraints);
        constraints.weightx = 0.5;
        constraints.gridx = 3;
        this.contentPanel.add((Component)new JLabel(), constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 1;
        constraints.insets = labelInsets;
        constraints.weightx = 0.0;
        this.contentPanel.add((Component)this.smrsHolder.getSmrsFilePathLabel(), constraints);
        this.smrsHolder.getSmrsFilePathPanel().addValidityListener(validListener);
        constraints.weightx = 1.0;
        constraints.gridx = 1;
        constraints.gridwidth = 3;
        constraints.insets = fieldInsets;
        constraints.gridwidth = 0;
        this.contentPanel.add((Component)this.smrsHolder.getSmrsFilePathPanel(), constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.gridwidth = 1;
        constraints.weighty = 1.0;
        this.contentPanel.add((Component)new JLabel(), constraints);
        this.dhcpClientIdentifierHolder.getDhcpClientIdentifierPanel().setText(inputParametersRecoverer.getDhcpClientIdentifier());
        this.dnsServerHolder.getDnsServerPanel().setText(inputParametersRecoverer.getDnsServer());
        this.domainNameHolder.getDomainNamePanel().setText(inputParametersRecoverer.getDomainName());
        this.subnetMaskHolder.getSubnetMaskPanel().setText(inputParametersRecoverer.getSubnetMask());
        this.networkPrefixLengthHolder.getNetworkPrefixLengthPanel().setText(inputParametersRecoverer.getNetworkPrefixLength());
        this.defaultRouterHolder.getDefaultRouterPanel().setText(inputParametersRecoverer.getDefaultRouter());
        this.smrsHolder.getSmrsServerPanel().setText(inputParametersRecoverer.getSmrsServer());
        this.smrsHolder.getSmrsFilePathPanel().setText(inputParametersRecoverer.getSummaryFilePath());
        this.dhcpCheckBox.setSelected(inputParametersRecoverer.useDhcp());
        this.rbsIpAddressHolder.getRbsIpPanel().addValidityListener(this);
        this.rbsIpv6AddressHolder.getRbsIpPanel().addValidityListener(this);
        this.subnetMaskHolder.getSubnetMaskPanel().addValidityListener(this);
        this.networkPrefixLengthHolder.getNetworkPrefixLengthPanel().addValidityListener(this);
        this.dnsServerHolder.getDnsServerPanel().addValidityListener(this);
        this.domainNameHolder.getDomainNamePanel().addValidityListener(this);
        this.defaultRouterHolder.getDefaultRouterPanel().addValidityListener(this);
        this.smrsHolder.getSmrsServerPanel().addValidityListener(this);
        this.smrsHolder.getSmrsFilePathPanel().addValidityListener(this);
        this.tabPolicyArray = new Component[]{this.dhcpClientIdentifierHolder.getDhcpClientIdentifierPanel().getTextField(), this.getIpv4RadioButton(), this.getIpv6RadioButton(), this.rbsIpAddressHolder.getRbsIpPanel().getTextField(), this.rbsIpv6AddressHolder.getRbsIpPanel().getTextField(), this.subnetMaskHolder.getSubnetMaskPanel().getTextField(), this.networkPrefixLengthHolder.getNetworkPrefixLengthPanel().getTextField(), this.defaultRouterHolder.getDefaultRouterPanel().getTextField(), this.smrsHolder.getSmrsServerPanel().getTextField(), this.smrsHolder.getSmrsFilePathPanel().getTextField()};
        this.tabPolicy = new TabPolicy();
        this.setFocusTraversalPolicyProvider(true);
        this.updateState();
    }

    public void clearAllData() {
        ActionListener[] actionListeners = this.dhcpCheckBox.getActionListeners();
        ActionEvent actionEvent = new ActionEvent(this.dhcpCheckBox, 0, "Checkbox changed");
        for (int i = 0; i < actionListeners.length; ++i) {
            actionListeners[i].actionPerformed(actionEvent);
        }
        this.dhcpClientIdentifierHolder.getDhcpClientIdentifierPanel().setText("");
        this.rbsIpAddressHolder.getRbsIpPanel().setText("");
        this.rbsIpv6AddressHolder.getRbsIpPanel().setText("");
        this.subnetMaskHolder.getSubnetMaskPanel().setText("");
        this.networkPrefixLengthHolder.getNetworkPrefixLengthPanel().setText("");
        this.defaultRouterHolder.getDefaultRouterPanel().setText("");
        this.dnsServerHolder.getDnsServerPanel().setText("");
        this.domainNameHolder.getDomainNamePanel().setText("");
        this.smrsHolder.getSmrsServerPanel().setText("");
        this.smrsHolder.getSmrsFilePathPanel().setText("");
        this.dhcpCheckBox.setSelected(true);
        this.ipv4RadionButton.doClick();
    }

    public boolean holdsData() {
        return !this.dhcpClientIdentifierHolder.getDhcpClientIdentifierPanel().getText().equals("") || !this.rbsIpAddressHolder.getRbsIpPanel().getText().equals("") || !this.rbsIpv6AddressHolder.getRbsIpPanel().getText().equals("") || !this.subnetMaskHolder.getSubnetMaskPanel().getText().equals("") || !this.networkPrefixLengthHolder.getNetworkPrefixLengthPanel().getText().equals("") || !this.defaultRouterHolder.getDefaultRouterPanel().getText().equals("") || !this.dnsServerHolder.getDnsServerPanel().getText().equals("") || !this.domainNameHolder.getDomainNamePanel().getText().equals("") || !this.smrsHolder.getSmrsServerPanel().getText().equals("") || !this.smrsHolder.getSmrsFilePathPanel().getText().equals("");
    }

    protected TabPolicy getTabPolicy() {
        return this.tabPolicy;
    }

    public FocusTraversalPolicy getFocusTraversalPolicy() {
        return this.tabPolicy;
    }

    public SmrsHolder getSmrsHolder() {
        return this.smrsHolder;
    }

    public DhcpClientIdentifierHolder getDhcpClientIdentifierHolder() {
        return this.dhcpClientIdentifierHolder;
    }

    public RbsIpAddressHolder getRbsIpAddressHolder() {
        return this.rbsIpAddressHolder;
    }

    public RbsIpAddressHolder getRbsIpv6AddressHolder() {
        return this.rbsIpv6AddressHolder;
    }

    public SubnetMaskHolder getSubnetMaskHolder() {
        return this.subnetMaskHolder;
    }

    public NetworkPrefixLengthHolder getNetworkPrefixLengthHolder() {
        return this.networkPrefixLengthHolder;
    }

    public DefaultRouterHolder getDefaultRouterHolder() {
        return this.defaultRouterHolder;
    }

    public DnsServerHolder getDnsServerHolder() {
        return this.dnsServerHolder;
    }

    public DomainNameHolder getDomainNameHolder() {
        return this.domainNameHolder;
    }

    private ActionListener createIpv4Listener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(NetworkConfigurationPage.this.ipv4RadionButton)) {
                    NetworkConfigurationPage.this.enableIpv4Settings();
                }
            }
        };
    }

    public void enableIpv4Settings() {
        this.networkPrefixLengthHolder.setEnabled(false);
        this.subnetMaskHolder.setEnabled(true);
        this.rbsIpAddressHolder.showRbsIpPanel(true);
        this.rbsIpv6AddressHolder.showRbsIpPanel(false);
        this.dhcpCheckBox.setEnabled(true);
        this.dhcpClientIdentifierHolder.setEnabled(true);
    }

    private ActionListener createIpv6Listener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(NetworkConfigurationPage.this.ipv6RadionButton)) {
                    NetworkConfigurationPage.this.enableIpv6Settings();
                    if (NetworkConfigurationPage.this.networkPrefixLengthHolder.getNetworkPrefixLengthPanel().getText().equals("")) {
                        NetworkConfigurationPage.this.networkPrefixLengthHolder.getNetworkPrefixLengthPanel().setText("64");
                    }
                }
            }
        };
    }

    public void enableIpv6Settings() {
        this.networkPrefixLengthHolder.setEnabled(true);
        this.subnetMaskHolder.setEnabled(false);
        this.rbsIpAddressHolder.showRbsIpPanel(false);
        this.rbsIpv6AddressHolder.showRbsIpPanel(true);
        this.dhcpCheckBox.setEnabled(false);
        this.dhcpCheckBox.setSelected(false);
        this.dhcpClientIdentifierHolder.setEnabled(false);
    }

    private ActionListener createDhcpListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(NetworkConfigurationPage.this.dhcpCheckBox)) {
                    NetworkConfigurationPage.this.setEnabled(!NetworkConfigurationPage.this.dhcpCheckBox.isSelected());
                }
                NetworkConfigurationPage.this.updateState();
            }
        };
    }

    public JCheckBox getDhcpCheckBox() {
        return this.dhcpCheckBox;
    }

    public JRadioButton getIpv4RadioButton() {
        return this.ipv4RadionButton;
    }

    public JRadioButton getIpv6RadioButton() {
        return this.ipv6RadionButton;
    }

    public ButtonGroup getButtonGroup() {
        return this.buttonGroup;
    }

    private boolean disableCheckBox() {
        boolean retValue = false;
        boolean rbsIpAddressValid = this.rbsIpAddressHolder.rbsIpAddressValid();
        boolean subnetMaskValid = this.subnetMaskHolder.subnetMaskValid();
        boolean defaultRouterValid = this.defaultRouterHolder.defaultRouterValid();
        boolean dnsServerValid = this.dnsServerHolder.dnsServerValid();
        boolean domainNameValid = this.domainNameHolder.domainNameValid();
        boolean smrsServerValid = this.smrsHolder.smrsServerValid();
        boolean smrsFilePathValid = this.smrsHolder.smrsFilePathValid();
        retValue = rbsIpAddressValid && subnetMaskValid && defaultRouterValid && dnsServerValid && domainNameValid && smrsServerValid && smrsFilePathValid && this.ipv4RadionButton.isSelected() || this.ipv6RadionButton.isEnabled() && this.ipv6RadionButton.isSelected();
        return retValue;
    }

    public boolean allDataValid() {
        DhcpRegExpValidator validator;
        if (this.disableCheckBox()) {
            this.dhcpCheckBox.setEnabled(false);
            this.dhcpCheckBox.setSelected(false);
        }
        if (this.dnsServerHolder.getDnsServerPanel().getText().equals("")) {
            validator = new DhcpRegExpValidator(RegExpValidator.NON_EMPTY_IP_ADDRESS_PATTERN, this);
            this.smrsHolder.getSmrsServerPanel().setValidator(validator);
        } else if (this.dnsServerHolder.getDnsServerPanel().validValue()) {
            validator = new DhcpRegExpValidator(RegExpValidator.NON_EMPTY_IP_AND_HOST_PATTERN, this);
            this.smrsHolder.getSmrsServerPanel().setValidator(validator);
        }
        boolean allValid_ipv4 = this.rbsIpAddressHolder.validValue() && this.subnetMaskHolder.validValue() && this.defaultRouterHolder.validValue() && this.dnsServerHolder.validValue() && this.domainNameHolder.validValue() && this.smrsHolder.validValue() && this.ipv4RadionButton.isSelected();
        boolean allValid_ipv6 = this.rbsIpv6AddressHolder.validValue() && this.networkPrefixLengthHolder.validValue() && this.defaultRouterHolder.validValue() && this.dnsServerHolder.validValue() && this.domainNameHolder.validValue() && this.smrsHolder.validValue() && this.ipv6RadionButton.isSelected();
        boolean allValid = allValid_ipv4 || allValid_ipv6;
        return allValid;
    }

    public boolean allDataSpecifiedAndValid() {
        DhcpRegExpValidator validator;
        if (this.disableCheckBox()) {
            this.dhcpCheckBox.setEnabled(false);
            this.dhcpCheckBox.setSelected(false);
        }
        if (this.dnsServerHolder.getDnsServerPanel().getText().equals("")) {
            validator = new DhcpRegExpValidator(RegExpValidator.NON_EMPTY_IP_ADDRESS_PATTERN, this);
            this.smrsHolder.getSmrsServerPanel().setValidator(validator);
        } else if (this.dnsServerHolder.getDnsServerPanel().validValue()) {
            validator = new DhcpRegExpValidator(RegExpValidator.NON_EMPTY_IP_AND_HOST_PATTERN, this);
            this.smrsHolder.getSmrsServerPanel().setValidator(validator);
        }
        boolean allSpecifiedAndValid_ipv4 = this.rbsIpAddressHolder.correctRbsIp() && this.subnetMaskHolder.correctSubnetMask() && this.defaultRouterHolder.correctDefaultRouter() && this.dnsServerHolder.correctDnsServer() && this.domainNameHolder.correctDomainName() && this.smrsHolder.correctSmrsServer() && this.smrsHolder.correctSmrsFilePath() && this.ipv4RadionButton.isSelected();
        boolean allSpecifiedAndValid_ipv6 = this.rbsIpv6AddressHolder.correctRbsIp() && this.networkPrefixLengthHolder.correctNetworkPrefixLength() && this.defaultRouterHolder.correctDefaultRouter() && this.dnsServerHolder.correctDnsServer() && this.domainNameHolder.correctDomainName() && this.smrsHolder.correctSmrsServer() && this.smrsHolder.correctSmrsFilePath() && this.ipv6RadionButton.isSelected();
        boolean allSpecifiedAndValid = allSpecifiedAndValid_ipv4 || allSpecifiedAndValid_ipv6;
        return this.dhcpCheckBox.isSelected() || allSpecifiedAndValid;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean inputEnabled) {
        this.enabled = inputEnabled && this.connected && !this.integrationStarted;
        this.dhcpCheckBox.setEnabled(this.enabled && !this.disableCheckBox());
        this.dhcpClientIdentifierHolder.setEnabled(this.dhcpCheckBox.isEnabled() && this.dhcpCheckBox.isSelected());
        this.ipv4RadionButton.setEnabled(this.enabled);
        this.ipv6RadionButton.setEnabled(this.enabled);
        this.rbsIpAddressHolder.setEnabled(this.enabled && this.ipv4RadionButton.isSelected());
        this.rbsIpv6AddressHolder.setEnabled(this.enabled && this.ipv6RadionButton.isSelected());
        this.subnetMaskHolder.setEnabled(this.enabled && this.ipv4RadionButton.isSelected());
        this.networkPrefixLengthHolder.setEnabled(this.enabled && this.ipv6RadionButton.isSelected());
        this.defaultRouterHolder.setEnabled(this.enabled);
        this.dnsServerHolder.setEnabled(this.enabled);
        this.domainNameHolder.setEnabled(this.enabled);
        this.smrsHolder.setEnabled(this.enabled && !this.configFilesInformer.isAllConfigFilesDataSpecifiedAndValid());
    }

    public boolean isDhcpEnabled() {
        return this.dhcpCheckBox.isEnabled();
    }

    public final boolean isDhcpUsed() {
        return this.dhcpCheckBox.isSelected();
    }

    public class TabPolicy
    extends FocusTraversalPolicy {
        TabPolicy() {
        }

        public Component getComponentAfter(Container focusCycleRoot, Component comp) {
            Component nextComponent = NetworkConfigurationPage.this.tabPolicyArray[NetworkConfigurationPage.this.tabPolicyArray.length - 1];
            for (int index = 0; index < NetworkConfigurationPage.this.tabPolicyArray.length; ++index) {
                if (!comp.equals(NetworkConfigurationPage.this.tabPolicyArray[index])) continue;
                if (++index >= NetworkConfigurationPage.this.tabPolicyArray.length) {
                    index = 0;
                }
                nextComponent = NetworkConfigurationPage.this.tabPolicyArray[index];
                break;
            }
            return nextComponent;
        }

        public Component getComponentBefore(Container focusCycleRoot, Component comp) {
            Component previousComponent = NetworkConfigurationPage.this.tabPolicyArray[0];
            for (int index = 0; index < NetworkConfigurationPage.this.tabPolicyArray.length; ++index) {
                if (!comp.equals(NetworkConfigurationPage.this.tabPolicyArray[index])) continue;
                if (--index < 0) {
                    index = NetworkConfigurationPage.this.tabPolicyArray.length - 1;
                }
                previousComponent = NetworkConfigurationPage.this.tabPolicyArray[index];
                break;
            }
            return previousComponent;
        }

        public Component getDefaultComponent(Container focusCycleRoot) {
            return NetworkConfigurationPage.this.tabPolicyArray[0];
        }

        public Component getFirstComponent(Container focusCycleRoot) {
            return NetworkConfigurationPage.this.tabPolicyArray[0];
        }

        public Component getLastComponent(Container focusCycleRoot) {
            return NetworkConfigurationPage.this.tabPolicyArray[NetworkConfigurationPage.this.tabPolicyArray.length - 1];
        }
    }
}

