/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import se.ericsson.lte.rbs.omf.em.component.panel.InputDataException;
import se.ericsson.lte.rbs.omf.em.component.panel.ValidatedFieldPanel;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.DhcpInformer;
import se.ericsson.lte.rbs.omf.em.irbs.component.panel.wizard.pages.DhcpRegExpValidator;
import se.ericsson.lte.rbs.omf.em.validator.RegExpValidator;

public class RbsIpAddressHolder {
    protected static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    protected final transient JLabel rbsIpLabel = new JLabel(irbsBundle.getString("irbsOptionIpAddress"));
    protected transient ValidatedFieldPanel rbsIpPanel;
    protected transient DhcpInformer dhcpInformer;

    public RbsIpAddressHolder() {
    }

    public RbsIpAddressHolder(DhcpInformer aDhcpInformer) throws InputDataException {
        this();
        this.dhcpInformer = aDhcpInformer;
        this.setRbsIpPanel(new ValidatedFieldPanel(new DhcpRegExpValidator(RegExpValidator.NON_EMPTY_IP_ADDRESS_PATTERN, this.dhcpInformer)));
    }

    public JLabel getRbsIpLabel() {
        return this.rbsIpLabel;
    }

    public void setRbsIpPanel(ValidatedFieldPanel aValidatedFieldPanel) {
        this.rbsIpPanel = aValidatedFieldPanel;
    }

    public ValidatedFieldPanel getRbsIpPanel() {
        return this.rbsIpPanel;
    }

    public final void setEnabled(boolean enabled) {
        this.rbsIpLabel.setEnabled(enabled);
        this.rbsIpPanel.setEnabled(enabled);
    }

    public boolean correctRbsIp() {
        return !this.rbsIpPanel.getText().equals("") && this.rbsIpPanel.validValue();
    }

    public boolean validValue() {
        return this.rbsIpPanel.validValue();
    }

    public boolean rbsIpAddressValid() {
        return this.rbsIpPanel.getTextField().isEnabled() && !this.rbsIpPanel.getText().equals("") && this.rbsIpPanel.validValue();
    }

    public void showRbsIpPanel(boolean showPanel) {
        this.setEnabled(showPanel);
        this.rbsIpLabel.setVisible(showPanel);
        this.rbsIpPanel.setVisible(showPanel);
    }

    public String convertToNormalIpFormat(String ipAddressString) throws UnknownHostException {
        String convertedAddress = "";
        if (ipAddressString != null && !ipAddressString.equals("")) {
            InetAddress iNetAddress = InetAddress.getByName(ipAddressString);
            convertedAddress = iNetAddress.getHostAddress();
        }
        return convertedAddress;
    }
}

