/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.dialog;

import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import se.ericsson.lte.rbs.omf.em.ImageHelper;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.irbs.dialog.IntegrationProcess;

class CustomIconRenderer
extends DefaultTreeCellRenderer {
    private ImageIcon finished;
    private ImageIcon notstarted;
    private ImageIcon executing;
    private ImageIcon skipped;
    private ImageIcon failed;
    private ImageIcon warning;
    private ImageIcon retrying;
    private ImageIcon topNodeRunning;
    private ImageIcon topNodeFail;
    private ImageIcon topNodeWarning;
    private ImageIcon topNodeNotDone;
    private ImageIcon topNodeFinished;
    private final Color backgroundColor;

    public CustomIconRenderer(Color inputBackgroundColor) {
        this.backgroundColor = inputBackgroundColor;
        try {
            this.finished = new ImageIcon(ImageHelper.getImage("finished.png"));
            this.notstarted = new ImageIcon(ImageHelper.getImage("notStarted.png"));
            this.executing = new ImageIcon(ImageHelper.getImage("running.png"));
            this.skipped = new ImageIcon(ImageHelper.getImage("skipped.png"));
            this.failed = new ImageIcon(ImageHelper.getImage("failed.png"));
            this.warning = new ImageIcon(ImageHelper.getImage("warning.png"));
            this.retrying = new ImageIcon(ImageHelper.getImage("retrying.png"));
            this.topNodeRunning = new ImageIcon(ImageHelper.getImage("groupExecuting.png"));
            this.topNodeFail = new ImageIcon(ImageHelper.getImage("groupFailed.png"));
            this.topNodeWarning = new ImageIcon(ImageHelper.getImage("groupWarning.png"));
            this.topNodeNotDone = new ImageIcon(ImageHelper.getImage("groupNotStarted.png"));
            this.topNodeFinished = new ImageIcon(ImageHelper.getImage("groupFinished.png"));
        }
        catch (Exception e) {
            IrbsLogger.logError(this.getClass(), e.toString());
        }
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
        if (value != null && value instanceof IntegrationProcess) {
            IntegrationProcess.State status = ((IntegrationProcess)value).getStatus();
            this.setFinished(status);
            this.setNotStarted(status);
            this.setExecuting(status);
            this.setSkipped(status);
            this.setRetrying(status);
            this.setFailed(status);
            this.setWarning(status);
            this.setTopNodeRunning(status);
            this.setTopNodeWithError(status);
            this.setTopNodeWithWarning(status);
            this.setTopNodeNotExecuting(status);
            this.setTopNodeFinished(status);
        }
        this.setBackgroundNonSelectionColor(this.backgroundColor);
        return this;
    }

    private void setFinished(IntegrationProcess.State status) {
        if (status == IntegrationProcess.State.FINISHED) {
            this.setIcon(this.finished);
        }
    }

    private void setNotStarted(IntegrationProcess.State status) {
        if (status == IntegrationProcess.State.NOT_STARTED) {
            this.setIcon(this.notstarted);
        }
    }

    private void setExecuting(IntegrationProcess.State status) {
        if (status == IntegrationProcess.State.EXECUTING) {
            this.setIcon(this.executing);
        }
    }

    private void setSkipped(IntegrationProcess.State status) {
        if (status == IntegrationProcess.State.SKIPPED) {
            this.setIcon(this.skipped);
        }
    }

    private void setRetrying(IntegrationProcess.State status) {
        if (status == IntegrationProcess.State.RETRYING) {
            this.setIcon(this.retrying);
        }
    }

    private void setFailed(IntegrationProcess.State status) {
        if (status == IntegrationProcess.State.FAILED) {
            this.setIcon(this.failed);
        }
    }

    private void setWarning(IntegrationProcess.State status) {
        if (status == IntegrationProcess.State.WARNING) {
            this.setIcon(this.warning);
        }
    }

    private void setTopNodeRunning(IntegrationProcess.State status) {
        if (status == IntegrationProcess.State.TOP_NODE_RUNNING) {
            this.setIcon(this.topNodeRunning);
        }
    }

    private void setTopNodeWithError(IntegrationProcess.State status) {
        if (status == IntegrationProcess.State.TOP_NODE_WITH_ERROR) {
            this.setIcon(this.topNodeFail);
        }
    }

    private void setTopNodeWithWarning(IntegrationProcess.State status) {
        if (status == IntegrationProcess.State.TOP_NODE_WITH_WARNING) {
            this.setIcon(this.topNodeWarning);
        }
    }

    private void setTopNodeNotExecuting(IntegrationProcess.State status) {
        if (status == IntegrationProcess.State.TOP_NODE_NOT_EXECUTING) {
            this.setIcon(this.topNodeNotDone);
        }
    }

    private void setTopNodeFinished(IntegrationProcess.State status) {
        if (status == IntegrationProcess.State.TOP_NODE_FINISHED) {
            this.setIcon(this.topNodeFinished);
        }
    }
}

