/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EtchedBorder;
import javax.swing.filechooser.FileFilter;
import se.ericsson.lte.rbs.omf.em.ImageHelper;
import se.ericsson.lte.rbs.omf.em.component.AbstractLteFrame;
import se.ericsson.lte.rbs.omf.em.component.LteButton;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsHelper;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.irbs.component.menu.MenuBar;

public class DetailedInformationDialog
extends AbstractLteFrame {
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    private final transient JEditorPane textPane;
    private final transient ViewMenu viewMenu;
    private final transient LteButton closeButton;

    public DetailedInformationDialog(Frame parent, String title, String header, String detailedInfo) throws ImageHelper.ResourceException {
        super(title, false);
        IrbsLogger.logEntering(this.getClass());
        this.viewMenu = new ViewMenu();
        this.setJMenuBar(this.viewMenu);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.insets = new Insets(10, 10, 5, 10);
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        JPanel mainPanel = this.getComponentPanel();
        mainPanel.setLayout(new GridBagLayout());
        JPanel headerPanel = new JPanel(new GridBagLayout());
        headerPanel.setBorder(new EtchedBorder());
        headerPanel.setBackground(Color.WHITE);
        ImageIcon iconImage = new ImageIcon(ImageHelper.getImage("icon_LTE_32.gif"));
        JLabel iconLabel = new JLabel(iconImage);
        headerPanel.add((Component)iconLabel, constraints);
        JLabel headerLabel = new JLabel(header);
        Font headerFont = new Font("*Helvetica*", 3, 24);
        headerLabel.setFont(headerFont);
        constraints.weightx = 1.0;
        constraints.anchor = 10;
        headerPanel.add((Component)headerLabel, constraints);
        constraints.anchor = 17;
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.textPane.setFont(new Font("Courier", 0, 12));
        this.textPane.setText(detailedInfo);
        this.textPane.setCaretPosition(0);
        this.textPane.setMinimumSize(new Dimension(350, 300));
        this.textPane.setBorder(new EtchedBorder());
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        String closeButtonText = irbsBundle.getString("detailedCloseButton");
        this.closeButton = new LteButton(closeButtonText);
        this.closeButton.setMnemonic(closeButtonText.charAt(0));
        this.closeButton.addActionListener(this.createCloseListener());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        buttonPanel.add((Component)new JLabel(), constraints);
        constraints.weightx = 0.0;
        constraints.gridx = 1;
        constraints.insets = new Insets(5, 10, 5, 20);
        buttonPanel.add((Component)this.closeButton, constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridy = 0;
        constraints.insets = new Insets(2, 2, 0, 2);
        mainPanel.add((Component)headerPanel, constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(2, 2, 0, 2);
        mainPanel.add((Component)new JScrollPane(this.textPane), constraints);
        ++constraints.gridy;
        constraints.weighty = 0.0;
        mainPanel.add((Component)buttonPanel, constraints);
        this.setSize(new Dimension(750, 400));
        this.setLocationRelativeTo(parent);
        IrbsLogger.logExiting(this.getClass());
    }

    public final void close() {
        IrbsLogger.logEntering(this.getClass());
        this.dispose();
        IrbsLogger.logExiting(this.getClass());
    }

    protected LteButton getCloseButton() {
        return this.closeButton;
    }

    protected JMenuItem getEditCopyMenu() {
        return this.viewMenu.getEditCopyMenu();
    }

    private ActionListener createCloseListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                DetailedInformationDialog.this.close();
            }
        };
    }

    private ActionListener createCopyListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                String selection = "";
                selection = DetailedInformationDialog.this.textPane.getSelectedText() == null ? DetailedInformationDialog.this.textPane.getText() : DetailedInformationDialog.this.textPane.getSelectedText();
                StringSelection data = new StringSelection(selection);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(data, data);
            }
        };
    }

    private ActionListener createSaveListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                JFileChooser fileChooser = new JFileChooser(MenuBar.CURRENT_FILE);
                fileChooser.setFileFilter(new FileFilter(){

                    public boolean accept(File localFile) {
                        if (localFile.isDirectory()) {
                            return false;
                        }
                        MenuBar.CURRENT_FILE = localFile.getParentFile();
                        return localFile.isFile();
                    }

                    public String getDescription() {
                        return irbsBundle.getString("allFilesFilter");
                    }
                });
                int returnVal = IrbsHelper.testMode ? 0 : fileChooser.showSaveDialog(DetailedInformationDialog.this.getParent());
                if (returnVal == 0) {
                    DetailedInformationDialog.this.saveFile(fileChooser);
                }
            }
        };
    }

    private void saveFile(JFileChooser fileChooser) {
        String saveLocation = fileChooser.getSelectedFile().getAbsolutePath();
        try {
            File saveFile = new File(saveLocation);
            if (!saveFile.exists() || 0 == IrbsHelper.displayConfirmationMessage(irbsBundle.getString("irbsOverwriteFileConfirmHeaderLabel"), saveLocation + " " + irbsBundle.getString("irbsOverwriteFileMessageLabel"), 0)) {
                FileWriter out = new FileWriter(saveFile);
                out.write(this.textPane.getText());
                out.close();
                IrbsLogger.logInfo(this.getClass(), "Saved detailed information to location: \"" + saveLocation + "\"");
            }
        }
        catch (Exception e) {
            IrbsLogger.logInfo(this.getClass(), "Could not save detailed information to location: \"" + saveLocation + "\". " + e);
        }
    }

    class ViewMenu
    extends JMenuBar {
        private final JMenuItem editCopyMenu;

        ViewMenu() {
            IrbsLogger.logEntering(this.getClass());
            JMenu fileMenu = new JMenu(irbsBundle.getString("detailedFileMenu"));
            JMenuItem fileSaveMenu = new JMenuItem(irbsBundle.getString("detailedSaveMenu"));
            fileSaveMenu.addActionListener(DetailedInformationDialog.this.createSaveListener());
            fileMenu.add(fileSaveMenu);
            fileMenu.addSeparator();
            JMenuItem fileCloseMenu = new JMenuItem(irbsBundle.getString("detailedCloseMenu"));
            fileCloseMenu.addActionListener(DetailedInformationDialog.this.createCloseListener());
            fileMenu.add(fileCloseMenu);
            this.add(fileMenu);
            JMenu editMenu = new JMenu(irbsBundle.getString("detailedEditMenu"));
            this.editCopyMenu = new JMenuItem(irbsBundle.getString("detailedCopyMenu"));
            this.editCopyMenu.addActionListener(DetailedInformationDialog.this.createCopyListener());
            editMenu.add(this.editCopyMenu);
            this.add(editMenu);
            IrbsLogger.logExiting(this.getClass());
        }

        protected JMenuItem getEditCopyMenu() {
            return this.editCopyMenu;
        }
    }
}

