/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import se.ericsson.lte.rbs.omf.em.ImageHelper;
import se.ericsson.lte.rbs.omf.em.component.AbstractLteDialog;
import se.ericsson.lte.rbs.omf.em.component.LteButton;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsHelper;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;

public class ErrorDialog
extends AbstractLteDialog {
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    private static final transient int LOCATION_OFFSET = 15;
    private final transient LteButton closeButton;
    private final transient LteButton closeAllButton;
    private final transient String errorMsg;
    private final transient String detailedMsg;
    protected static final transient List<ErrorDialog> DISPLAYED_ERRORS = new ArrayList<ErrorDialog>();

    ErrorDialog(Frame parent, String title, Throwable throwable) throws ImageHelper.ResourceException {
        this(parent, title, IrbsHelper.getExceptionMessage(throwable), IrbsHelper.convertToString(throwable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ErrorDialog(Frame parent, String title, String inputErrorMsg, String inputDetailedMsg) throws ImageHelper.ResourceException {
        super(title, parent, true);
        this.errorMsg = inputErrorMsg;
        this.detailedMsg = inputDetailedMsg;
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.insets = new Insets(10, 10, 5, 10);
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        JPanel mainPanel = this.getComponentPanel();
        mainPanel.setLayout(new GridBagLayout());
        JPanel headerPanel = new JPanel(new GridBagLayout());
        headerPanel.setBorder(new EtchedBorder());
        headerPanel.setBackground(Color.WHITE);
        ImageIcon iconImage = new ImageIcon(ImageHelper.getImage("icon_LTE_32.gif"));
        JLabel iconLabel = new JLabel(iconImage);
        headerPanel.add((Component)iconLabel, constraints);
        JLabel headerLabel = new JLabel(irbsBundle.getString("errorHeader"));
        Font headerFont = new Font("*Helvetica*", 3, 24);
        headerLabel.setFont(headerFont);
        constraints.weightx = 1.0;
        constraints.anchor = 10;
        headerPanel.add((Component)headerLabel, constraints);
        constraints.anchor = 17;
        JPanel errorPanel = new JPanel(new GridBagLayout());
        constraints.gridwidth = 0;
        errorPanel.setBorder(new TitledBorder(new EtchedBorder(), irbsBundle.getString("errorGeneralMessage")));
        String choppedMsg = this.chopItUp(inputErrorMsg);
        StringTokenizer tokenizer = new StringTokenizer(choppedMsg, "\n");
        constraints.insets = new Insets(10, 10, 0, 10);
        errorPanel.add((Component)new JLabel(tokenizer.nextToken()), constraints);
        constraints.insets = new Insets(0, 10, 0, 10);
        while (tokenizer.hasMoreTokens()) {
            ++constraints.gridy;
            errorPanel.add((Component)new JLabel(tokenizer.nextToken()), constraints);
        }
        JTextPane detailedErrorPane = new JTextPane();
        detailedErrorPane.setEditable(false);
        detailedErrorPane.setText(inputErrorMsg + "\n\n" + inputDetailedMsg);
        detailedErrorPane.setBorder(new TitledBorder(new EtchedBorder(), irbsBundle.getString("errorGeneralMessage")));
        DetailedScrollPane detailedErrorScrollPane = new DetailedScrollPane(detailedErrorPane);
        detailedErrorScrollPane.setVisible(false);
        detailedErrorScrollPane.setMinimumSize(new Dimension(200, 50));
        detailedErrorScrollPane.setPreferredSize(new Dimension(50, 200));
        String detailedButtonText = irbsBundle.getString("errorDetailedExpandButton");
        LteButton detailedButton = new LteButton(detailedButtonText);
        detailedButton.setMnemonic(detailedButtonText.charAt(0));
        detailedButton.setPreferredSize(LteButton.EXTENDED_BUTTON_SIZE);
        detailedButton.addActionListener(this.createDetailedButtonListener(detailedErrorScrollPane, detailedButton));
        constraints.gridwidth = 1;
        constraints.insets = new Insets(10, 10, 5, 10);
        ++constraints.gridy;
        errorPanel.add((Component)new JLabel(), constraints);
        constraints.weightx = 0.0;
        constraints.anchor = 13;
        errorPanel.add((Component)detailedButton, constraints);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        String closeAllButtonText = irbsBundle.getString("errorCloseAll");
        this.closeAllButton = new LteButton(closeAllButtonText);
        detailedButton.setMnemonic(closeAllButtonText.charAt(0));
        String closeButtonText = irbsBundle.getString("errorClose");
        this.closeButton = new LteButton(closeButtonText);
        this.closeButton.setMnemonic(closeButtonText.charAt(0));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        buttonPanel.add((Component)new JLabel(), constraints);
        this.closeAllButton.addActionListener(this.createCloseAllButtonListener());
        this.closeButton.addActionListener(this.createCloseButtonListener());
        constraints.weightx = 0.0;
        constraints.gridx = 1;
        constraints.insets = new Insets(5, 10, 7, 10);
        buttonPanel.add((Component)this.closeAllButton, constraints);
        constraints.gridx = 2;
        buttonPanel.add((Component)this.closeButton, constraints);
        List<ErrorDialog> list = DISPLAYED_ERRORS;
        synchronized (list) {
            DISPLAYED_ERRORS.add(this);
            this.closeAllButton.setVisible(DISPLAYED_ERRORS.size() > 1);
            for (int j = 0; j < DISPLAYED_ERRORS.size(); ++j) {
                DISPLAYED_ERRORS.get(j).getCloseAllButton().setVisible(DISPLAYED_ERRORS.size() > 1);
            }
        }
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridy = 0;
        constraints.insets = new Insets(2, 2, 0, 2);
        mainPanel.add((Component)headerPanel, constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(2, 2, 2, 2);
        mainPanel.add((Component)errorPanel, constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(2, 2, 2, 2);
        mainPanel.add((Component)detailedErrorScrollPane, constraints);
        ++constraints.gridy;
        constraints.weighty = 0.0;
        mainPanel.add((Component)buttonPanel, constraints);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.pack();
        int xPos = (screenSize.width - this.getSize().width) / 2 + 15 * DISPLAYED_ERRORS.size();
        int yPos = (screenSize.height - this.getSize().height) / 2 + 15 * DISPLAYED_ERRORS.size();
        this.setLocation(xPos, yPos);
    }

    protected final LteButton getCloseButton() {
        return this.closeButton;
    }

    protected final LteButton getCloseAllButton() {
        return this.closeAllButton;
    }

    protected final String getErrorMsg() {
        return this.errorMsg;
    }

    protected final String getDetailedMsg() {
        return this.detailedMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        List<ErrorDialog> list = DISPLAYED_ERRORS;
        synchronized (list) {
            DISPLAYED_ERRORS.remove(this);
            this.dispose();
            for (int i = 0; i < DISPLAYED_ERRORS.size(); ++i) {
                DISPLAYED_ERRORS.get(i).getCloseAllButton().setVisible(DISPLAYED_ERRORS.size() > 1);
            }
        }
    }

    private ActionListener createCloseButtonListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                ErrorDialog.this.close();
            }
        };
    }

    private ActionListener createCloseAllButtonListener() {
        return new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent notUsed) {
                int result = IrbsHelper.displayConfirmationMessage(irbsBundle.getString("errorCloseAllConfirmHeaderLabel"), irbsBundle.getString("errorCloseAllConfirmMessageLabel"), 0);
                if (result == 0) {
                    List<ErrorDialog> list = DISPLAYED_ERRORS;
                    synchronized (list) {
                        for (int i = 0; i < DISPLAYED_ERRORS.size(); ++i) {
                            DISPLAYED_ERRORS.get(i).dispose();
                        }
                        DISPLAYED_ERRORS.clear();
                    }
                }
            }
        };
    }

    protected final String chopItUp(String message) {
        int endIndex = 75;
        StringBuffer buffer = new StringBuffer(message);
        if (message.length() > 75) {
            buffer.setLength(0);
            for (int startIndex = 0; startIndex < message.length(); startIndex += endIndex - startIndex) {
                endIndex = Math.min(message.length() - startIndex, 75);
                buffer.append(message.substring(startIndex, endIndex += startIndex)).append("\n");
            }
        }
        return buffer.toString();
    }

    private ActionListener createDetailedButtonListener(final JScrollPane detailedErrorScrollPane, final LteButton detailedButton) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                if (detailedErrorScrollPane.isVisible()) {
                    detailedButton.setText(irbsBundle.getString("errorDetailedExpandButton"));
                    detailedErrorScrollPane.setVisible(false);
                } else {
                    detailedButton.setText(irbsBundle.getString("errorDetailedCollapseButton"));
                    detailedErrorScrollPane.setVisible(true);
                }
                ErrorDialog.this.pack();
            }
        };
    }

    public static void displayError(Frame parent, String title, Throwable throwable) {
        ErrorDialog.displayError(parent, title, IrbsHelper.getExceptionMessage(throwable), IrbsHelper.convertToString(throwable));
    }

    public static void displayError(final Frame parent, final String title, final String errorMsg, final String detailedMsg) {
        Runnable errorDisplayer = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    IrbsLogger.logEntering(ErrorDialog.class);
                    List<ErrorDialog> list = DISPLAYED_ERRORS;
                    synchronized (list) {
                        if (!ErrorDialog.isAlreadyVisible(errorMsg, detailedMsg)) {
                            ErrorDialog errorDialog = new ErrorDialog(parent, title, errorMsg, detailedMsg);
                            errorDialog.setVisible(!IrbsHelper.testMode);
                        }
                    }
                    IrbsLogger.logExiting(ErrorDialog.class);
                }
                catch (Exception e) {
                    IrbsHelper.displayErrorMessage(irbsBundle.getString("errorErrorHeaderLabel"), irbsBundle.getString("errorErrorMessageLabel") + irbsBundle.getString("reasonLabel") + ": " + IrbsHelper.getExceptionMessage(e));
                }
            }
        };
        try {
            IrbsHelper.invokeLater(errorDisplayer);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static boolean isAlreadyVisible(String errorMsg, String detailedMsg) {
        boolean alreadyVisible = false;
        for (int i = 0; i < DISPLAYED_ERRORS.size(); ++i) {
            ErrorDialog errorDialog = DISPLAYED_ERRORS.get(i);
            if (!errorDialog.errorMsg.equals(errorMsg) || !errorDialog.detailedMsg.equals(detailedMsg)) continue;
            alreadyVisible = true;
            break;
        }
        return alreadyVisible;
    }

    private class DetailedScrollPane
    extends JScrollPane {
        public DetailedScrollPane(Component view) {
            super(view);
        }

        public void setVisible(boolean visible) {
            if (!IrbsHelper.testMode) {
                super.setVisible(visible);
            }
        }
    }
}

