/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.dialog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class IntegrationProcess
extends DefaultMutableTreeNode {
    private static final ResourceBundle IRBS_BUNDLE = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    private String name;
    private State status = State.NOT_STARTED;
    private final List<IntegrationProcess> integrationProcessChildren;
    private final Map<String, State> stateValue;

    public IntegrationProcess() {
        this.integrationProcessChildren = new ArrayList<IntegrationProcess>();
        this.stateValue = new HashMap<String, State>();
    }

    public IntegrationProcess(String inputName, State state) {
        this.name = inputName;
        this.integrationProcessChildren = new ArrayList<IntegrationProcess>();
        this.stateValue = new HashMap<String, State>();
        this.status = state;
    }

    public void add(MutableTreeNode node) {
        super.add(node);
        if (node instanceof IntegrationProcess) {
            this.integrationProcessChildren.add((IntegrationProcess)node);
        }
    }

    public String getName() {
        return this.name;
    }

    public State getStatus() {
        if (!this.integrationProcessChildren.isEmpty()) {
            this.status = State.UNDEFINED;
            Iterator<IntegrationProcess> childIter = this.integrationProcessChildren.iterator();
            int noOfChildrenWithWarningFound = 0;
            while (childIter.hasNext() && this.status != State.TOP_NODE_WITH_ERROR) {
                IntegrationProcess child = childIter.next();
                noOfChildrenWithWarningFound += this.checkStatus(child);
            }
            if (this.status != State.TOP_NODE_WITH_ERROR && noOfChildrenWithWarningFound > 0) {
                this.status = State.TOP_NODE_WITH_WARNING;
            }
            if (this.status == State.UNDEFINED) {
                this.status = State.TOP_NODE_NOT_EXECUTING;
            }
        }
        return this.status;
    }

    private int checkStatus(IntegrationProcess child) {
        int noOfChildrenWithWarningFound = 0;
        if (this.topNodeWithErrors(child)) {
            this.status = State.TOP_NODE_WITH_ERROR;
        } else if (this.topNodeWithWarnings(child)) {
            this.status = State.TOP_NODE_WITH_WARNING;
            noOfChildrenWithWarningFound = 1;
        } else if (this.topNodeRunning(child)) {
            this.status = State.TOP_NODE_RUNNING;
        } else if (this.topNodeFinished(child)) {
            this.status = State.TOP_NODE_FINISHED;
        } else if (this.topNodeNotExecuting(child)) {
            this.status = State.TOP_NODE_NOT_EXECUTING;
        }
        return noOfChildrenWithWarningFound;
    }

    private boolean topNodeNotExecuting(IntegrationProcess child) {
        return (child.getStatus() == State.NOT_STARTED || child.getStatus() == State.TOP_NODE_NOT_EXECUTING || child.getStatus() == State.FINISHED && this.status == State.TOP_NODE_NOT_EXECUTING) && this.status != State.TOP_NODE_RUNNING;
    }

    private boolean topNodeFinished(IntegrationProcess child) {
        return (child.getStatus() == State.FINISHED || child.getStatus() == State.SKIPPED || child.getStatus() == State.TOP_NODE_FINISHED) && this.status != State.TOP_NODE_RUNNING && this.status != State.TOP_NODE_NOT_EXECUTING;
    }

    private boolean topNodeRunning(IntegrationProcess child) {
        return child.getStatus() == State.EXECUTING || child.getStatus() == State.RETRYING || child.getStatus() == State.TOP_NODE_RUNNING;
    }

    private boolean topNodeWithErrors(IntegrationProcess child) {
        return child.getStatus() == State.TOP_NODE_WITH_ERROR || child.getStatus() == State.FAILED;
    }

    private boolean topNodeWithWarnings(IntegrationProcess child) {
        return child.getStatus() == State.TOP_NODE_WITH_WARNING || child.getStatus() == State.WARNING;
    }

    public final State getStatusFromString(String statusString) {
        State statusVal = State.UNDEFINED;
        if (this.stateValue.isEmpty()) {
            this.createStateValueMap();
        }
        if (this.stateValue.containsKey(statusString)) {
            statusVal = this.stateValue.get(statusString);
        }
        return statusVal;
    }

    public String getToolTipText() {
        return IRBS_BUNDLE.getString(this.status.name());
    }

    public void setName(String inputName) {
        this.name = inputName;
    }

    public void setStatus(State inputState) {
        this.status = inputState;
    }

    public String toString() {
        return this.getName();
    }

    private void createStateValueMap() {
        this.stateValue.put("FINISHED", State.FINISHED);
        this.stateValue.put("EXECUTING", State.EXECUTING);
        this.stateValue.put("NOT STARTED", State.NOT_STARTED);
        this.stateValue.put("SKIPPED", State.SKIPPED);
        this.stateValue.put("FAILED", State.FAILED);
        this.stateValue.put("WARNING", State.WARNING);
        this.stateValue.put("TOP_NODE_RUNNING", State.TOP_NODE_RUNNING);
        this.stateValue.put("TOP_NODE_WITH_ERROR", State.TOP_NODE_WITH_ERROR);
        this.stateValue.put("TOP_NODE_WITH_WARNING", State.TOP_NODE_WITH_WARNING);
        this.stateValue.put("TOP_NODE_NOT_EXECUTING", State.TOP_NODE_NOT_EXECUTING);
        this.stateValue.put("TOP_NODE_FINISHED", State.TOP_NODE_FINISHED);
        this.stateValue.put("RETRYING", State.RETRYING);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        UNDEFINED,
        FINISHED,
        EXECUTING,
        NOT_STARTED,
        SKIPPED,
        FAILED,
        WARNING,
        TOP_NODE_RUNNING,
        TOP_NODE_WITH_ERROR,
        TOP_NODE_WITH_WARNING,
        TOP_NODE_NOT_EXECUTING,
        TOP_NODE_FINISHED,
        RETRYING;

    }
}

