/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import se.ericsson.lte.rbs.omf.em.ImageHelper;
import se.ericsson.lte.rbs.omf.em.component.AbstractLteFrame;
import se.ericsson.lte.rbs.omf.em.component.LteButton;
import se.ericsson.lte.rbs.omf.em.irbs.FileHandler;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsException;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsHelper;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.irbs.SmrsFtpInfoProvider;
import se.ericsson.lte.rbs.omf.em.irbs.dialog.ErrorDialog;
import se.ericsson.lte.rbs.omf.em.irbs.dialog.FtpUploadDialog;
import se.ericsson.lte.rbs.omf.em.irbs.notifications.IrbsNotificationEvent;
import se.ericsson.lte.rbs.omf.em.irbs.notifications.IrbsNotificationListener;
import se.ericsson.lte.rbs.omf.em.irbs.report.LogFileException;
import se.ericsson.lte.rbs.omf.em.irbs.report.ReportAndLogHandler;
import se.ericsson.lte.rbs.omf.em.irbs.report.ReportFileException;

public class ReportAndLogDialog
extends AbstractLteFrame
implements FileHandler,
IrbsNotificationListener {
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    private static final int MAX_REPORT_FILE_LENGTH = 64900;
    private static final String REASON_LABEL = irbsBundle.getString("reasonLabel");
    private static final String USER_NAME = System.getProperty("user.name", "");
    private final transient Frame parent;
    private final transient ReportAndLogHandler reportAndLogHandler;
    private final transient boolean isLogFile;
    private final transient JEditorPane textEditPane;
    private final transient ReportMenu reportMenuBar;
    private final transient LteButton closeButton;
    private final transient ReportDocumentListener reportDocumentListener;
    private transient boolean confirmationDialogVisible = false;

    public ReportAndLogDialog(Frame inputParent, SmrsFtpInfoProvider smrsFtpInfoProvider, ReportAndLogHandler inputReportAndLogHandler, boolean inputIsLogFile) throws ImageHelper.ResourceException, IOException, ReportFileException, LogFileException {
        super(inputIsLogFile ? irbsBundle.getString("reportLogTitle") : irbsBundle.getString("reportReportTitle"), false);
        IrbsLogger.logEntering(this.getClass());
        this.parent = inputParent;
        this.reportAndLogHandler = inputReportAndLogHandler;
        this.isLogFile = inputIsLogFile;
        StringBuffer errorMsg = new StringBuffer();
        if (inputIsLogFile) {
            errorMsg.append(irbsBundle.getString("reportLogFile"));
        } else {
            errorMsg.append(irbsBundle.getString("reportReportFile"));
        }
        this.reportMenuBar = new ReportMenu(smrsFtpInfoProvider, inputReportAndLogHandler);
        this.setJMenuBar(this.reportMenuBar);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.insets = new Insets(10, 10, 5, 10);
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        JPanel mainPanel = this.getComponentPanel();
        mainPanel.setLayout(new GridBagLayout());
        JPanel headerPanel = this.createHeaderPanel(inputIsLogFile, constraints);
        this.reportDocumentListener = new ReportDocumentListener(this.reportMenuBar.fileSaveMenu);
        this.textEditPane = this.createTextEditPane(inputIsLogFile, this.reportDocumentListener);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        String closeButtonText = irbsBundle.getString("reportCloseButton");
        this.closeButton = new LteButton(closeButtonText);
        this.closeButton.setMnemonic(closeButtonText.charAt(0));
        this.closeButton.addActionListener(this.createCloseListener());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        buttonPanel.add((Component)new JLabel(), constraints);
        constraints.weightx = 0.0;
        constraints.gridx = 1;
        constraints.insets = new Insets(5, 10, 5, 20);
        buttonPanel.add((Component)this.closeButton, constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridy = 0;
        constraints.insets = new Insets(2, 2, 0, 2);
        mainPanel.add((Component)headerPanel, constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(2, 2, 0, 2);
        mainPanel.add((Component)new JScrollPane(this.textEditPane), constraints);
        ++constraints.gridy;
        constraints.weighty = 0.0;
        mainPanel.add((Component)buttonPanel, constraints);
        this.setSize(new Dimension(600, 800));
        this.setLocationRelativeTo(inputParent);
        inputReportAndLogHandler.addNotificationListener(this);
        this.setStaticStatusMessage(irbsBundle.getString("reportFileNotEditable"), 2);
        IrbsLogger.logExiting(this.getClass());
    }

    private JTextPane createTextEditPane(boolean inputIsLogFile, ReportDocumentListener theReportDocumentListener) throws LogFileException, ReportFileException {
        JTextPane localTextEditPane = new JTextPane();
        localTextEditPane.setEditable(false);
        localTextEditPane.setFont(new Font("Courier", 0, 12));
        if (inputIsLogFile) {
            try {
                localTextEditPane.setText(IrbsHelper.getFileContents(this.getLogFile()).toString());
                this.setTitle(irbsBundle.getString("reportLogTitle") + " - " + this.getLogFile());
            }
            catch (IrbsException re) {
                throw new LogFileException(re);
            }
        }
        try {
            localTextEditPane.setText(IrbsHelper.getFileContents(this.getReportFile()).toString());
            this.setTitle(irbsBundle.getString("reportReportTitle") + " - " + this.getReportFile());
        }
        catch (IrbsException re) {
            throw new ReportFileException(re);
        }
        localTextEditPane.getDocument().addDocumentListener(theReportDocumentListener);
        localTextEditPane.setMinimumSize(new Dimension(200, 300));
        localTextEditPane.setBorder(new EtchedBorder());
        localTextEditPane.addKeyListener(this.createTextEditKeyListener());
        return localTextEditPane;
    }

    private JPanel createHeaderPanel(boolean inputIsLogFile, GridBagConstraints constraints) throws ImageHelper.ResourceException {
        JPanel headerPanel = new JPanel(new GridBagLayout());
        headerPanel.setBorder(new EtchedBorder());
        headerPanel.setBackground(Color.WHITE);
        ImageIcon iconImage = new ImageIcon(ImageHelper.getImage("icon_LTE_32.gif"));
        JLabel iconLabel = new JLabel(iconImage);
        headerPanel.add((Component)iconLabel, constraints);
        JLabel headerLabel = new JLabel(inputIsLogFile ? irbsBundle.getString("reportIntegrationLog") : irbsBundle.getString("reportIntegrationReport"));
        Font headerFont = new Font("*Helvetica*", 3, 24);
        headerLabel.setFont(headerFont);
        constraints.weightx = 1.0;
        constraints.anchor = 10;
        headerPanel.add((Component)headerLabel, constraints);
        constraints.anchor = 17;
        return headerPanel;
    }

    public StringBuffer getFileContents() {
        return new StringBuffer(this.textEditPane.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notificationReceived(final IrbsNotificationEvent notificationEvent) {
        IrbsLogger.logEntering(this.getClass());
        ReportAndLogDialog reportAndLogDialog = this;
        synchronized (reportAndLogDialog) {
            if (this.confirmationDialogVisible) {
                return;
            }
        }
        Runnable notificationUpdater = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ReportAndLogDialog reportAndLogDialog = ReportAndLogDialog.this;
                synchronized (reportAndLogDialog) {
                    String title = "";
                    String message = "";
                    File file = null;
                    if (ReportAndLogDialog.this.isLogFile) {
                        title = irbsBundle.getString("reportLogRevertConfirmationTitle");
                        message = irbsBundle.getString("reportLogRevertConfirmationMessage");
                        file = ReportAndLogDialog.this.getLogFile();
                        ReportAndLogDialog.this.updateTextEditorPane(title, message, file);
                    } else if (!notificationEvent.configurationReport.equals("")) {
                        title = irbsBundle.getString("reportReportRevertConfirmationTitle");
                        message = irbsBundle.getString("reportReportRevertConfirmationMessage");
                        try {
                            file = ReportAndLogDialog.this.getReportFile();
                        }
                        catch (Exception e) {
                            IrbsLogger.logError(this.getClass(), "Could not save report file", e);
                        }
                        ReportAndLogDialog.this.updateTextEditorPane(title, message, file);
                    }
                }
                IrbsLogger.logExiting(this.getClass());
            }
        };
        IrbsHelper.invokeLater(notificationUpdater);
    }

    private void updateTextEditorPane(final String title, final String message, final File file) {
        Runnable textPaneUpdater = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                if (ReportAndLogDialog.this.textEditPane.isEditable()) {
                    if (title.equals("") || message.equals("") || file == null) return;
                    try {
                        ReportAndLogDialog.this.confirmationDialogVisible = true;
                        int result = IrbsHelper.displayConfirmationMessage(title, message, 0);
                        if (result != 0) return;
                        IrbsLogger.logInfo(this.getClass(), "Report file, " + file + ", overwritten by the user, " + USER_NAME);
                        ReportAndLogDialog.this.updateTextPane(file);
                        return;
                    }
                    finally {
                        ReportAndLogDialog.this.confirmationDialogVisible = false;
                    }
                } else {
                    ReportAndLogDialog.this.updateTextPane(file);
                }
            }
        };
        IrbsHelper.invokeLater(textPaneUpdater);
    }

    protected ReportMenu getReportMenuBar() {
        return this.reportMenuBar;
    }

    protected LteButton getCloseButton() {
        return this.closeButton;
    }

    private File getLogFile() {
        return this.reportAndLogHandler.getLogFile();
    }

    private File getReportFile() throws ReportFileException {
        return this.reportAndLogHandler.getReportFile();
    }

    private String getLogFileName() {
        return this.reportAndLogHandler.getLogFileName();
    }

    private String getReportFileName() {
        return this.reportAndLogHandler.getReportFileName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTextPane(String fileContents) {
        try {
            this.textEditPane.getDocument().removeDocumentListener(this.reportDocumentListener);
            this.textEditPane.setText(fileContents);
        }
        finally {
            this.textEditPane.getDocument().addDocumentListener(this.reportDocumentListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTextPane(File file) {
        try {
            this.textEditPane.getDocument().removeDocumentListener(this.reportDocumentListener);
            this.textEditPane.setText(IrbsHelper.getFileContents(file).toString());
            this.textEditPane.setCaretPosition(this.textEditPane.getText().length());
        }
        catch (IrbsException re) {
            IrbsLogger.logError(this.getClass(), "Could not update file contents", re);
        }
        finally {
            this.textEditPane.getDocument().addDocumentListener(this.reportDocumentListener);
        }
    }

    private ActionListener createCloseListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                ReportAndLogDialog.this.close();
            }
        };
    }

    public final void close() {
        IrbsLogger.logEntering(this.getClass());
        this.reportAndLogHandler.removeNotificationListener(this);
        this.textEditPane.getDocument().removeDocumentListener(this.reportDocumentListener);
        this.checkFileForChangesAndSave();
        this.dispose();
        IrbsLogger.logExiting(this.getClass());
    }

    private void saveReportOrLog() {
        IrbsLogger.logEntering(this.getClass());
        if (this.isLogFile) {
            try {
                this.setStatusMessage(irbsBundle.getString("reportSavingLogFile") + ", \"" + this.getLogFile() + "\"", 2);
                this.textEditPane.getText();
                StringBuffer bufStr = new StringBuffer(irbsBundle.getString("reportSavedByUser")).append(", \"").append(USER_NAME).append("\", ").append(irbsBundle.getString("reportSaveTime")).append(": ").append(new Date().toString()).append("\n\n").append(this.textEditPane.getText());
                this.reportAndLogHandler.saveLogFile(bufStr);
                this.updateTextPane(bufStr.toString());
                this.setStatusMessage(irbsBundle.getString("reportSavedLogFile") + ", \"" + this.getLogFile() + "\"", 2);
            }
            catch (Exception e) {
                this.clearStatusMessage();
                String errorMessage = irbsBundle.getString("reportFailedToSaveLogFile") + ", \"" + this.getLogFileName() + "\"\n" + REASON_LABEL + ": " + IrbsHelper.getExceptionMessage(e);
                IrbsLogger.logError(this.getClass(), errorMessage, e);
                ErrorDialog.displayError(null, irbsBundle.getString("reportSaveLogErrorTitle"), errorMessage, IrbsHelper.convertToString(e));
            }
        } else {
            try {
                StringBuffer prependString = new StringBuffer(irbsBundle.getString("reportSavedByUser")).append(", \"").append(USER_NAME).append("\", ").append(irbsBundle.getString("reportSaveTime")).append(": ").append(new Date().toString()).append("\n\n");
                int reportFileLength = this.textEditPane.getText().length();
                if (reportFileLength > 64900 - prependString.length()) {
                    String errorMessage = irbsBundle.getString("reportFileLengthExceeded") + ". Max size: " + 64900 + ", current size: " + reportFileLength;
                    IrbsLogger.logWarning(this.getClass(), errorMessage);
                    ErrorDialog.displayError(null, irbsBundle.getString("reportSaveReportErrorTitle"), errorMessage, null);
                } else {
                    this.setStatusMessage(irbsBundle.getString("reportSavingReportFile") + ", \"" + this.getReportFile() + "\"", 2);
                    StringBuffer bufStr = new StringBuffer(prependString.toString()).append(this.textEditPane.getText());
                    this.reportAndLogHandler.saveReportFile(bufStr);
                    this.updateTextPane(bufStr.toString());
                    this.setStatusMessage(irbsBundle.getString("reportSavedReportFile") + ", \"" + this.getReportFile() + "\"", 2);
                }
            }
            catch (Exception e) {
                this.clearStatusMessage();
                String errorMessage = irbsBundle.getString("reportFailedToSaveReportFile") + ", \"" + this.getReportFileName() + "\"\n" + REASON_LABEL + ": " + IrbsHelper.getExceptionMessage(e);
                IrbsLogger.logError(this.getClass(), errorMessage, e);
                ErrorDialog.displayError(null, irbsBundle.getString("reportSaveReportErrorTitle"), errorMessage, IrbsHelper.convertToString(e));
            }
        }
        IrbsLogger.logExiting(this.getClass());
    }

    public final void checkFileForChangesAndSave() {
        IrbsLogger.logEntering(this.getClass());
        if (this.reportMenuBar.fileSaveMenu.isSaveNeeded()) {
            String message;
            String title;
            if (this.isLogFile) {
                title = irbsBundle.getString("reportLogFileChangedTitle");
                message = irbsBundle.getString("reportLogFileModified");
            } else {
                title = irbsBundle.getString("reportReportFileChangedTitle");
                message = irbsBundle.getString("reportReportFileModified");
            }
            IrbsLogger.logWarning(this.getClass(), message);
            int result = IrbsHelper.displayConfirmationMessage(title, message, 0);
            if (result == 0) {
                this.saveReportOrLog();
            }
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private KeyListener createTextEditKeyListener() {
        return new KeyListener(){

            public void keyPressed(KeyEvent notUsed) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                int modifiers = keyEvent.getModifiers();
                if (keyEvent.getKeyCode() == 83 && (modifiers & 2) != 0) {
                    ReportAndLogDialog.this.reportMenuBar.fileSaveMenu.saved();
                    ReportAndLogDialog.this.saveReportOrLog();
                }
            }

            public void keyTyped(KeyEvent notUsed) {
            }
        };
    }

    private ActionListener createEditListerner(final JMenuItem editMenu) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                editMenu.setSelected(!editMenu.isSelected());
                ReportAndLogDialog.this.textEditPane.setEditable(editMenu.isSelected());
                if (editMenu.isSelected()) {
                    editMenu.setText(irbsBundle.getString("reportDisableEditMenu"));
                    ReportAndLogDialog.this.setStaticStatusMessage(irbsBundle.getString("reportFileEditable"), 2);
                } else {
                    editMenu.setText(irbsBundle.getString("reportEnableEditMenu"));
                    ReportAndLogDialog.this.setStaticStatusMessage(irbsBundle.getString("reportFileNotEditable"), 2);
                }
            }
        };
    }

    private class ReportDocumentListener
    implements DocumentListener {
        private final transient SaveMenu saveMenu;

        public ReportDocumentListener(SaveMenu inputSaveMenu) {
            this.saveMenu = inputSaveMenu;
        }

        public void insertUpdate(DocumentEvent notUsed) {
            this.saveMenu.saveIsNeeded();
        }

        public void removeUpdate(DocumentEvent notUsed) {
            this.saveMenu.saveIsNeeded();
        }

        public void changedUpdate(DocumentEvent notUsed) {
        }
    }

    private class SaveMenu
    extends JMenuItem {
        private transient boolean saveNeeded;

        SaveMenu(String menuName) {
            super(menuName);
            this.saveNeeded = false;
        }

        public void saveIsNeeded() {
            this.setText(irbsBundle.getString("reportSaveNeededMenu"));
            this.saveNeeded = true;
        }

        public void saved() {
            this.setText(irbsBundle.getString("reportSaveMenu"));
            this.saveNeeded = false;
        }

        public boolean isSaveNeeded() {
            return this.saveNeeded;
        }
    }

    class ReportMenu
    extends JMenuBar {
        private final transient SaveMenu fileSaveMenu;
        private final JMenuItem toolsFtpUploadMenu;

        ReportMenu(SmrsFtpInfoProvider smrsFtpInfoProvider, ReportAndLogHandler inputReportAndLogHandler) {
            IrbsLogger.logEntering(this.getClass());
            JMenu fileMenu = new JMenu(irbsBundle.getString("reportFileMenu"));
            this.fileSaveMenu = new SaveMenu(irbsBundle.getString("reportSaveMenu"));
            this.fileSaveMenu.addActionListener(this.createSaveListener());
            fileMenu.add(this.fileSaveMenu);
            fileMenu.addSeparator();
            JMenuItem fileCloseMenu = new JMenuItem(irbsBundle.getString("reportCloseMenu"));
            fileCloseMenu.addActionListener(this.createCloseListener());
            fileMenu.add(fileCloseMenu);
            this.add(fileMenu);
            JMenu editMenu = new JMenu(irbsBundle.getString("reportEditMenu"));
            JMenuItem editEditMenu = new JMenuItem(irbsBundle.getString("reportEnableEdit"));
            editEditMenu.addActionListener(ReportAndLogDialog.this.createEditListerner(editEditMenu));
            editEditMenu.setSelected(false);
            editMenu.add(editEditMenu);
            this.add(editMenu);
            JMenu toolsMenu = new JMenu(irbsBundle.getString("reportToolsMenu"));
            if (ReportAndLogDialog.this.isLogFile) {
                this.toolsFtpUploadMenu = new JMenuItem(irbsBundle.getString("reportUploadToFtpServer"));
                this.toolsFtpUploadMenu.addActionListener(this.createToolsFtpListener(smrsFtpInfoProvider, inputReportAndLogHandler));
            } else {
                this.toolsFtpUploadMenu = new JMenuItem(irbsBundle.getString("reportUploadToFtpSmrs"));
                this.toolsFtpUploadMenu.addActionListener(this.createToolsSmrsListener(smrsFtpInfoProvider, inputReportAndLogHandler));
            }
            toolsMenu.add(this.toolsFtpUploadMenu);
            this.add(toolsMenu);
            IrbsLogger.logExiting(this.getClass());
        }

        public final void setEnableFtpMenu(boolean enableFtpMenu) {
            this.toolsFtpUploadMenu.setEnabled(enableFtpMenu);
        }

        private ActionListener createSaveListener() {
            return new ActionListener(){

                public void actionPerformed(ActionEvent notUsed) {
                    ReportMenu.this.fileSaveMenu.saved();
                    ReportAndLogDialog.this.saveReportOrLog();
                }
            };
        }

        private ActionListener createCloseListener() {
            return new ActionListener(){

                public void actionPerformed(ActionEvent notUsed) {
                    ReportAndLogDialog.this.close();
                }
            };
        }

        private final ActionListener createToolsSmrsListener(final SmrsFtpInfoProvider smrsFtpInfoProvider, final ReportAndLogHandler inputReportAndLogHandler) {
            return new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent notUsed) {
                    ReportAndLogDialog reportAndLogDialog = ReportAndLogDialog.this;
                    synchronized (reportAndLogDialog) {
                        try {
                            ReportMenu.this.setEnableFtpMenu(false);
                            FtpUploadDialog ftpUploadDialog = new FtpUploadDialog(ReportAndLogDialog.this.parent, smrsFtpInfoProvider, ReportAndLogDialog.this, inputReportAndLogHandler, false);
                            ftpUploadDialog.addWindowListener(ReportMenu.this.createFtpUploadFrameListener());
                            ftpUploadDialog.setVisible(true);
                        }
                        catch (Exception e) {
                            String errorMessage = irbsBundle.getString("reportSmrsFailedLaunchUploadDlg") + REASON_LABEL + ": " + IrbsHelper.getExceptionMessage(e);
                            IrbsLogger.logError(this.getClass(), errorMessage, e);
                            ErrorDialog.displayError(null, irbsBundle.getString("reportSmrsFtpUploadErrorTitle"), errorMessage, IrbsHelper.convertToString(e));
                        }
                    }
                }
            };
        }

        private final ActionListener createToolsFtpListener(final SmrsFtpInfoProvider smrsFtpInfoProvider, final ReportAndLogHandler inputReportAndLogHandler) {
            return new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent notUsed) {
                    ReportAndLogDialog reportAndLogDialog = ReportAndLogDialog.this;
                    synchronized (reportAndLogDialog) {
                        try {
                            ReportMenu.this.setEnableFtpMenu(false);
                            FtpUploadDialog ftpUploadDialog = new FtpUploadDialog(ReportAndLogDialog.this.parent, smrsFtpInfoProvider, ReportAndLogDialog.this, inputReportAndLogHandler, true);
                            ftpUploadDialog.addWindowListener(ReportMenu.this.createFtpUploadFrameListener());
                            ftpUploadDialog.setVisible(true);
                        }
                        catch (Exception e) {
                            String errorMessage = irbsBundle.getString("reportFtpFailedLaunchUploadDlg") + REASON_LABEL + ": " + IrbsHelper.getExceptionMessage(e);
                            IrbsLogger.logError(this.getClass(), errorMessage, e);
                            ErrorDialog.displayError(null, irbsBundle.getString("reportFtpFtpUploadErrorTitle"), errorMessage, IrbsHelper.convertToString(e));
                        }
                    }
                }
            };
        }

        private WindowListener createFtpUploadFrameListener() {
            WindowAdapter windowAdapter = new WindowAdapter(){

                public void windowClosed(WindowEvent e) {
                    ReportMenu.this.setEnableFtpMenu(true);
                }
            };
            return windowAdapter;
        }

        protected JMenuItem getSaveMenu() {
            return this.fileSaveMenu;
        }
    }
}

