/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.dialog;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import se.ericsson.lte.rbs.omf.em.ImageHelper;
import se.ericsson.lte.rbs.omf.em.component.panel.InputDataException;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsHelper;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.irbs.RbsStateInformer;
import se.ericsson.lte.rbs.omf.em.irbs.RicErrorListener;
import se.ericsson.lte.rbs.omf.em.irbs.dialog.RicErrorDialog;
import se.ericsson.lte.rbs.omf.em.irbs.parser.ProgressReportData;

public class RicErrorDisplayer
extends Thread {
    private static final ResourceBundle IRBS_ERROR = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.IrbsError", Locale.getDefault());
    private static final Object WAIT_MUTEX = new Object();
    protected final List<ProgressReportData> progressDataList = new ArrayList<ProgressReportData>();
    private final Frame parentFrame;
    private final RicErrorListener ricErrorListener;
    private final RbsStateInformer rbsStateInformer;
    private boolean errorDialogBeingDisplayed = false;
    protected long sleepingTime = 10000L;
    private boolean keepRunning = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RicErrorDisplayer(Frame inputParentFrame, RicErrorListener inputRicErrorListener, RbsStateInformer inputRbsStateInformer) {
        super("Progress Displaying Thread");
        this.parentFrame = inputParentFrame;
        this.ricErrorListener = inputRicErrorListener;
        this.rbsStateInformer = inputRbsStateInformer;
        this.start();
        List<ProgressReportData> list = this.progressDataList;
        synchronized (list) {
            try {
                this.progressDataList.wait(500L);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(ProgressReportData progressReportData) {
        IrbsLogger.logEntering(this.getClass());
        if (!this.errorDialogBeingDisplayed) {
            List<ProgressReportData> list = this.progressDataList;
            synchronized (list) {
                this.progressDataList.add(progressReportData);
                this.progressDataList.notifyAll();
            }
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private final ActionListener createRicErrorDialogCloseListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                RicErrorDisplayer.this.ricErrorListener.closeButtonPressed();
            }
        };
    }

    private final ActionListener createRicErrorDialogOkListener(final RicErrorDialog ricErrorDialog) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                RicErrorDisplayer.this.ricErrorListener.okButtonPressed(ricErrorDialog.getRicFieldPanel().getText());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.keepRunning) {
            try {
                List<ProgressReportData> list;
                ProgressReportData progressReportData = this.getProgressReportData();
                if (progressReportData == null) {
                    try {
                        list = this.progressDataList;
                        synchronized (list) {
                            this.progressDataList.notifyAll();
                            this.progressDataList.wait(500L);
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    this.displayDialog(progressReportData);
                }
                list = this.progressDataList;
                synchronized (list) {
                    if (this.rbsStateInformer.isCanceled() || this.rbsStateInformer.isBeingCanceled()) {
                        this.progressDataList.clear();
                    }
                    this.progressDataList.notifyAll();
                }
            }
            catch (Exception e) {
                IrbsLogger.logError(this.getClass(), "Failed to display error dialog", e);
            }
            this.errorDialogBeingDisplayed = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProgressReportData getProgressReportData() {
        ProgressReportData progressReportData = null;
        List<ProgressReportData> list = this.progressDataList;
        synchronized (list) {
            if (!this.progressDataList.isEmpty()) {
                progressReportData = this.progressDataList.remove(0);
            }
        }
        return progressReportData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayDialog(ProgressReportData progressReportData) throws ImageHelper.ResourceException, InputDataException {
        RicErrorDialog ricErrorDialog = new RicErrorDialog(IRBS_ERROR.getString("ERR_ISCF_RIC_NOT_MATCH"), progressReportData.getProgressReportDataSmrsError().getSmrsErrorMessage(), this.parentFrame);
        ricErrorDialog.getOkButton().addActionListener(this.createRicErrorDialogOkListener(ricErrorDialog));
        ricErrorDialog.getCloseButton().addActionListener(this.createRicErrorDialogCloseListener());
        this.errorDialogBeingDisplayed = true;
        ricErrorDialog.setVisible(!IrbsHelper.testMode);
        Object object = this.progressDataList;
        synchronized (object) {
            this.progressDataList.clear();
        }
        try {
            object = WAIT_MUTEX;
            synchronized (object) {
                WAIT_MUTEX.wait(this.sleepingTime);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRunning() {
        Object object = this.progressDataList;
        synchronized (object) {
            this.keepRunning = false;
            this.progressDataList.notifyAll();
        }
        object = WAIT_MUTEX;
        synchronized (object) {
            WAIT_MUTEX.notifyAll();
        }
    }
}

