/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.dialog;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import se.ericsson.lte.rbs.omf.em.ImageHelper;
import se.ericsson.lte.rbs.omf.em.component.panel.InputDataException;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsHelper;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.irbs.RbsStateInformer;
import se.ericsson.lte.rbs.omf.em.irbs.SmrsErrorListener;
import se.ericsson.lte.rbs.omf.em.irbs.dialog.SmrsErrorDialog;
import se.ericsson.lte.rbs.omf.em.irbs.parser.ProgressReportData;

public class SmrsErrorDisplayer
extends Thread {
    private static final ResourceBundle IRBS_ERROR = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.IrbsError", Locale.getDefault());
    private static final Object WAIT_MUTEX = new Object();
    protected final List<ProgressReportData> progressDataList = new ArrayList<ProgressReportData>();
    private final Frame parentFrame;
    private final SmrsErrorListener progressErrorListener;
    private final RbsStateInformer rbsStateInformer;
    private boolean errorDialogBeingDisplayed = false;
    protected long sleepingTime = 10000L;
    private boolean keepRunning = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmrsErrorDisplayer(Frame inputParentFrame, SmrsErrorListener inputProgressErrorListener, RbsStateInformer inputRbsStateInformer) {
        super("Progress Displaying THread");
        this.parentFrame = inputParentFrame;
        this.progressErrorListener = inputProgressErrorListener;
        this.rbsStateInformer = inputRbsStateInformer;
        this.start();
        List<ProgressReportData> list = this.progressDataList;
        synchronized (list) {
            try {
                this.progressDataList.wait(500L);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(ProgressReportData progressReportData) {
        IrbsLogger.logEntering(this.getClass());
        List<ProgressReportData> list = this.progressDataList;
        synchronized (list) {
            if (!this.errorDialogBeingDisplayed) {
                this.progressDataList.add(progressReportData);
                this.progressDataList.notifyAll();
            }
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private final ActionListener createProgressErrorDialogCloseListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                SmrsErrorDisplayer.this.progressErrorListener.closeButtonPressed();
            }
        };
    }

    private final ActionListener createProgressErrorDialogOkListener(final SmrsErrorDialog progressErrorDialog) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent notUsed) {
                SmrsErrorDisplayer.this.progressErrorListener.okButtonPressed(progressErrorDialog.getUserNamePanel().getText(), progressErrorDialog.getPasswordPanel().getText(), progressErrorDialog.getServerPanel().getText(), progressErrorDialog.getSummaryFilePathPanel().getText());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.keepRunning) {
            try {
                List<ProgressReportData> list;
                ProgressReportData progressReportData = this.getProgressReportData();
                if (progressReportData == null) {
                    try {
                        list = this.progressDataList;
                        synchronized (list) {
                            this.progressDataList.notifyAll();
                            this.progressDataList.wait(500L);
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    this.displayDialog(progressReportData);
                }
                list = this.progressDataList;
                synchronized (list) {
                    if (this.rbsStateInformer.isCanceled() || this.rbsStateInformer.isBeingCanceled()) {
                        this.progressDataList.clear();
                    }
                    this.progressDataList.notifyAll();
                }
            }
            catch (Exception e) {
                IrbsLogger.logError(this.getClass(), "Failed to display error dialog", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayDialog(ProgressReportData progressReportData) throws ImageHelper.ResourceException, InputDataException {
        SmrsErrorDialog progressErrorDialog = new SmrsErrorDialog(IRBS_ERROR.getString("ERR_WRONG_SMRS_INFO"), progressReportData.getProgressReportDataSmrsError().getSmrsErrorUserName(), progressReportData.getProgressReportDataSmrsError().getSmrsErrorServer(), progressReportData.getProgressReportDataSmrsError().getSmrsErrorSummaryFilePath(), progressReportData.getProgressReportDataSmrsError().getSmrsErrorMessage(), this.parentFrame);
        progressErrorDialog.getOkButton().addActionListener(this.createProgressErrorDialogOkListener(progressErrorDialog));
        progressErrorDialog.getCloseButton().addActionListener(this.createProgressErrorDialogCloseListener());
        this.errorDialogBeingDisplayed = true;
        progressErrorDialog.setVisible(!IrbsHelper.testMode);
        this.errorDialogBeingDisplayed = false;
        Object object = this.progressDataList;
        synchronized (object) {
            this.progressDataList.clear();
        }
        try {
            object = WAIT_MUTEX;
            synchronized (object) {
                WAIT_MUTEX.wait(this.sleepingTime);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProgressReportData getProgressReportData() {
        ProgressReportData progressReportData = null;
        List<ProgressReportData> list = this.progressDataList;
        synchronized (list) {
            if (!this.progressDataList.isEmpty()) {
                progressReportData = this.progressDataList.remove(0);
            }
        }
        return progressReportData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRunning() {
        Object object = this.progressDataList;
        synchronized (object) {
            this.keepRunning = false;
            this.progressDataList.notifyAll();
        }
        object = WAIT_MUTEX;
        synchronized (object) {
            WAIT_MUTEX.notifyAll();
        }
    }
}

