/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.parser;

import java.io.ByteArrayInputStream;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.irbs.dialog.IntegrationProcess;
import se.ericsson.lte.rbs.omf.em.irbs.parser.IntegrationGroup;
import se.ericsson.lte.rbs.omf.em.irbs.parser.IntegrationStep;
import se.ericsson.lte.rbs.omf.em.irbs.parser.ProgressReportData;
import se.ericsson.lte.rbs.omf.em.irbs.parser.ProgressTree;

public class ProgressReportParser
extends DefaultHandler {
    private boolean detailedInfoFlag = false;
    private boolean smrsErrorMessageFlag = false;
    private boolean updateGroupAndStepInfoFlag = false;
    private final StringBuffer detailedInformationData;
    private final StringBuffer smrsErrorMessageData;
    private final ProgressReportData progressReportData;
    private final ProgressTree progressTree;
    private DefaultMutableTreeNode currentSubNode = null;
    private IntegrationGroup integrationGroup = null;
    private IntegrationStep integrationStep = null;
    private final IntegrationProcess integrationProcess = new IntegrationProcess();
    private String currentIntegrationGroupName = "";
    private String currentIntegrationGroupMessage = "";
    private String currentIntegrationStepName = "";
    private String currentIntegrationStepMessage = "";
    private int numberOfSkipped = 0;
    private int numberOfFinished = 0;
    private int numberOfFailed = 0;
    private int totalNumberOfSteps = 0;

    public ProgressReportParser() {
        this.detailedInformationData = new StringBuffer(500);
        this.smrsErrorMessageData = new StringBuffer(500);
        this.progressReportData = new ProgressReportData();
        this.progressTree = new ProgressTree("RBS Integration");
    }

    public void startDocument() throws SAXException {
        this.storeRicErrorData(false);
    }

    public void characters(char[] charArray, int start, int length) throws SAXException {
        if (this.detailedInfoFlag) {
            String dataStr = new String(charArray, start, length);
            this.detailedInformationData.append(dataStr);
        } else if (this.smrsErrorMessageFlag) {
            String dataStr = new String(charArray, start, length);
            this.smrsErrorMessageData.append(dataStr);
        }
    }

    public void endElement(String namespaceUri, String localName, String qName) throws SAXException {
        if ("DetailedInformation".equalsIgnoreCase(qName)) {
            this.detailedInfoFlag = false;
            this.storeDetailedInformationData();
        } else if ("SmrsInfo".equalsIgnoreCase(qName)) {
            this.smrsErrorMessageFlag = false;
            this.storeSmrsErrorMessageData();
        } else if ("RicInfo".equalsIgnoreCase(qName)) {
            this.storeRicErrorData(true);
        } else if ("IntegrationProcess".equalsIgnoreCase(qName)) {
            this.calculateAndStoreProgressLevel();
            this.progressReportData.setProgressTreeNodes(this.progressTree.getNodes());
        } else if ("IntegrationGroup".equalsIgnoreCase(qName)) {
            this.progressReportData.addIntegrationGroup(this.integrationGroup);
        } else if ("IntegrationStep".equalsIgnoreCase(qName)) {
            this.setIntegrationStepData();
        }
    }

    private void setIntegrationStepData() {
        this.integrationGroup.addIntegrationStep(this.integrationStep);
        this.progressReportData.addIntegrationStep(this.integrationStep);
        this.progressTree.addIntegrationStep(this.integrationStep.getName(), this.integrationStep.getStatus(), this.currentSubNode);
        if (this.updateGroupAndStepInfoFlag) {
            this.updateGroupAndStepInfo();
            this.updateGroupAndStepInfoFlag = false;
        }
    }

    public void error(SAXParseException saxParseException) throws SAXException {
        IrbsLogger.logEntering(this.getClass());
        IrbsLogger.logError(this.getClass(), saxParseException.getMessage());
        IrbsLogger.logExiting(this.getClass());
    }

    public void fatalError(SAXParseException saxParseException) throws SAXException {
        IrbsLogger.logEntering(this.getClass());
        IrbsLogger.logError(this.getClass(), saxParseException.getMessage());
        IrbsLogger.logExiting(this.getClass());
    }

    public ProgressReportData getProgressReportData() {
        return this.progressReportData;
    }

    public void parse(String xmlString) {
        IrbsLogger.logEntering(this.getClass());
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
            InputSource input = new InputSource(bais);
            saxParser.parse(input, (DefaultHandler)this);
        }
        catch (Exception e) {
            IrbsLogger.logError(this.getClass(), "Failed to parse the progress report: \"" + xmlString + "\". Reason: " + e.getMessage());
        }
        IrbsLogger.logExiting(this.getClass());
    }

    public void startElement(String namespaceUri, String localName, String qName, Attributes attributes) throws SAXException {
        this.checkAndResetDetailedInformationData();
        this.checkAndResetSmrsErrorMessageData();
        this.checkAndHandleIntegrationGroupTag(qName, attributes);
        this.checkAndHandleIntegrationStepTag(qName, attributes);
        this.checkAndHandleIntegrationProcessTag(qName, attributes);
        this.checkAndHandleDetailedInformationTag(qName);
        this.checkAndHandleSmrsInfoTag(qName, attributes);
        this.checkAndHandleIpAddressAfterRebootTag(qName, attributes);
        this.checkAndHandleStartableTag(qName, attributes);
        this.checkAndHandleStartedTag(qName, attributes);
        this.checkAndHandleFinishedTag(qName, attributes);
        this.checkAndHandleCancelledTag(qName, attributes);
        this.checkAndHandleCancelableTag(qName, attributes);
    }

    private void checkAndHandleIntegrationGroupTag(String qName, Attributes attributes) {
        if ("IntegrationGroup".equalsIgnoreCase(qName)) {
            this.integrationGroup = new IntegrationGroup();
            this.storeIntegrationGroupData(attributes);
        }
    }

    private void checkAndHandleIntegrationStepTag(String qName, Attributes attributes) {
        if ("IntegrationStep".equalsIgnoreCase(qName)) {
            this.integrationStep = new IntegrationStep();
            this.storeIntegrationStepData(attributes);
        }
    }

    private void checkAndHandleIntegrationProcessTag(String qName, Attributes attributes) {
        if ("IntegrationProcess".equalsIgnoreCase(qName)) {
            this.storeRevision(attributes);
        }
    }

    private void checkAndHandleDetailedInformationTag(String qName) {
        if ("DetailedInformation".equalsIgnoreCase(qName)) {
            this.detailedInfoFlag = true;
        }
    }

    private void checkAndHandleSmrsInfoTag(String qName, Attributes attributes) {
        if ("SmrsInfo".equalsIgnoreCase(qName)) {
            this.smrsErrorMessageFlag = true;
            this.storeSmrsErrorData(attributes);
        }
    }

    private void checkAndHandleIpAddressAfterRebootTag(String qName, Attributes attributes) {
        if ("IpAddressAfterReboot".equalsIgnoreCase(qName)) {
            this.storeIpAddress(attributes);
        }
    }

    private void checkAndHandleStartableTag(String qName, Attributes attributes) {
        if ("RbsIntegrationCanBeStarted".equalsIgnoreCase(qName)) {
            this.storeStartableFlag(attributes);
        }
    }

    private void checkAndHandleStartedTag(String qName, Attributes attributes) {
        if ("RbsIntegrationStarted".equalsIgnoreCase(qName)) {
            this.storeStartedFlag(attributes);
        }
    }

    private void checkAndHandleFinishedTag(String qName, Attributes attributes) {
        if ("RbsIntegrationFinished".equalsIgnoreCase(qName)) {
            this.storeFinishedFlag(attributes);
        }
    }

    private void checkAndHandleCancelledTag(String qName, Attributes attributes) {
        if ("RbsIntegrationCancelled".equalsIgnoreCase(qName)) {
            this.storeCancelledFlag(attributes);
        }
    }

    private void checkAndHandleCancelableTag(String qName, Attributes attributes) {
        if ("RbsIntegrationCanBeCancelled".equalsIgnoreCase(qName)) {
            this.storeCancelableFlag(attributes);
        }
    }

    private void checkAndResetDetailedInformationData() {
        if (!this.detailedInfoFlag) {
            this.detailedInformationData.setLength(0);
        }
    }

    private void checkAndResetSmrsErrorMessageData() {
        if (!this.smrsErrorMessageFlag) {
            this.smrsErrorMessageData.setLength(0);
        }
    }

    private void calculateAndStoreProgressLevel() {
        IrbsLogger.logEntering(this.getClass());
        int progressLevel = 0;
        if (this.totalNumberOfSteps != 0) {
            progressLevel = 100 * (this.numberOfFinished + this.numberOfFailed + this.numberOfSkipped) / this.totalNumberOfSteps;
        }
        this.progressReportData.setProgressLevel(progressLevel);
        IrbsLogger.logExiting(this.getClass());
    }

    private void storeCancelledFlag(Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        for (int index = 0; index < attributes.getLength(); ++index) {
            if (!attributes.getQName(index).equalsIgnoreCase("value")) continue;
            this.progressReportData.getProgressReportDataState().setCancelled(Boolean.parseBoolean(attributes.getValue(index)));
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void storeCancelableFlag(Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        for (int index = 0; index < attributes.getLength(); ++index) {
            if (!attributes.getQName(index).equalsIgnoreCase("value")) continue;
            this.progressReportData.getProgressReportDataState().setCancelable(Boolean.parseBoolean(attributes.getValue(index)));
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void storeDetailedInformationData() {
        this.integrationStep.setDetailedInformation(this.detailedInformationData.toString());
        this.currentIntegrationStepMessage = this.detailedInformationData.toString();
    }

    private void storeRicErrorData(boolean ricIsFaulty) {
        this.progressReportData.setRicFaulty(ricIsFaulty);
    }

    private void storeSmrsErrorMessageData() {
        this.progressReportData.getProgressReportDataSmrsError().setSmrsErrorMessage(this.smrsErrorMessageData.toString());
    }

    private void storeSmrsErrorData(Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        for (int index = 0; index < attributes.getLength(); ++index) {
            if (attributes.getQName(index).equalsIgnoreCase("smrsUserName")) {
                this.progressReportData.getProgressReportDataSmrsError().setSmrsErrorUserName(attributes.getValue(index));
                continue;
            }
            if (attributes.getQName(index).equalsIgnoreCase("smrsServer")) {
                this.progressReportData.getProgressReportDataSmrsError().setSmrsErrorServer(attributes.getValue(index));
                continue;
            }
            if (!attributes.getQName(index).equalsIgnoreCase("summaryFilePath")) continue;
            this.progressReportData.getProgressReportDataSmrsError().setSmrsErrorSummaryFilePath(attributes.getValue(index));
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void storeFinishedFlag(Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        for (int index = 0; index < attributes.getLength(); ++index) {
            if (!attributes.getQName(index).equalsIgnoreCase("value")) continue;
            this.progressReportData.getProgressReportDataState().setFinished(Boolean.parseBoolean(attributes.getValue(index)));
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void storeIntegrationGroupData(Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        for (int index = 0; index < attributes.getLength(); ++index) {
            if (attributes.getQName(index).equalsIgnoreCase("name")) {
                this.integrationGroup.setName(attributes.getValue(index));
                this.currentIntegrationGroupName = attributes.getValue(index);
                this.currentSubNode = this.progressTree.addIntegrationGroup(attributes.getValue(index));
                continue;
            }
            if (attributes.getQName(index).equalsIgnoreCase("message")) {
                this.integrationGroup.setMessage(attributes.getValue(index));
                this.currentIntegrationGroupMessage = attributes.getValue(index);
                continue;
            }
            if (!attributes.getQName(index).equalsIgnoreCase("group")) continue;
            this.integrationGroup.setGroupNumber(attributes.getValue(index));
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void storeIntegrationStepData(Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        for (int index = 0; index < attributes.getLength(); ++index) {
            if (attributes.getQName(index).equalsIgnoreCase("name")) {
                this.integrationStep.setName(attributes.getValue(index));
                this.currentIntegrationStepName = attributes.getValue(index);
                continue;
            }
            if (attributes.getQName(index).equalsIgnoreCase("status")) {
                this.setIntegrationStepStatus(attributes.getValue(index).toUpperCase());
                continue;
            }
            if (attributes.getQName(index).equalsIgnoreCase("timeStamp")) {
                this.integrationStep.setTimeStamp(attributes.getValue(index));
                continue;
            }
            if (!attributes.getQName(index).equalsIgnoreCase("step")) continue;
            this.integrationStep.setStepNumber(attributes.getValue(index));
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void setIntegrationStepStatus(String status) {
        if ("SKIPPED".equalsIgnoreCase(status)) {
            ++this.numberOfSkipped;
        }
        if ("FINISHED".equalsIgnoreCase(status)) {
            ++this.numberOfFinished;
        } else if ("FAILED".equalsIgnoreCase(status)) {
            ++this.numberOfFailed;
        } else if ("EXECUTING".equalsIgnoreCase(status) || "RETRYING".equalsIgnoreCase(status)) {
            this.updateGroupAndStepInfoFlag = true;
        }
        ++this.totalNumberOfSteps;
        this.integrationStep.setStatus(this.integrationProcess.getStatusFromString(status));
    }

    private void storeIpAddress(Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        for (int index = 0; index < attributes.getLength(); ++index) {
            if (!attributes.getQName(index).equalsIgnoreCase("ipAddress")) continue;
            this.progressReportData.setIpAddress(attributes.getValue(index));
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void storeRevision(Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        for (int index = 0; index < attributes.getLength(); ++index) {
            if (!attributes.getQName(index).equalsIgnoreCase("revision")) continue;
            this.progressReportData.setRevision(attributes.getValue(index));
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void storeStartableFlag(Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        for (int index = 0; index < attributes.getLength(); ++index) {
            if (!attributes.getQName(index).equalsIgnoreCase("value")) continue;
            this.progressReportData.getProgressReportDataState().setStartable(Boolean.parseBoolean(attributes.getValue(index)));
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void storeStartedFlag(Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        for (int index = 0; index < attributes.getLength(); ++index) {
            if (!attributes.getQName(index).equalsIgnoreCase("value")) continue;
            this.progressReportData.getProgressReportDataState().setStarted(Boolean.parseBoolean(attributes.getValue(index)));
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void updateGroupAndStepInfo() {
        this.progressReportData.getProgressReportDataIntegrationStep().setCurrentGroupName(this.currentIntegrationGroupName);
        this.progressReportData.getProgressReportDataIntegrationStep().setCurrentGroupMessage(this.currentIntegrationGroupMessage);
        this.progressReportData.getProgressReportDataIntegrationStep().setCurrentStepName(this.currentIntegrationStepName);
        this.progressReportData.getProgressReportDataIntegrationStep().setCurrentStepMessage(this.currentIntegrationStepMessage);
    }
}

