/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.parser;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsHelper;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.irbs.parser.SiteInstallationData;
import se.ericsson.lte.rbs.omf.em.irbs.parser.SiteInstallationXmlTags;

public class SiteInstallationFileParser
extends DefaultHandler {
    private final transient SiteInstallationData siteInstallationData;
    private final transient StringBuffer elementData;
    private SAXException saxException = null;

    public SiteInstallationFileParser(String fileToBeParsed) {
        IrbsLogger.logEntering(this.getClass());
        this.siteInstallationData = new SiteInstallationData(fileToBeParsed);
        this.elementData = new StringBuffer();
        IrbsLogger.logExiting(this.getClass());
    }

    public SiteInstallationData parseFile() throws ParserConfigurationException, SAXException, IOException {
        IrbsLogger.logEntering(this.getClass());
        SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
        saxParser.parse((InputStream)new FileInputStream(this.siteInstallationData.parsedFile), (DefaultHandler)this);
        this.logNonParsedData(this.siteInstallationData);
        if (this.saxException != null) {
            throw this.saxException;
        }
        IrbsLogger.logExiting(this.getClass());
        return this.siteInstallationData;
    }

    private void logNonParsedData(SiteInstallationData localSiteInstallationData) {
        String parsedFile = IrbsHelper.doubleQuote(this.siteInstallationData.parsedFile);
        this.logNonParsedData(localSiteInstallationData.logicalName, "No RBS logical name in SiteInstallation file: " + parsedFile);
        this.logNonParsedData(localSiteInstallationData.dhcpClientIdentifier, "No DHCP client identifier in SiteInstallation file: " + parsedFile);
        this.logNonParsedData(localSiteInstallationData.rbsIpAddress, "No RBS IP address in SiteInstallation file: " + parsedFile);
        this.logNonParsedData(localSiteInstallationData.rbsSubnetMask, "No subnet mask in SiteInstallation file: " + parsedFile);
        this.logNonParsedData(localSiteInstallationData.rbsNetworkPrefixLength, "No network prefix length in SiteInstallation file: " + parsedFile);
        this.logNonParsedData(localSiteInstallationData.rbsDefaultRouter, "No default router in SiteInstallation file: " + parsedFile);
        this.logNonParsedData(localSiteInstallationData.rbsDomainName, "No domain name in SiteInstallation file: " + parsedFile);
        this.logNonParsedData(localSiteInstallationData.dnsServer, "No DNS server in SiteInstallation file: " + parsedFile);
        this.logNonParsedData(localSiteInstallationData.smrsServer, "No SMRS server in SiteInstallation file: " + parsedFile);
        this.logNonParsedData(localSiteInstallationData.smrsFilePath, "No SMRS file path in SiteInstallation file: " + parsedFile);
        this.logNonParsedData(localSiteInstallationData.rbsIntegrationCode, "No RBS integration code in SiteInstallation file: " + parsedFile);
        if (localSiteInstallationData.vlanId == -1) {
            IrbsLogger.logWarning(this.getClass(), "No VLAN id in SiteInstallation file: " + parsedFile);
        }
    }

    private void logNonParsedData(String parsedData, String errorMsg) {
        if (parsedData.equals("")) {
            IrbsLogger.logWarning(this.getClass(), errorMsg);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        this.elementData.setLength(0);
        if (!this.checkRevisionInfo(qName, attributes)) {
            IrbsLogger.logWarning(this.getClass(), "Unrecognized revision in site installation file: " + this.siteInstallationData.parsedFile + ". All info might not be read!");
        }
        this.getInstallationData(qName, attributes);
        this.getOamConfgurationData(qName, attributes);
        this.getDnsServer(qName, attributes);
        this.getSmrsData(qName, attributes);
        this.getUntrustedNetworkTemporaryConfigurationData(qName);
        this.getOuterIpConfigurationData(qName, attributes);
        this.getOuterDnsServer(qName, attributes);
        this.getSecurityGateway(qName, attributes);
        this.getInnerIpConfigurationData(qName, attributes);
        this.getInnerDnsServer(qName, attributes);
        IrbsLogger.logExiting(this.getClass());
    }

    private void getSmrsData(String qName, Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        if (qName.equals("SmrsData")) {
            for (int index = 0; index < attributes.getLength(); ++index) {
                if (attributes.getQName(index).equals("address")) {
                    this.siteInstallationData.smrsServer = attributes.getValue(index);
                    continue;
                }
                if (!attributes.getQName(index).equals("summaryFilePath")) continue;
                this.siteInstallationData.smrsFilePath = attributes.getValue(index);
            }
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void getDnsServer(String qName, Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        if (qName.equals("DnsServer") && this.siteInstallationData.dnsServer.equals("")) {
            for (int index = 0; index < attributes.getLength(); ++index) {
                if (!attributes.getQName(index).equals("ipAddress")) continue;
                this.siteInstallationData.dnsServer = attributes.getValue(index);
                break;
            }
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void getUntrustedNetworkTemporaryConfigurationData(String qName) {
        IrbsLogger.logEntering(this.getClass());
        if (qName.equals("UntrustedNetworkTemporaryConfigurationData") && this.siteInstallationData.useUntrustedNetworkTemporaryConfigurationData.equals(Boolean.FALSE)) {
            this.siteInstallationData.useUntrustedNetworkTemporaryConfigurationData = Boolean.TRUE;
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void getOuterDnsServer(String qName, Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        if (qName.equals("OuterDnsServer") && this.siteInstallationData.outerDnsServer.equals("")) {
            for (int index = 0; index < attributes.getLength(); ++index) {
                if (!attributes.getQName(index).equals("ipAddress")) continue;
                this.siteInstallationData.outerDnsServer = attributes.getValue(index);
                break;
            }
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void getInnerDnsServer(String qName, Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        if (qName.equals("InnerDnsServer") && this.siteInstallationData.innerDnsServer.equals("")) {
            for (int index = 0; index < attributes.getLength(); ++index) {
                if (!attributes.getQName(index).equals("ipAddress")) continue;
                this.siteInstallationData.innerDnsServer = attributes.getValue(index);
                break;
            }
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void getInnerIpConfigurationData(String qName, Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        if (qName.equals("InnerIpConfigurationData") && this.siteInstallationData.rbsInnerIpAddress.equals("")) {
            for (int index = 0; index < attributes.getLength(); ++index) {
                if (!attributes.getQName(index).equals("ipAddress")) continue;
                this.siteInstallationData.rbsInnerIpAddress = attributes.getValue(index);
                break;
            }
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void getOuterIpConfigurationData(String qName, Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        if (qName.equals("OuterIpConfigurationData")) {
            this.getOuterIpConfigurationData(attributes);
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void getOuterIpConfigurationData(Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        for (int index = 0; index < attributes.getLength(); ++index) {
            if (attributes.getQName(index).equals("ipAddress")) {
                this.siteInstallationData.rbsOuterIpAddress = attributes.getValue(index);
                continue;
            }
            if (attributes.getQName(index).equals("defaultRouter0")) {
                this.siteInstallationData.rbsOuterDefaultRouter = attributes.getValue(index);
                continue;
            }
            if (!attributes.getQName(index).equals("subnetMask")) continue;
            this.siteInstallationData.rbsOuterSubnetMask = attributes.getValue(index);
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void getSecurityGateway(String qName, Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        if (qName.equals("SecGW")) {
            this.getSecurityGateway(attributes);
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void getSecurityGateway(Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        for (int index = 0; index < attributes.getLength(); ++index) {
            if (attributes.getQName(index).equals("ipAddress")) {
                this.siteInstallationData.securityGatewayAddress = attributes.getValue(index);
                continue;
            }
            if (!attributes.getQName(index).equals("FQDN")) continue;
            this.siteInstallationData.securityGatewayFqdn = attributes.getValue(index);
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void getOamConfgurationData(String qName, Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        if (qName.equals("OamIpConfigurationData")) {
            this.getOamConfgurationData(attributes);
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void getOamConfgurationData(Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        for (int index = 0; index < attributes.getLength(); ++index) {
            if (attributes.getQName(index).equals("ipAddress")) {
                this.siteInstallationData.rbsIpAddress = attributes.getValue(index);
                continue;
            }
            if (attributes.getQName(index).equals("defDomainName")) {
                this.siteInstallationData.rbsDomainName = attributes.getValue(index);
                continue;
            }
            if (attributes.getQName(index).equals("defaultGateway")) {
                this.siteInstallationData.rbsDefaultRouter = attributes.getValue(index);
                continue;
            }
            if (attributes.getQName(index).equals("defaultRouter0")) {
                this.siteInstallationData.rbsDefaultRouter = attributes.getValue(index);
                continue;
            }
            if (attributes.getQName(index).equals("subnetMask")) {
                this.siteInstallationData.rbsSubnetMask = attributes.getValue(index);
                continue;
            }
            if (!attributes.getQName(index).equals("networkPrefixLength")) continue;
            this.siteInstallationData.rbsNetworkPrefixLength = attributes.getValue(index);
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void getInstallationData(String qName, Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        if (qName.equals("InstallationData")) {
            this.getInstallationData(attributes);
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private void getInstallationData(Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        for (int index = 0; index < attributes.getLength(); ++index) {
            if (attributes.getQName(index).equals("vlanId")) {
                this.siteInstallationData.vlanId = this.getVlanId(attributes.getValue(index));
                continue;
            }
            if (attributes.getQName(index).equals("logicalName")) {
                this.siteInstallationData.logicalName = attributes.getValue(index);
                continue;
            }
            if (attributes.getQName(index).equals("uniqueLogicalName")) {
                this.siteInstallationData.uniqueLogicalName = attributes.getValue(index);
                continue;
            }
            if (attributes.getQName(index).equals("dhcpClientIdentifier")) {
                this.siteInstallationData.dhcpClientIdentifier = attributes.getValue(index);
                continue;
            }
            if (!attributes.getQName(index).equals("rbsIntegrationCode")) continue;
            this.siteInstallationData.rbsIntegrationCode = attributes.getValue(index);
        }
        IrbsLogger.logExiting(this.getClass());
    }

    private int getVlanId(String attrValue) {
        int vlanId = -1;
        try {
            vlanId = Integer.parseInt(attrValue);
        }
        catch (NumberFormatException nfe) {
            this.saxException = new SAXException("Specified VLAN id is not an integer. Value is: " + IrbsHelper.doubleQuote(attrValue));
        }
        return vlanId;
    }

    private boolean checkRevisionInfo(String qName, Attributes attributes) {
        IrbsLogger.logEntering(this.getClass());
        boolean knownRevision = false;
        if (qName.equals("Format")) {
            block0: for (int index = 0; index < attributes.getLength(); ++index) {
                if (!"revision".equals(attributes.getQName(index))) continue;
                String revision = attributes.getValue(index);
                for (int revIndex = 0; revIndex < SiteInstallationXmlTags.KNOWN_REVISIONS.length; ++revIndex) {
                    if (!SiteInstallationXmlTags.KNOWN_REVISIONS[revIndex].equals(revision)) continue;
                    knownRevision = true;
                    continue block0;
                }
            }
        } else {
            knownRevision = true;
        }
        IrbsLogger.logExiting(this.getClass());
        return knownRevision;
    }
}

