/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.irbs.report;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.lte.rbs.omf.em.irbs.CmServiceInformer;
import se.ericsson.lte.rbs.omf.em.irbs.Definitions;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsHelper;
import se.ericsson.lte.rbs.omf.em.irbs.IrbsLogger;
import se.ericsson.lte.rbs.omf.em.irbs.notifications.IrbsNotificationEvent;
import se.ericsson.lte.rbs.omf.em.irbs.notifications.IrbsNotificationListener;
import se.ericsson.lte.rbs.omf.em.irbs.report.LogFileException;
import se.ericsson.lte.rbs.omf.em.irbs.report.ReportAndLogHandler;
import se.ericsson.lte.rbs.omf.em.irbs.report.ReportFileException;

public class ReportAndLogHandlerImpl
implements ReportAndLogHandler {
    private final transient Object logMutext = new Object();
    private final transient Object reportMutext = new Object();
    private final transient List<IrbsNotificationListener> listeners = new ArrayList<IrbsNotificationListener>();
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    private transient String lastLogMessage = "#########################################";
    private transient File reportFile = null;
    private transient CmServiceInformer cmServiceInformer = null;
    private transient File logFile = null;

    public ReportAndLogHandlerImpl() throws LogFileException {
        IrbsLogger.logEntering(this.getClass());
        this.logFile = ReportAndLogHandlerImpl.createStartupLogFile();
        IrbsLogger.logExiting(this.getClass());
    }

    public void setCmServiceInformer(CmServiceInformer inputCmServiceInformer) throws ReportFileException {
        IrbsLogger.logEntering(this.getClass());
        this.cmServiceInformer = inputCmServiceInformer;
        if (this.reportFile == null) {
            this.reportFile = this.createReportFile();
        }
        IrbsLogger.logExiting(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createLogFile(String logicalName) throws LogFileException {
        IrbsLogger.logEntering(this.getClass());
        Object object = this.logMutext;
        synchronized (object) {
            this.logFile = ReportAndLogHandlerImpl.createLogFileFromFile(this.logFile, logicalName);
        }
        IrbsLogger.logExiting(this.getClass());
    }

    public static File createLogFileFromFile(File existingLogFile, String logicalName) throws LogFileException {
        try {
            IrbsLogger.logEntering(ReportAndLogHandlerImpl.class);
            ReportAndLogHandlerImpl.createLogDirectory(Definitions.LOG_FILE_LOCATION);
            StringBuffer newLogFileName = new StringBuffer(Definitions.LOG_FILE_LOCATION).append(File.separator).append(logicalName).append("_").append(System.getProperty("user.name")).append(".log");
            if (!existingLogFile.getAbsolutePath().equals(newLogFileName.toString())) {
                File startUpLogFile = existingLogFile;
                FileReader fileReader = new FileReader(startUpLogFile);
                BufferedReader bufReader = new BufferedReader(fileReader);
                FileOutputStream fos = new FileOutputStream(newLogFileName.toString());
                fos.write("########################################################################################################\n".getBytes());
                fos.write(irbsBundle.getString("logFileHeader").getBytes());
                fos.write(" for RBS: ".getBytes());
                fos.write(logicalName.getBytes());
                fos.write("\n".getBytes());
                int index = 0;
                String line = bufReader.readLine();
                while (line != null) {
                    if (index < 2) {
                        ++index;
                    } else {
                        fos.write(line.getBytes());
                        fos.write("\n".getBytes());
                    }
                    line = bufReader.readLine();
                }
                bufReader.close();
                fos.close();
                if (startUpLogFile.exists() && !startUpLogFile.delete()) {
                    IrbsLogger.logError(ReportAndLogHandlerImpl.class, "Could not delete existing log file: " + startUpLogFile);
                }
            }
            IrbsLogger.logExiting(ReportAndLogHandlerImpl.class);
            return new File(newLogFileName.toString());
        }
        catch (Exception e) {
            throw new LogFileException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadReportFile(String smrsServer, String smrsUserName, String smrsPassword, String pathOnSmrsServer) throws ReportFileException {
        IrbsLogger.logEntering(this.getClass());
        Object object = this.reportMutext;
        synchronized (object) {
            CmService cmService = this.cmServiceInformer.getCmService();
            Transaction transaction = cmService.createTransaction();
            try {
                Mo rbsConfigurationMo = cmService.getMo("ManagedElement=1,NodeManagementFunction=1,RbsConfiguration=1");
                NameValue[] params = new NameValue[]{cmService.getNameValueFactory().create("SmrsUserId", smrsUserName), cmService.getNameValueFactory().create("SmrsPassword", smrsPassword), cmService.getNameValueFactory().create("SmrsAddress", smrsServer), cmService.getNameValueFactory().create("configReportFilePath", pathOnSmrsServer)};
                rbsConfigurationMo.action("storeConfigurationReport", params, transaction);
                transaction.commit();
            }
            catch (Exception e) {
                transaction.rollback();
                throw new ReportFileException(e);
            }
        }
        IrbsLogger.logExiting(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLogFile(StringBuffer logFileContents) throws LogFileException {
        IrbsLogger.logEntering(this.getClass());
        Object object = this.logMutext;
        synchronized (object) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.logFile);
                fileOutputStream.write(logFileContents.toString().getBytes());
                fileOutputStream.close();
            }
            catch (Exception e) {
                throw new LogFileException(irbsBundle.getString("logFailedToSaveLogFile"), e);
            }
        }
        IrbsLogger.logExiting(this.getClass());
    }

    public void saveReportFile(StringBuffer reportFileContents) throws ReportFileException {
        IrbsLogger.logEntering(this.getClass());
        try {
            this.updateLocalReportFile(reportFileContents.toString());
        }
        catch (Exception e) {
            throw new ReportFileException(irbsBundle.getString("repFailedToSaveReportFile") + ", \"" + this.reportFile + "\"", e);
        }
        IrbsLogger.logExiting(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getReportFile() throws ReportFileException {
        Object object = this.reportMutext;
        synchronized (object) {
            return this.reportFile;
        }
    }

    public String getReportFileName() {
        return this.reportFile.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getLogFile() {
        Object object = this.logMutext;
        synchronized (object) {
            return this.logFile;
        }
    }

    public String getLogFileName() {
        return this.logFile.getAbsolutePath();
    }

    public void notificationReceived(final IrbsNotificationEvent notificationEvent) {
        Runnable notificationUpdater = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                IrbsLogger.logEntering(this.getClass());
                boolean updated = false;
                try {
                    updated = ReportAndLogHandlerImpl.this.addToLogFile(notificationEvent);
                }
                catch (LogFileException lfe) {
                    IrbsLogger.logError(this.getClass(), "Could not add notification to log file: " + ReportAndLogHandlerImpl.this.logFile, lfe);
                }
                if (!notificationEvent.configurationReport.equals("")) {
                    try {
                        boolean reportFileUpdated = ReportAndLogHandlerImpl.this.updateLocalReportFile(notificationEvent.configurationReport);
                        updated = updated || reportFileUpdated;
                    }
                    catch (ReportFileException rfe) {
                        IrbsLogger.logError(this.getClass(), "Could not update local report file: " + ReportAndLogHandlerImpl.this.reportFile, rfe);
                    }
                }
                if (updated) {
                    List list = ReportAndLogHandlerImpl.this.listeners;
                    synchronized (list) {
                        for (int index = 0; index < ReportAndLogHandlerImpl.this.listeners.size(); ++index) {
                            ((IrbsNotificationListener)ReportAndLogHandlerImpl.this.listeners.get(index)).notificationReceived(notificationEvent);
                        }
                    }
                }
                IrbsLogger.logExiting(this.getClass());
            }
        };
        IrbsHelper.invokeLater(notificationUpdater);
    }

    public static File createStartupLogFile() throws LogFileException {
        IrbsLogger.logEntering(ReportAndLogHandlerImpl.class);
        File localLogFile = null;
        ReportAndLogHandlerImpl.createLogDirectory(Definitions.LOG_FILE_LOCATION);
        localLogFile = new File(Definitions.LOG_FILE_LOCATION + File.separator + System.getProperty("user.name") + ".log");
        localLogFile.deleteOnExit();
        try {
            FileOutputStream fos = new FileOutputStream(localLogFile);
            StringBuilder stringBuilder = new StringBuilder();
            Formatter formatter = new Formatter(stringBuilder, Locale.getDefault());
            formatter.format("%-30s %s\n", irbsBundle.getString("logFileTimeHeader"), irbsBundle.getString("logFileInfoHeader"));
            fos.write("########################################################################################################\n".getBytes());
            fos.write(irbsBundle.getString("logFileHeader").getBytes());
            fos.write("\n".getBytes());
            fos.write("########################################################################################################\n".getBytes());
            fos.write("\n".getBytes());
            fos.write(stringBuilder.toString().getBytes());
            fos.close();
            formatter.close();
            if (!localLogFile.exists()) {
                throw new LogFileException(irbsBundle.getString("logFailedToCreateLogFile") + ": \"" + Definitions.LOG_FILE_LOCATION + "\"");
            }
        }
        catch (IOException ioe) {
            throw new LogFileException(irbsBundle.getString("logFailedToCreateLogDir") + ": \"" + Definitions.LOG_FILE_LOCATION + "\"", ioe);
        }
        IrbsLogger.logExiting(ReportAndLogHandlerImpl.class);
        return localLogFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addToLogFile(IrbsNotificationEvent notificationEvent) throws LogFileException {
        boolean updated = false;
        IrbsLogger.logEntering(this.getClass());
        String currentTimeString = "[" + IrbsHelper.currentDateAndTimeString() + "]";
        Object object = this.logMutext;
        synchronized (object) {
            try {
                String[] notifications = notificationEvent.toStrings();
                for (int i = 0; i < notifications.length; ++i) {
                    if (this.lastLogMessage.equals(notifications[i])) continue;
                    this.lastLogMessage = notifications[i];
                    StringBuilder stringBuilder = new StringBuilder();
                    Formatter formatter = new Formatter(stringBuilder, Locale.getDefault());
                    formatter.format("%-30s %s\n", currentTimeString, this.lastLogMessage);
                    FileOutputStream fileOutputStream = new FileOutputStream(this.logFile, true);
                    fileOutputStream.write(stringBuilder.toString().getBytes());
                    fileOutputStream.close();
                    formatter.close();
                    updated = true;
                }
            }
            catch (Exception e) {
                throw new LogFileException(irbsBundle.getString("logFailedToAddNotificationToLog"), e);
            }
        }
        IrbsLogger.logExiting(this.getClass());
        return updated;
    }

    public String getReportFileContents() throws ReportFileException {
        IrbsLogger.logEntering(this.getClass());
        String result = "";
        Transaction transaction = null;
        try {
            CmService cmService = this.cmServiceInformer.getCmService();
            transaction = cmService.createTransaction();
            Mo rbsConfigurationMo = cmService.getMo("ManagedElement=1,NodeManagementFunction=1,RbsConfiguration=1");
            NameValue configurationReport = rbsConfigurationMo.getAttribute("configurationReport", transaction);
            transaction.commit();
            result = configurationReport.getStringValue();
        }
        catch (Exception e) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw new ReportFileException(irbsBundle.getString("repFailedToAddDataToReportFile"), e);
        }
        IrbsLogger.logExiting(this.getClass());
        return result;
    }

    protected static void createLogDirectory(String logDirectory) throws LogFileException {
        IrbsLogger.logEntering(ReportAndLogHandlerImpl.class);
        File logFileLocation = new File(logDirectory);
        if (!logFileLocation.exists() && !logFileLocation.mkdirs()) {
            throw new LogFileException(irbsBundle.getString("logFailedToCreateLogDir") + ": \"" + Definitions.LOG_FILE_LOCATION + "\"");
        }
        IrbsLogger.logExiting(ReportAndLogHandlerImpl.class);
    }

    protected static void createReportDirectory(String reportDirectory) throws ReportFileException {
        IrbsLogger.logEntering(ReportAndLogHandlerImpl.class);
        File reportFileLocation = new File(reportDirectory);
        if (!reportFileLocation.exists() && !reportFileLocation.mkdirs()) {
            throw new ReportFileException(irbsBundle.getString("repFailedToCreateReportDir") + ": \"" + Definitions.REPORT_FILE_LOCATION + "\"");
        }
        IrbsLogger.logExiting(ReportAndLogHandlerImpl.class);
    }

    private File createReportFile() throws ReportFileException {
        File repFile = null;
        try {
            IrbsLogger.logEntering(this.getClass());
            ReportAndLogHandlerImpl.createReportDirectory(Definitions.REPORT_FILE_LOCATION);
            repFile = File.createTempFile("LTE_report_", ".log", new File(Definitions.REPORT_FILE_LOCATION));
            FileOutputStream fos = new FileOutputStream(repFile);
            fos.write(this.getReportFileContents().getBytes());
            fos.close();
            repFile.deleteOnExit();
        }
        catch (IOException ioe) {
            StringBuffer errorMsg = new StringBuffer(irbsBundle.getString("repFailedToCreateTmpReportFile"));
            if (repFile == null) {
                errorMsg.append(".");
            } else {
                errorMsg.append(": ").append(repFile.getAbsolutePath());
            }
            throw new ReportFileException(errorMsg.toString(), ioe);
        }
        IrbsLogger.logExiting(this.getClass());
        return repFile;
    }

    private boolean updateLocalReportFile(String reportFileContents) throws ReportFileException {
        IrbsLogger.logEntering(this.getClass());
        boolean updated = false;
        try {
            FileOutputStream fos = new FileOutputStream(this.reportFile);
            fos.write(reportFileContents.getBytes());
            fos.close();
            updated = true;
        }
        catch (Exception e) {
            throw new ReportFileException(irbsBundle.getString("reportFailedToSaveLocalReportFile"), e);
        }
        IrbsLogger.logExiting(this.getClass());
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(IrbsNotificationListener irbsNotificationListener) {
        IrbsLogger.logEntering(this.getClass());
        List<IrbsNotificationListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(irbsNotificationListener);
            this.listeners.add(irbsNotificationListener);
        }
        IrbsLogger.logExiting(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(IrbsNotificationListener irbsNotificationListener) {
        IrbsLogger.logEntering(this.getClass());
        List<IrbsNotificationListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(irbsNotificationListener);
        }
        IrbsLogger.logExiting(this.getClass());
    }

    public void update() {
    }

    public void setNode(Node node) {
    }

    public void connectionStateChanged(boolean connected) {
    }
}

