/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.validator;

import se.ericsson.lte.rbs.omf.em.validator.Validator;

public class IntegerValidator
implements Validator {
    private final transient String hint;
    private final transient int minValue;
    private final transient int maxValue;
    private transient String description = "";
    private transient String currentInputString = "";

    public IntegerValidator(String inputHint, int inputMinValue, int inputMaxValue) {
        this.hint = inputHint;
        this.minValue = inputMinValue;
        this.maxValue = inputMaxValue;
    }

    public boolean allowEmpty() {
        return false;
    }

    public boolean valid(String toBeChecked) {
        this.currentInputString = toBeChecked;
        boolean result = false;
        try {
            int intValue = Integer.valueOf(toBeChecked);
            result = intValue >= this.minValue && intValue <= this.maxValue;
        }
        catch (NumberFormatException notUsed) {
            result = false;
        }
        this.description = result ? " " : this.hint;
        return result;
    }

    public String getInputString() {
        return this.currentInputString;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHint() {
        return this.hint;
    }
}

