/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.validator;

import java.util.Locale;
import java.util.ResourceBundle;
import se.ericsson.lte.rbs.omf.em.validator.RegExpPattern;
import se.ericsson.lte.rbs.omf.em.validator.Validator;

public class RegExpValidator
implements Validator {
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    private static final String IPv4_ADDRESS = "((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))";
    private static final String IPv6_ADDRESS = "(s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?s*)";
    private static final String IP_ADDRESS = "(((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5])))|((s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?s*))";
    private static final String HOST_NAME = "(([a-zA-Z0-9])|([a-zA-Z0-9][a-zA-Z0-9\\-]{0,62}[a-zA-Z0-9]))(\\.(([a-zA-Z0-9])|([a-zA-Z0-9][a-zA-Z0-9\\-]{0,62}[a-zA-Z0-9])))*";
    private static final String IP_AND_HOST_NAME = "((((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5])))|((s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?s*)))|((([a-zA-Z0-9])|([a-zA-Z0-9][a-zA-Z0-9\\-]{0,62}[a-zA-Z0-9]))(\\.(([a-zA-Z0-9])|([a-zA-Z0-9][a-zA-Z0-9\\-]{0,62}[a-zA-Z0-9])))*)";
    private static final String PRODUCTION_DATE = "(^19|2[0-9])\\d\\d(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01]$)|(^([0-9])[0-9]W(0[1-9]|[1234][0-9]|5[0123])$)";
    private static final String PRODUCT_NAME = "^.{1,12}$";
    private static final String PRODUCT_NUMBER = "^[a-zA-Z0-9/ ]{1,24}$";
    private static final String PRODUCT_REVISION = "^[a-zA-Z0-9/]{1,7}$";
    private static final String SERIAL_NUMBER = "^[a-zA-Z0-9]{1,13}$";
    private static final String NETWORK_PREFIX_LENGTH = "^[0-9]|[1-9][0-9]|1[1-2][0-8]$";
    public static final RegExpPattern NON_EMPTY_PRODUCTION_DATE_PATTERN = new RegExpPattern(irbsBundle.getString("productionDateValidatorDesc"), "(^19|2[0-9])\\d\\d(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01]$)|(^([0-9])[0-9]W(0[1-9]|[1234][0-9]|5[0123])$)", false);
    public static final RegExpPattern NON_EMPTY_PRODUCT_NAME_PATTERN = new RegExpPattern(irbsBundle.getString("productNameValidatorDesc"), "^.{1,12}$", false);
    public static final RegExpPattern NON_EMPTY_PRODUCT_NUMBER_PATTERN = new RegExpPattern(irbsBundle.getString("productNumberValidatorDesc"), "^[a-zA-Z0-9/ ]{1,24}$", false);
    public static final RegExpPattern NON_EMPTY_PRODUCT_REVISION_PATTERN = new RegExpPattern(irbsBundle.getString("productRevisionValidatorDesc"), "^[a-zA-Z0-9/]{1,7}$", false);
    public static final RegExpPattern NON_EMPTY_SERIAL_NUMBER_PATTERN = new RegExpPattern(irbsBundle.getString("serialNumberValidatorDesc"), "^[a-zA-Z0-9]{1,13}$", false);
    public static final RegExpPattern EMPTY_IP_ADDRESS_PATTERN = new RegExpPattern(irbsBundle.getString("ipAddressValidatorDesc") + " " + irbsBundle.getString("orBeEmpty"), "(((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5])))|((s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?s*))", true);
    public static final RegExpPattern NON_EMPTY_IP_ADDRESS_PATTERN = new RegExpPattern(irbsBundle.getString("ipAddressValidatorDesc"), "(((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5])))|((s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?s*))", false);
    public static final RegExpPattern NON_EMPTY_IPV6_ADDRESS_PATTERN = new RegExpPattern(irbsBundle.getString("ipv6AddressValidatorDesc"), "(s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?s*)", false);
    public static final RegExpPattern EMPTY_HOST_NAME_PATTERN = new RegExpPattern(irbsBundle.getString("hostNameValidatorDesc") + " " + irbsBundle.getString("orBeEmpty"), "(([a-zA-Z0-9])|([a-zA-Z0-9][a-zA-Z0-9\\-]{0,62}[a-zA-Z0-9]))(\\.(([a-zA-Z0-9])|([a-zA-Z0-9][a-zA-Z0-9\\-]{0,62}[a-zA-Z0-9])))*", true);
    public static final RegExpPattern NON_EMPTY_HOST_NAME_PATTERN = new RegExpPattern(irbsBundle.getString("hostNameValidatorDesc"), "(([a-zA-Z0-9])|([a-zA-Z0-9][a-zA-Z0-9\\-]{0,62}[a-zA-Z0-9]))(\\.(([a-zA-Z0-9])|([a-zA-Z0-9][a-zA-Z0-9\\-]{0,62}[a-zA-Z0-9])))*", false);
    public static final RegExpPattern EMPTY_IP_AND_HOST_PATTERN = new RegExpPattern(irbsBundle.getString("ipOrHostNameValidatorDesc") + " " + irbsBundle.getString("orBeEmpty"), "((((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5])))|((s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?s*)))|((([a-zA-Z0-9])|([a-zA-Z0-9][a-zA-Z0-9\\-]{0,62}[a-zA-Z0-9]))(\\.(([a-zA-Z0-9])|([a-zA-Z0-9][a-zA-Z0-9\\-]{0,62}[a-zA-Z0-9])))*)", true);
    public static final RegExpPattern NON_EMPTY_IP_AND_HOST_PATTERN = new RegExpPattern(irbsBundle.getString("ipOrHostNameValidatorDesc"), "((((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d?\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5])))|((s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?s*)))|((([a-zA-Z0-9])|([a-zA-Z0-9][a-zA-Z0-9\\-]{0,62}[a-zA-Z0-9]))(\\.(([a-zA-Z0-9])|([a-zA-Z0-9][a-zA-Z0-9\\-]{0,62}[a-zA-Z0-9])))*)", false);
    public static final RegExpPattern NON_EMPTY_NETWORK_PREFIX_LENGTH_PATTERN = new RegExpPattern(irbsBundle.getString("networkPrefixLengthValidatorDesc"), "^[0-9]|[1-9][0-9]|1[1-2][0-8]$", false);
    private final transient RegExpPattern pattern;
    private transient String description = "";
    private transient String hint = "";
    private transient String currentInputString = "";

    public RegExpValidator(RegExpPattern inputPattern) {
        this.pattern = inputPattern;
        this.hint = this.getHintInfo();
    }

    public boolean allowEmpty() {
        return this.pattern.isEmptyAllowed();
    }

    public boolean valid(String toBeChecked) {
        this.currentInputString = toBeChecked;
        boolean result = this.pattern.isEmptyAllowed() && toBeChecked.length() < 1 || this.pattern.getPattern().matcher(toBeChecked).matches();
        this.hint = this.getHintInfo();
        this.description = result ? " " : this.hint;
        return result;
    }

    public String getInputString() {
        return this.currentInputString;
    }

    private String getHintInfo() {
        return this.pattern.getDescription();
    }

    public String getDescription() {
        return this.description;
    }

    public String getHint() {
        return this.hint;
    }
}

