/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.em.validator;

import java.util.Locale;
import java.util.ResourceBundle;
import se.ericsson.lte.rbs.omf.em.validator.Validator;

public class RemoteFilePathValidator
implements Validator {
    private static final ResourceBundle irbsBundle = ResourceBundle.getBundle("se.ericsson.lte.rbs.omf.em.resources.Irbs", Locale.getDefault());
    private final transient boolean allowEmptyField;
    private transient String description = "";
    private transient String hint = "";
    private transient String currentInputString = "";
    private final transient boolean allowAbsolutePaths;
    private final transient boolean allowRelativePaths;

    public RemoteFilePathValidator(boolean inputAllowEmptyField, boolean inputAllowAbsolutePaths, boolean inputAllowRelativePaths) {
        this.allowEmptyField = inputAllowEmptyField;
        this.allowAbsolutePaths = inputAllowAbsolutePaths;
        this.allowRelativePaths = inputAllowRelativePaths;
        this.hint = this.getHintInfo();
    }

    public boolean allowEmpty() {
        return this.allowEmptyField;
    }

    public boolean valid(String toBeChecked) {
        this.currentInputString = toBeChecked;
        boolean result = false;
        if (this.allowEmptyField) {
            result = true;
        } else if (!this.allowEmptyField && toBeChecked.length() > 0) {
            if (this.allowAbsolutePaths) {
                boolean bl = result = toBeChecked.charAt(0) == '/';
            }
            if (this.allowRelativePaths) {
                result = result || toBeChecked.charAt(0) != '/';
            }
        }
        this.hint = this.getHintInfo();
        this.description = result ? " " : this.hint;
        return result;
    }

    public String getInputString() {
        return this.currentInputString;
    }

    private String getHintInfo() {
        String result = this.allowEmptyField ? irbsBundle.getString("relativePathValidatorDesc") + " " + irbsBundle.getString("orBeEmpty") : irbsBundle.getString("relativePathValidatorDesc");
        return result;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHint() {
        return this.hint;
    }
}

