/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step2;

import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.DbWrapperFactory;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.lte.rbs.omf.aue.step2.Step2HandlerWrapper;

public class AuePersistencyUtil {
    private static final Class THIS_CLASS = AuePersistencyUtil.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public List retrieveFromAuePersistency(ConverterContext converterContext, String string) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "retrieveFromAuePersistency()");
        DbWrapper dbWrapper = this.getDbWrapper();
        ArrayList<String> arrayList = new ArrayList<String>();
        ResultSet resultSet = null;
        String string2 = Step2HandlerWrapper.getInstance().getAuePersistencyTableName(converterContext);
        try {
            dbWrapper.openConnection();
            resultSet = dbWrapper.executeQuery("SELECT value FROM " + string2 + " WHERE name LIKE " + AueUtil.quote((String)(string + "%")));
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
        }
        catch (Exception exception) {
            throw new CrbsAueException("DbWrapper problem", (Throwable)exception);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    logger.traceAbnormal(THIS_CLASS, "Unable to close resultset: " + (Object)((Object)sQLException));
                }
                try {
                    dbWrapper.closeConnection(2);
                }
                catch (SQLException sQLException) {
                    logger.traceAbnormal(THIS_CLASS, "Unable to close connection: " + (Object)((Object)sQLException));
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "retrieveFromAuePersistency()");
        return arrayList;
    }

    private DbWrapper getDbWrapper() throws CrbsAueException {
        DbWrapper dbWrapper;
        try {
            dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
        }
        catch (Exception exception) {
            throw new CrbsAueException(THIS_CLASS.getName() + ": Failed to create DB wrapper.", (Throwable)exception);
        }
        return dbWrapper;
    }
}

