/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step2;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step2.mao.MoRepositoryWrapper;
import se.ericsson.crbs.omf.aue.step2.mao.MoRepositoryWrapperFactory;

public class ChangeIntAttributeValue {
    private static final Class THIS_CLASS = ChangeIntAttributeValue.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final Coordinator coordinator;

    public ChangeIntAttributeValue(Coordinator coordinator) {
        this.coordinator = coordinator;
    }

    public void execute(String string, String string2, int n, int n2) {
        logger.traceEnter(THIS_CLASS, "execute()");
        MoRepositoryWrapper moRepositoryWrapper = MoRepositoryWrapperFactory.getInstance().getMoRepositoryWrapper();
        MoIterator moIterator = moRepositoryWrapper.lookupType(string);
        if (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            try {
                Integer n3 = (Integer)managedObject.getAttribute(string2, this.coordinator);
                if (n3 == n) {
                    managedObject.setAttribute(string2, (Object)new Integer(n2), this.coordinator);
                    logger.traceDebug(THIS_CLASS, string + "." + string2 + " changed from " + n + " to " + n2 + ".");
                }
            }
            catch (NoSuchAttributeException noSuchAttributeException) {
                logger.traceError(THIS_CLASS, "Exception caught when getting attribute " + string + "." + string2, (Throwable)noSuchAttributeException);
            }
            catch (MoAccessException moAccessException) {
                logger.traceError(THIS_CLASS, "Exception caught when getting or setting attribute " + string + "." + string2, (Throwable)moAccessException);
            }
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }
}

