/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step2.actions.it12;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;

public class CopyAndRemapBooleanToIntegerAttributeAction
implements MoDataAction {
    private static final Class THIS_CLASS = CopyAndRemapBooleanToIntegerAttributeAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws AueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        HashMap hashMap = (HashMap)converterContext.getAttribute("moActionArgMap");
        String string = this.getAndCheckParamMapString("fromAttr", hashMap, "The attribute fromAttr is not specified in " + AueUtil.doubleQuote((String)this.getClass().getName()));
        String string2 = this.getAndCheckParamMapString("toAttr", hashMap, "The attribute toAttr is not specified in " + AueUtil.doubleQuote((String)this.getClass().getName()));
        String string3 = this.getAndCheckParamMapString("mapping", hashMap, "The attribute mapping is not specified in " + AueUtil.doubleQuote((String)this.getClass().getName()));
        BooleanAttribute booleanAttribute = this.getBooleanAttributeReferredByFromAttr(moDataWrapper, string);
        IntegerAttribute integerAttribute = this.getIntegerAttributeReferredByToAttr(moDataWrapper, string2);
        int n = this.getMappedValue(coordinator, string3, booleanAttribute);
        integerAttribute.setValue(n);
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    private String getAndCheckParamMapString(String string, Map map, String string2) throws AueException {
        String string3 = (String)map.get(string);
        if (string3 == null || string3.equals("")) {
            throw new AueException(string2);
        }
        return string3;
    }

    private Map parseMappingString(String string) throws AueException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(58);
            if (n < 0) {
                throw new AueException(THIS_CLASS + " attribute mapping contains bad formated mapping: " + string2);
            }
            hashMap.put(string2.substring(0, n), string2.substring(n + 1));
        }
        return hashMap;
    }

    private BooleanAttribute getBooleanAttributeReferredByFromAttr(MoDataWrapper moDataWrapper, String string) throws AueException {
        BooleanAttribute booleanAttribute = null;
        try {
            booleanAttribute = (BooleanAttribute)moDataWrapper.getAttribute(string);
        }
        catch (ClassCastException classCastException) {
            throw new AueException(THIS_CLASS + " expects " + "fromAttr" + " " + AueUtil.doubleQuote((String)string) + " to be a boolean attribute.");
        }
        if (booleanAttribute == null) {
            throw new AueException(THIS_CLASS + " did not found MO attribute " + AueUtil.doubleQuote((String)string) + " in system referred by argument attribute " + "fromAttr");
        }
        return booleanAttribute;
    }

    private IntegerAttribute getIntegerAttributeReferredByToAttr(MoDataWrapper moDataWrapper, String string) throws AueException {
        IntegerAttribute integerAttribute = null;
        try {
            integerAttribute = (IntegerAttribute)moDataWrapper.getAttribute(string);
        }
        catch (ClassCastException classCastException) {
            throw new AueException(THIS_CLASS + " expects " + "toAttr" + " " + AueUtil.doubleQuote((String)string) + " to be an integer attribute.");
        }
        if (integerAttribute == null) {
            throw new AueException(THIS_CLASS + " did not found MO attribute " + AueUtil.doubleQuote((String)string) + " in system referred by argument attribute " + "toAttr");
        }
        return integerAttribute;
    }

    private int getMappedValue(Coordinator coordinator, String string, BooleanAttribute booleanAttribute) throws AueException {
        int n;
        Map map = this.parseMappingString(string);
        String string2 = (String)map.get(String.valueOf(n = booleanAttribute.getValue(coordinator) ? 1 : 0));
        if (string2 == null || string2.equals("")) {
            throw new AueException(THIS_CLASS + " attribute mapping did not contain mapping for " + booleanAttribute.getValue(coordinator));
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AueException(THIS_CLASS + " attribute mapping did not contain a integer mapping value for " + booleanAttribute.getValue(coordinator));
        }
        return n2;
    }
}

