/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step2.actions.it16;

import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.DbWrapperFactory;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;

public class CleanUpFroDataDbTableAction
implements MoDataAction {
    private DbWrapper dbWrapper;
    private static final Class THIS_CLASS = CleanUpFroDataDbTableAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws AueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        HashMap hashMap = (HashMap)converterContext.getAttribute("moActionArgMap");
        String string = this.getAndCheckParamMapString("name", hashMap, "The attribute name is not specified in " + AueUtil.doubleQuote((String)this.getClass().getName()));
        this.cleanUp(string);
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp(String string) throws CrbsAueException {
        this.initDbWrapper();
        this.openDbConnection();
        try {
            String string2 = "frodata_" + string + "_";
            ResultSet resultSet = null;
            try {
                resultSet = this.dbWrapper.executeQuery("select name from tables");
                while (resultSet != null && resultSet.next()) {
                    String string3 = resultSet.getString(1);
                    if (string3 == null || string3.indexOf(string2.toLowerCase(Locale.getDefault())) <= -1) continue;
                    String string4 = "drop table " + string3;
                    this.dbWrapper.executeUpdate(string4);
                    logger.traceDebug(THIS_CLASS, "Finshed executing: " + string4);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (SQLException sQLException) {
            throw new CrbsAueException("Caugth SQLException", (Throwable)sQLException);
        }
        finally {
            this.closeDbConnection();
        }
    }

    private void openDbConnection() throws CrbsAueException {
        try {
            this.dbWrapper.openConnection();
        }
        catch (SQLException sQLException) {
            throw new CrbsAueException("Failing open db connection", (Throwable)sQLException);
        }
    }

    private void closeDbConnection() throws CrbsAueException {
        try {
            this.dbWrapper.closeConnection(2);
        }
        catch (SQLException sQLException) {
            logger.traceError(THIS_CLASS, "Unable to close db connection: " + (Object)((Object)sQLException));
        }
    }

    private void initDbWrapper() throws CrbsAueException {
        this.dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
    }

    private String getAndCheckParamMapString(String string, Map map, String string2) throws AueException {
        String string3 = (String)map.get(string);
        if (string3 == null || string3.equals("")) {
            throw new AueException(string2);
        }
        return string3;
    }
}

