/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step2.actions.it18;

import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.FindMoDataByLDNFilter;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataFilter;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.lte.rbs.omf.aue.step2.AuePersistencyUtil;
import se.ericsson.lte.rbs.omf.aue.step2.Step2HandlerWrapper;

public class CreateSectorCarriersAction
implements MoDataAction {
    private static final char HASH = '#';
    private static final String MO_TYPE_SECTOR_CARRIER = "SectorCarrier";
    private static final String ATTRIBUTE_SECTOR_FUNCTION_REF = "sectorFunctionRef";
    private static final String ATTRIBUTE_RESERVED_BY = "reservedBy";
    private static final String ATTRIBUTE_SECTOR_CARRIER_REF = "sectorCarrierRef";
    private static final boolean AVC_NOTIFIER_FALSE = false;
    private static final boolean AVC_NOTIFIER_TRUE = true;
    private static final Class THIS_CLASS = CreateSectorCarriersAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws AueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        List list = new AuePersistencyUtil().retrieveFromAuePersistency(converterContext, MO_TYPE_SECTOR_CARRIER);
        logger.traceDebug(THIS_CLASS, "Found " + list.size() + " rows in AuePersistency.");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = string.indexOf(35);
            int n2 = string.substring(n + 1).indexOf(35) + n + 1;
            if (n < 0 || n2 < 0) {
                logger.traceDebug(THIS_CLASS, "Did not found two separators # in: " + string);
                continue;
            }
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1, n2).trim();
            String string4 = string.substring(n2 + 1).trim();
            MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
            MoDataWrapper moDataWrapper2 = moDataAccessor.findFirst((MoDataFilter)new FindMoDataByLDNFilter(string4));
            if (moDataWrapper2 == null) {
                throw new CrbsAueException("Could not find the cell MO mentioned in AuePersistency table: " + string4);
            }
            MoDataWrapper moDataWrapper3 = moDataAccessor.findFirst((MoDataFilter)new FindMoDataByLDNFilter(string3));
            if (moDataWrapper3 == null) {
                throw new CrbsAueException("Could not find the SectorEquipmentFunction MO mentioned in AuePersistency table: " + string3);
            }
            MoDataWrapper moDataWrapper4 = Step2HandlerWrapper.getInstance().createMo(moDataAccessor, string2, coordinator, converterContext);
            ReferenceAttribute referenceAttribute = new ReferenceAttribute(ATTRIBUTE_SECTOR_FUNCTION_REF, string3, false);
            moDataWrapper4.registerPersistentAttr((Attribute)referenceAttribute);
            SequenceAttribute sequenceAttribute = new SequenceAttribute(ATTRIBUTE_RESERVED_BY, false);
            ReferenceAttribute referenceAttribute2 = new ReferenceAttribute(ATTRIBUTE_RESERVED_BY, string4, false);
            sequenceAttribute.addElement((Attribute)referenceAttribute2);
            moDataWrapper4.registerPersistentAttr((Attribute)sequenceAttribute);
            this.updateCellMo(string4, moDataWrapper2, string2);
            this.updateSectorEquipmentFunctionMo(string3, moDataWrapper3, string2, coordinator);
            moDataWrapper4.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            moDataWrapper2.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            moDataWrapper3.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        }
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    private void updateCellMo(String string, MoDataWrapper moDataWrapper, String string2) throws CrbsAueException {
        SequenceAttribute sequenceAttribute = (SequenceAttribute)moDataWrapper.getAttribute(ATTRIBUTE_SECTOR_CARRIER_REF);
        if (sequenceAttribute == null) {
            throw new CrbsAueException("The attribute \"sectorCarrierRef\" does not exist in MO : \"" + string + "\"");
        }
        ReferenceAttribute referenceAttribute = new ReferenceAttribute(ATTRIBUTE_SECTOR_CARRIER_REF, string2, true);
        sequenceAttribute.setValue((Attribute[])new ReferenceAttribute[]{referenceAttribute});
    }

    private void updateSectorEquipmentFunctionMo(String string, MoDataWrapper moDataWrapper, String string2, Coordinator coordinator) throws CrbsAueException {
        SequenceAttribute sequenceAttribute = (SequenceAttribute)moDataWrapper.getAttribute(ATTRIBUTE_RESERVED_BY);
        if (sequenceAttribute == null) {
            throw new CrbsAueException("The attribute \"reservedBy\" does not exist in MO : \"" + string + "\"");
        }
        ReferenceAttribute referenceAttribute = new ReferenceAttribute(ATTRIBUTE_SECTOR_CARRIER_REF, string2, true);
        this.addReferenceToReservedBy(sequenceAttribute, referenceAttribute, coordinator);
    }

    private void addReferenceToReservedBy(SequenceAttribute sequenceAttribute, ReferenceAttribute referenceAttribute, Coordinator coordinator) {
        Attribute attribute;
        Attribute[] attributeArray = sequenceAttribute.getValue(coordinator);
        boolean bl = true;
        if (sequenceAttribute.size() > 0 && !(attribute = attributeArray[0]).getName().equals(ATTRIBUTE_SECTOR_CARRIER_REF)) {
            bl = false;
            sequenceAttribute.setValue((Attribute[])new ReferenceAttribute[]{referenceAttribute});
        }
        if (bl) {
            sequenceAttribute.addElement((Attribute)referenceAttribute);
        }
    }
}

