/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step2.actions.it20;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.FindMoDataByLDNFilter;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataFilter;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.lte.rbs.omf.aue.step2.AuePersistencyUtilWrapper;

public class RemoveUnusedExternalEUtranCellsAction
implements MoDataAction {
    private static final Class THIS_CLASS = RemoveUnusedExternalEUtranCellsAction.class;
    public static final char HASH_SEPARATOR_CHAR = '#';
    private static final String AUE_PERSISTENCY_DBKEY = "RemoveUnusedExternalEUtranCellsAction";
    private static final String ATTRIBUTE_RESERVED_BY = "reservedBy";
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws AueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        List list = AuePersistencyUtilWrapper.getAuePersistencyUtil().retrieveFromAuePersistency(converterContext, AUE_PERSISTENCY_DBKEY);
        logger.traceDebug(THIS_CLASS, "Found " + list.size() + " rows in AuePersistency.");
        Iterator iterator = list.iterator();
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = string.indexOf(35);
            if (n <= -1) continue;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            MoDataWrapper moDataWrapper2 = moDataAccessor.findFirst((MoDataFilter)new FindMoDataByLDNFilter(string2));
            if (moDataWrapper2 == null) continue;
            moDataAccessor.delete(moDataWrapper2, coordinator);
            logger.traceDebug(THIS_CLASS, "The mo is deleted:" + string2);
            this.updateEutranFrequencyReservedBy(moDataAccessor, string2, string3, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    private void updateEutranFrequencyReservedBy(MoDataAccessor moDataAccessor, String string, String string2, Coordinator coordinator) throws AueException {
        MoDataWrapper moDataWrapper = moDataAccessor.findFirst((MoDataFilter)new FindMoDataByLDNFilter(string2));
        if (moDataWrapper != null) {
            SequenceAttribute sequenceAttribute = (SequenceAttribute)moDataWrapper.getAttribute(ATTRIBUTE_RESERVED_BY);
            Enumeration enumeration = sequenceAttribute.elements();
            while (enumeration.hasMoreElements()) {
                ReferenceAttribute referenceAttribute = (ReferenceAttribute)enumeration.nextElement();
                String string3 = referenceAttribute.getReferenceAsLDN();
                if (!string.equals(string3)) continue;
                sequenceAttribute.removeElement((Attribute)referenceAttribute);
                moDataWrapper.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                logger.traceDebug(THIS_CLASS, "Updated reservedBy list of mo:" + string2);
                break;
            }
        }
    }
}

