/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step2.actions.it21;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step2.mao.MoRepositoryWrapper;
import se.ericsson.crbs.omf.aue.step2.mao.MoRepositoryWrapperFactory;

public class ChangeFeatureDynamicLoadControlUserLabel {
    private static final Class THIS_CLASS = ChangeFeatureDynamicLoadControlUserLabel.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String MO_TYPE_OPTIONAL_FEATURE_LICENSE = "OptionalFeatureLicense";
    private static final String RDN_DYNAMIC_LOAD_CONTROL = "OptionalFeatureLicense=DynamicLoadControl";
    private static final String RDN_LOAD_BASED_ACCESS_CONTROL = "OptionalFeatureLicense=LoadBasedAccessControl";
    private static final String OLD_USER_LABEL = "Load-Based Access Control";
    private static final String NEW_USER_LABEL = "Dynamic Load Control";
    private static final String ATTR_NAME_USER_LABEL = "userLabel";
    private static final String ATTR_NAME_KEY_ID = "keyId";
    private static final String DYNAMIC_LOAD_CONTROL_KEY_ID = "CXC4011713";
    private final Coordinator coordinator;

    public ChangeFeatureDynamicLoadControlUserLabel(Coordinator coordinator) {
        this.coordinator = coordinator;
    }

    public void execute() throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "execute()");
        MoRepositoryWrapper moRepositoryWrapper = MoRepositoryWrapperFactory.getInstance().getMoRepositoryWrapper();
        MoIterator moIterator = moRepositoryWrapper.lookupType(MO_TYPE_OPTIONAL_FEATURE_LICENSE);
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                this.checkAndModifyOptionalFeatureLicenseMo(moIterator.nextMo());
            }
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void checkAndModifyOptionalFeatureLicenseMo(ManagedObject managedObject) throws CrbsAueException {
        try {
            String string = managedObject.getRelativeDistinguishedName();
            if ((RDN_DYNAMIC_LOAD_CONTROL.equals(string) || RDN_LOAD_BASED_ACCESS_CONTROL.equals(string)) && DYNAMIC_LOAD_CONTROL_KEY_ID.equals(managedObject.getAttribute(ATTR_NAME_KEY_ID, this.coordinator)) && OLD_USER_LABEL.equals(managedObject.getAttribute(ATTR_NAME_USER_LABEL, this.coordinator))) {
                managedObject.setAttribute(ATTR_NAME_USER_LABEL, (Object)NEW_USER_LABEL, this.coordinator);
            }
        }
        catch (NoSuchAttributeException noSuchAttributeException) {
            throw new CrbsAueException("Attribute userLabel or keyId is not found on OptionalFeatureLicense", (Throwable)noSuchAttributeException);
        }
        catch (MoAccessException moAccessException) {
            throw new CrbsAueException("Failed to update attribute userLabel on OptionalFeatureLicense", (Throwable)moAccessException);
        }
    }
}

