/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step2.actions.it22;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.lte.rbs.omf.aue.step2.AbstractStep2ConversionAction;

public class UpdateExtGeranCellRefAction
extends AbstractStep2ConversionAction {
    private static final String GERAN_CELL_RELATION_MO_TYPE = "GeranCellRelation";
    private static final String EXTERNAL_GERAN_CELL_REF_ATTR_NAME = "externalGeranCellRef";
    private static final String EXT_GERAN_CELL_REF_ATTR_NAME = "extGeranCellRef";
    private static final String RDN_VALUE_SEPARATOR = "__";
    private static final Class THIS_CLASS = UpdateExtGeranCellRefAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws AueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        Collection collection = moDataAccessor.getByType(GERAN_CELL_RELATION_MO_TYPE);
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                MoDataWrapper moDataWrapper2 = (MoDataWrapper)iterator.next();
                ReferenceAttribute referenceAttribute = (ReferenceAttribute)moDataWrapper2.getAttribute(EXTERNAL_GERAN_CELL_REF_ATTR_NAME);
                String string = referenceAttribute.getReferenceAsLDN();
                String string2 = this.getNewExternlaGernaCellLdn(string);
                ReferenceAttribute referenceAttribute2 = new ReferenceAttribute(EXT_GERAN_CELL_REF_ATTR_NAME, string2, false);
                moDataWrapper2.registerPersistentAttr((Attribute)referenceAttribute2);
                moDataWrapper2.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                logger.traceDebug(THIS_CLASS, "GeranCellRelation::extGeranCellRef set to " + string2);
            }
        }
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    private String getNewExternlaGernaCellLdn(String string) {
        String string2 = LdnUtil.getParentLdn((String)string);
        String string3 = LdnUtil.getParentLdn((String)string2);
        String string4 = LdnUtil.getParentLdn((String)string3);
        String string5 = string4 + "," + LdnUtil.getMoType((String)string) + "=" + LdnUtil.getRdnValue((String)string3) + RDN_VALUE_SEPARATOR + LdnUtil.getRdnValue((String)string2) + RDN_VALUE_SEPARATOR + LdnUtil.getRdnValue((String)string);
        return string5;
    }
}

