/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step2.actions.it22;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.FindMoDataByLDNFilter;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataFilter;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.lte.rbs.omf.aue.step2.AbstractStep2ConversionAction;
import se.ericsson.lte.rbs.omf.aue.step2.AuePersistencyUtilWrapper;
import se.ericsson.lte.rbs.omf.aue.step2.actions.it22.Step2UtilWrapper;

public class UpdateLdnAction
extends AbstractStep2ConversionAction {
    private static final String USER_LABEL_ATTRIBUTE = "userLabel";
    private static final String RESERVED_BY_ATTRIBUTE = "reservedBy";
    private static final String GERAN_FREQ_GROUP_REF_ATTRIBUTE = "geranFreqGroupRef";
    private static final String TIME_OF_LAST_MODIFICATION_ATTRIBUTE = "timeOfLastModification";
    private static final String TIME_OF_CREATION_ATTRIBUTE = "timeOfCreation";
    private static final String LAST_MODIFICATION_ATTRIBUTE = "lastModification";
    private static final String MASTER_GERAN_CELL_ID_ATTRIBUTE = "masterGeranCellId";
    private static final String GERAN_FREQUENCY_MO_TYPE = "GERANFREQUENCY";
    private static final String EXTERNAL_GERAN_CELL_MO_TYPE = "EXTERNALGERANCELL";
    private static final Class THIS_CLASS = UpdateLdnAction.class;
    private static final String AUE_PERSISTENCY_DBKEY = "UpdateLdn_";
    public static final char HASH_SEPARATOR_CHAR = '#';
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws AueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        HashMap hashMap = (HashMap)converterContext.getAttribute("moActionArgMap");
        String string = this.getAndCheckParamMapString("type", hashMap, "The attribute type is not specified in " + AueUtil.doubleQuote((String)this.getClass().getName()));
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        List list = AuePersistencyUtilWrapper.getAuePersistencyUtil().retrieveFromAuePersistency(converterContext, AUE_PERSISTENCY_DBKEY + string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            int n = string2.indexOf(35);
            if (n <= -1) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            MoDataWrapper moDataWrapper2 = moDataAccessor.findFirst((MoDataFilter)new FindMoDataByLDNFilter(string3));
            if (moDataWrapper2 == null) continue;
            MoDataWrapper moDataWrapper3 = Step2UtilWrapper.getInstance().createMo(moDataAccessor, string4, coordinator, converterContext);
            this.updateNewMoAttributes(string, moDataWrapper2, moDataWrapper3);
            moDataAccessor.delete(moDataWrapper2, coordinator);
            moDataWrapper3.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        }
        logger.traceDebug(THIS_CLASS, "Found " + list.size() + " rows in AuePersistency.");
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    private void updateNewMoAttributes(String string, MoDataWrapper moDataWrapper, MoDataWrapper moDataWrapper2) {
        StringAttribute stringAttribute = (StringAttribute)moDataWrapper.getAttribute(USER_LABEL_ATTRIBUTE);
        SequenceAttribute sequenceAttribute = (SequenceAttribute)moDataWrapper.getAttribute(RESERVED_BY_ATTRIBUTE);
        if (string.equals(GERAN_FREQUENCY_MO_TYPE)) {
            SequenceAttribute sequenceAttribute2 = (SequenceAttribute)moDataWrapper.getAttribute(GERAN_FREQ_GROUP_REF_ATTRIBUTE);
            moDataWrapper2.registerPersistentAttr((Attribute)sequenceAttribute2);
        } else if (string.equals(EXTERNAL_GERAN_CELL_MO_TYPE)) {
            StringAttribute stringAttribute2 = (StringAttribute)moDataWrapper.getAttribute(MASTER_GERAN_CELL_ID_ATTRIBUTE);
            IntegerAttribute integerAttribute = (IntegerAttribute)moDataWrapper.getAttribute(LAST_MODIFICATION_ATTRIBUTE);
            StringAttribute stringAttribute3 = (StringAttribute)moDataWrapper.getAttribute(TIME_OF_CREATION_ATTRIBUTE);
            StringAttribute stringAttribute4 = (StringAttribute)moDataWrapper.getAttribute(TIME_OF_LAST_MODIFICATION_ATTRIBUTE);
            moDataWrapper2.registerPersistentAttr((Attribute)stringAttribute2);
            moDataWrapper2.registerPersistentAttr((Attribute)integerAttribute);
            moDataWrapper2.registerPersistentAttr((Attribute)stringAttribute3);
            moDataWrapper2.registerPersistentAttr((Attribute)stringAttribute4);
        }
        moDataWrapper2.registerPersistentAttr((Attribute)sequenceAttribute);
        moDataWrapper2.registerPersistentAttr((Attribute)stringAttribute);
    }
}

