/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step2.actions.it25;

import se.ericsson.cello.equipment.PlugInUnitMoInternal;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step2.mao.MoRepositoryWrapper;
import se.ericsson.crbs.omf.aue.step2.mao.MoRepositoryWrapperFactory;
import se.ericsson.lte.rbs.omf.aue.step2.ChangeIntAttributeValue;

public class ChangeMaxNoOfCountersOnPlugInUnit {
    private static final String PLUG_IN_UNIT = "PlugInUnit";
    private static final String PM_SERVICE = "PmService";
    private static final String MAX_NO_OF_COUNTERS = "maxNoOfCounters";
    private static final String PRODUCT_DATA = "productData";
    private static final String PRODUCT_NUMBER = "productNumber";
    private static final String DUL20 = "KDU137533/3";
    private static final int MAX_NO_OF_COUNTERS_DUL20 = 310000;
    private static final int MAX_NO_OF_COUNTERS_OTHERS = 7500000;
    private static final int MAX_NO_OF_COUNTERS_65000 = 65000;
    private static final int MAX_NO_OF_COUNTERS_100000 = 100000;
    private static final int MAX_NO_OF_COUNTERS_200000 = 200000;
    private static final int MAX_NO_OF_COUNTERS_380000 = 380000;
    private static final Class THIS_CLASS = ChangeMaxNoOfCountersOnPlugInUnit.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final Coordinator coordinator;

    public ChangeMaxNoOfCountersOnPlugInUnit(Coordinator coordinator) {
        this.coordinator = coordinator;
    }

    public void execute() {
        logger.traceEnter(THIS_CLASS, "execute()");
        MoRepositoryWrapper moRepositoryWrapper = MoRepositoryWrapperFactory.getInstance().getMoRepositoryWrapper();
        MoIterator moIterator = moRepositoryWrapper.lookupType(PLUG_IN_UNIT);
        int n = 7500000;
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                PlugInUnitMoInternal plugInUnitMoInternal = (PlugInUnitMoInternal)moIterator.nextMo();
                try {
                    ManagedObject managedObject = plugInUnitMoInternal.getPiuType(this.coordinator);
                    Struct struct = (Struct)managedObject.getAttribute(PRODUCT_DATA, this.coordinator);
                    String string = (String)struct.getValue(PRODUCT_NUMBER);
                    if (!string.startsWith(DUL20)) continue;
                    n = 310000;
                    logger.traceGeneral(THIS_CLASS, "maxNoOfCounters will be set to " + n + " due to HW type " + string);
                    break;
                }
                catch (MoAccessException moAccessException) {
                    logger.traceError(THIS_CLASS, "Failed to retrieve PiuType for: " + plugInUnitMoInternal + ", due to: " + (Object)((Object)moAccessException));
                }
            }
        }
        if (n == 310000) {
            logger.traceDebug(THIS_CLASS, "maxNoOfCounters value is: 310000");
            this.changeMaxNoOfCountersForDul20(n);
        } else {
            logger.traceDebug(THIS_CLASS, "maxNoOfCounters value is: 7500000");
            this.changeMaxNoOfCounters(n);
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void changeMaxNoOfCountersForDul20(int n) {
        logger.traceEnter(THIS_CLASS, "changeMaxNoOfCountersForDul20()");
        ChangeIntAttributeValue changeIntAttributeValue = new ChangeIntAttributeValue(this.coordinator);
        changeIntAttributeValue.execute(PM_SERVICE, MAX_NO_OF_COUNTERS, 65000, n);
        changeIntAttributeValue.execute(PM_SERVICE, MAX_NO_OF_COUNTERS, 100000, n);
        changeIntAttributeValue.execute(PM_SERVICE, MAX_NO_OF_COUNTERS, 200000, n);
        changeIntAttributeValue.execute(PM_SERVICE, MAX_NO_OF_COUNTERS, 380000, n);
        logger.traceReturn(THIS_CLASS, "changeMaxNoOfCountersForDul20()");
    }

    private void changeMaxNoOfCounters(int n) {
        logger.traceEnter(THIS_CLASS, "changeMaxNoOfCounters()");
        MoRepositoryWrapper moRepositoryWrapper = MoRepositoryWrapperFactory.getInstance().getMoRepositoryWrapper();
        MoIterator moIterator = moRepositoryWrapper.lookupType(PM_SERVICE);
        if (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            try {
                managedObject.setAttribute(MAX_NO_OF_COUNTERS, (Object)new Integer(n), this.coordinator);
                logger.traceDebug(THIS_CLASS, "PmService.maxNoOfCounters changed to " + n + ".");
            }
            catch (MoAccessException moAccessException) {
                logger.traceError(THIS_CLASS, "Exception caught when setting attribute PmService.maxNoOfCounters", (Throwable)moAccessException);
            }
        }
        logger.traceReturn(THIS_CLASS, "changeMaxNoOfCounters()");
    }
}

