/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.URL;
import se.ericsson.cello.neal.internal.NealLog;

class HttpClient {
    public static final int DEFAULT_TIMEOUT = 60000;
    private static final String HTTP = "http";
    private static final String METHOD = "GET";
    private static final String NEWLINE = "\r\n";
    private static final String HTTP_VERSION = "1.1";
    private static final String USER_AGENT = "SMO/1.0";
    private static final String ACCEPT = "text/plain, text/html, */*";
    private URL url = null;
    private Socket socket = null;
    private String host;
    private int port;
    private InputStream inputStream = null;
    private static final int readBufferSize = 1024;
    private byte[] readBuffer = new byte[1024];
    private int responseCode;
    private String reasonPhrase;
    private long contentLength;

    public HttpClient() {
        this.clearFields();
    }

    public HttpClient(String string) throws IOException {
        this(new URL(string));
    }

    public HttpClient(String string, int n) throws IOException {
        this(new URL(string), n);
    }

    public HttpClient(URL uRL) throws IOException {
        this.connect(uRL);
    }

    public HttpClient(URL uRL, int n) throws IOException {
        this.connect(uRL, n);
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean isConnected() {
        return this.socket != null;
    }

    public void connect(URL uRL) throws IOException {
        this.connect(uRL, 60000);
    }

    public void connect(URL uRL, int n) throws IOException {
        NealLog.fine("Connect to URL " + uRL);
        TimeoutThread timeoutThread = null;
        this.close();
        this.clearFields();
        try {
            NealLog.fine("Reading URL from " + this.host + ":" + this.port);
            this.setUrl(uRL);
            this.socket = new Socket(this.host, this.port);
            timeoutThread = new TimeoutThread(this.socket, n);
            timeoutThread.start();
            this.sendRequest();
            this.readResponse();
            timeoutThread.abort();
        }
        catch (IOException iOException) {
            this.close();
            if (timeoutThread != null) {
                timeoutThread.abort();
            }
            throw iOException;
        }
    }

    public void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
            this.inputStream = null;
        }
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    private void clearFields() {
        this.responseCode = -1;
        this.reasonPhrase = null;
        this.contentLength = -1L;
    }

    private void setUrl(URL uRL) throws IOException {
        if (this.socket != null) {
            throw new IOException("Can not change URL while connected.");
        }
        if (uRL == null) {
            throw new IOException("URL can not be null.");
        }
        this.url = null;
        if (!uRL.getProtocol().equalsIgnoreCase(HTTP)) {
            throw new IOException("Unsupported protocol: " + uRL.getProtocol());
        }
        int n = uRL.getPort();
        if (n == -1) {
            n = 80;
        }
        if (n == -1) {
            throw new IOException("Unknown default port for protocol in url: " + uRL);
        }
        this.url = uRL;
        this.host = uRL.getHost();
        this.port = n;
    }

    private void sendRequest() throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.socket.getOutputStream());
        String string = this.url.getPath();
        if (string.length() == 0) {
            string = "/";
        }
        String string2 = "GET " + string + " HTTP/" + HTTP_VERSION + NEWLINE;
        string2 = string2 + "User-Agent: SMO/1.0\r\n";
        string2 = string2 + "Host: " + this.url.getHost();
        if (this.url.getPort() != -1) {
            string2 = string2 + ":" + this.url.getPort();
        }
        string2 = string2 + NEWLINE;
        string2 = string2 + "Accept: text/plain, text/html, */*\r\n";
        string2 = string2 + "Cache-Control: no-cache\r\n";
        string2 = string2 + "Connection: close\r\n";
        string2 = string2 + NEWLINE;
        outputStreamWriter.write(string2);
        outputStreamWriter.flush();
    }

    private void readResponse() throws IOException {
        this.inputStream = this.socket.getInputStream();
        this.parseStatusLine(this.readLine());
        String string = this.readLine();
        while (string.length() > 0) {
            this.parseHeader(string);
            string = this.readLine();
        }
    }

    private String readLine() throws IOException {
        int n;
        int n2 = this.inputStream.read();
        for (n = 0; n2 != -1 && n2 != 10 && n < 1024; ++n) {
            this.readBuffer[n] = (byte)n2;
            n2 = this.inputStream.read();
        }
        if (n >= 1024) {
            throw new IOException("Too long header line found in HTTP response.");
        }
        String string = new String(this.readBuffer, 0, n);
        return string.trim();
    }

    private void parseStatusLine(String string) throws IOException {
        if (!string.startsWith("HTTP/1.")) {
            throw new IOException("Invalid HTTP status response received.");
        }
        int n = string.indexOf(32);
        int n2 = n >= 0 ? string.indexOf(32, n + 1) : string.length();
        try {
            this.responseCode = Integer.parseInt(string.substring(n + 1, n2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Invalid HTTP status response received.");
        }
        try {
            n = n2;
            this.reasonPhrase = string.substring(n + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parseHeader(String string) throws IOException {
        int n = string.indexOf(58);
        if (n < 0) {
            throw new IOException("Invalid HTTP header received.");
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        if (string2.equalsIgnoreCase("Content-Length")) {
            try {
                this.contentLength = Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("here");
            HttpClient httpClient = new HttpClient("http://localhost:8080");
            System.out.println("Response code: " + httpClient.getResponseCode());
            System.out.println("Reason Phrase: " + httpClient.getReasonPhrase());
            System.out.println("Content length: " + httpClient.getContentLength());
            int n = 0;
            InputStream inputStream = httpClient.getInputStream();
            while (inputStream.read() != -1) {
                ++n;
            }
            System.out.println("Read " + n + " additional bytes.");
            httpClient.close();
            System.out.println("done");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.exit(0);
    }

    private class TimeoutThread
    extends Thread {
        private Socket mySocket;
        private int timeout;

        public TimeoutThread(Socket socket, int n) {
            this.mySocket = socket;
            this.timeout = n;
        }

        public void run() {
            try {
                Thread.sleep(this.timeout);
                this.mySocket.close();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void abort() {
            this.interrupt();
        }
    }
}

