/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import [Ljava.lang.String;;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.iptransport.DnsResolverMo;
import se.ericsson.cello.iptransport.ipi_dnsresolver_mi;
import se.ericsson.cello.iptransport.mom.IpAccessHostEt;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.GetRequestContext;
import se.ericsson.cello.mao.GetRequestContextImpl;
import se.ericsson.cello.mao.MoGenUtil;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.ParameterNames;
import se.ericsson.cello.mao.PmRequestContextImpl;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.mao.SetRequestContextImpl;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public abstract class DnsResolverMoGen
extends CelloMao
implements DnsResolverMo,
Reservable {
    protected String[] ATTRIBUTES_TO_REQUEST_FROM_FRO = new String[]{"defDomainName", "dnsServerAddress", "isSubDomainName", "dnsServerAutoConfig", "dscp", "usedDnsServerAddress", "ipAccessHostEtRef"};
    protected String[] NON_READONLY_MOM_ATTRIBUTES = new String[]{"DnsResolverId", "userLabel", "defDomainName", "dnsServerAddress", "isSubDomainName", "dnsServerAutoConfig", "dscp", "ipAccessHostEtRef"};
    protected FroProxy froProxy = null;
    protected MoData data;
    protected static final TagNameDictionary DICTIONARY = TagNameDictionaries.create((ResourceBundle)new ipi_dnsresolver_mi());
    protected MaoFroIndicationHandler indHandler;
    Map myPmProxyFroIdMap = new HashMap(3);
    protected static final String FROID = "froId";
    protected static final int MO_DATA_REVISION_LATEST = 14000;

    private void checkMandatoryAttrs(AttrList attrList) throws AttrMissingAtCreateException, MoNotFoundException, NotHandledAttributeTypeException {
        this.checkMandatoryRefAttribute("ipAccessHostEtRef", attrList);
    }

    private void checkMandatoryAttribute(String string, AttrList attrList) throws AttrMissingAtCreateException, MoNotFoundException, NotHandledAttributeTypeException {
        int n = attrList.indexOf(string);
        if (n < 0 || attrList.getValue(n) == null) {
            throw new AttrMissingAtCreateException(string, "DnsResolver");
        }
    }

    private void checkMandatoryRefAttribute(String string, AttrList attrList) throws AttrMissingAtCreateException, MoNotFoundException, NotHandledAttributeTypeException {
        int n = attrList.indexOf(string);
        if (n < 0) {
            throw new AttrMissingAtCreateException(string, "DnsResolver");
        }
    }

    protected DnsResolverMoGen(Coordinator coordinator, ManagedObject managedObject, String string, FroProxy froProxy, InitialMaoContext initialMaoContext, AttrList attrList, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "DnsResolver", string, coordinator, initialMaoContext);
        boolean bl;
        Boolean bl2;
        this.froProxy = froProxy;
        this.indHandler = maoFroIndicationHandler;
        this.checkMandatoryAttrs(attrList);
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(attrList, coordinator);
        setRequestContextImpl.assertNoDuplicateAttributes("DnsResolver");
        setRequestContextImpl.assertAllowedAttributes(this.NON_READONLY_MOM_ATTRIBUTES, "DnsResolver");
        this.data = initialMaoContext.createMoData(this.getLocalDistinguishedName(), "DnsResolver", true, coordinator);
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true));
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        this.data.setRevision(14000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String string2 = (String)MoGenUtil.checkAndGetAttributeType((String)"userLabel", (AttrList)attrList, (Class)String.class, (String)"DnsResolver");
        if (string2 == null) {
            string2 = "";
        }
        this.validateUserLabel(string2, (SetRequestContext)setRequestContextImpl);
        ((StringAttribute)this.data.getAttribute("userLabel")).setValue(string2);
        String string3 = (String)MoGenUtil.checkAndGetAttributeType((String)"defDomainName", (AttrList)attrList, (Class)String.class, (String)"DnsResolver");
        if (string3 == null) {
            string3 = "";
        }
        this.validateDefDomainName(string3, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new StringParameter("defDomainName", string3));
        String[] stringArray = (String[])MoGenUtil.checkAndGetAttributeType((String)"dnsServerAddress", (AttrList)attrList, (Class)String;.class, (String)"DnsResolver");
        if (stringArray == null) {
            stringArray = DNS_SERVER_ADDRESS_DEFAULT;
        }
        this.validateDnsServerAddress(stringArray, (SetRequestContext)setRequestContextImpl);
        ArrayParameter arrayParameter = null;
        if (stringArray != null) {
            arrayParameter = new ArrayParameter("dnsServerAddress");
            bl2 = null;
            for (bl = false; bl < stringArray.length; bl += 1) {
                bl2 = new StringParameter("dnsServerAddress_member", stringArray[bl], 47);
                arrayParameter.add((Parameter)bl2);
            }
        }
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)arrayParameter);
        bl2 = (Boolean)MoGenUtil.checkAndGetAttributeType((String)"isSubDomainName", (AttrList)attrList, (Class)Boolean.class, (String)"DnsResolver");
        bl = true;
        if (bl2 != null) {
            bl = bl2;
        }
        this.validateIsSubDomainName(bl, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("isSubDomainName", bl));
        Boolean bl3 = (Boolean)MoGenUtil.checkAndGetAttributeType((String)"dnsServerAutoConfig", (AttrList)attrList, (Class)Boolean.class, (String)"DnsResolver");
        boolean bl4 = false;
        if (bl3 != null) {
            bl4 = bl3;
        }
        this.validateDnsServerAutoConfig(bl4, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("dnsServerAutoConfig", bl4));
        Integer n = (Integer)MoGenUtil.checkAndGetAttributeType((String)"dscp", (AttrList)attrList, (Class)Integer.class, (String)"DnsResolver");
        int n2 = 48;
        if (n != null) {
            n2 = n;
        }
        this.validateDscp(n2, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("dscp", n2));
        ManagedObject managedObject2 = (ManagedObject)MoGenUtil.checkAndGetAttributeType((String)"ipAccessHostEtRef", (AttrList)attrList, (Class)ManagedObject.class, (String)"DnsResolver");
        this.validateIpAccessHostEtRef(managedObject2, (SetRequestContext)setRequestContextImpl);
        int n3 = 0;
        if (managedObject2 != null && managedObject2 instanceof FroInfo) {
            n3 = ((FroInfo)managedObject2).getFroId(coordinator);
        }
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("ipAccessHostEtRef", n3));
        this.onCreate((SetRequestContext)setRequestContextImpl);
        if (managedObject2 instanceof Reservable) {
            ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        }
        FroData froData = setRequestContextImpl.sendCreateRequest(this.froProxy);
        int n4 = froData.getFroId();
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(FROID, false, n4));
        maoFroIndicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n4);
    }

    public DnsResolverMoGen(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        this.froProxy = froProxy;
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(14000);
        moDataRecoveryHelper.assertAttribute(FROID);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.indHandler = maoFroIndicationHandler;
        maoFroIndicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute(FROID)).getValue(null));
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void onGetAttributes(GetRequestContext getRequestContext) throws MoAccessException {
    }

    protected Object onGetAttributes(GetRequestContext getRequestContext, String string, Object object) throws MoAccessException {
        return object;
    }

    protected void onDelete(Coordinator coordinator) throws MoAccessException {
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.onDelete(coordinator);
        ManagedObject managedObject = null;
        managedObject = this.getIpAccessHostEtRef(coordinator);
        if (managedObject != null && managedObject instanceof Reservable) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        if (((ManagedObject[])this.getAttribute("reservedBy", coordinator)).length > 0) {
            throw new MoReservedNotDeletableException("DnsResolver");
        }
        this.froProxy.delete(coordinator, this.getFroId(coordinator), null);
        this.indHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setDefDomainName(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("defDomainName", string, coordinator);
    }

    public String getDefDomainName(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("defDomainName", coordinator);
    }

    public void setDnsServerAddress(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("dnsServerAddress", stringArray, coordinator);
    }

    public String[] getDnsServerAddress(Coordinator coordinator) throws MoAccessException {
        return (String[])this.getAttribute("dnsServerAddress", coordinator);
    }

    public void setIsSubDomainName(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("isSubDomainName", bl, coordinator);
    }

    public boolean getIsSubDomainName(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("isSubDomainName", coordinator);
    }

    public void setDnsServerAutoConfig(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("dnsServerAutoConfig", bl, coordinator);
    }

    public boolean getDnsServerAutoConfig(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("dnsServerAutoConfig", coordinator);
    }

    public void setDscp(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("dscp", new Integer(n), coordinator);
    }

    public int getDscp(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("dscp", coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("reservedBy", coordinator);
    }

    public int getPmDnsResCounterStandardQueries(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmDnsResCounterStandardQueries", coordinator);
    }

    public int getPmDnsResOptCounterNoResponses(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmDnsResOptCounterNoResponses", coordinator);
    }

    public int getPmDnsResCounterNotExistResponses(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmDnsResCounterNotExistResponses", coordinator);
    }

    public String[] getUsedDnsServerAddress(Coordinator coordinator) throws MoAccessException {
        return (String[])this.getAttribute("usedDnsServerAddress", coordinator);
    }

    public ManagedObject getIpAccessHostEtRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("ipAccessHostEtRef", coordinator);
    }

    public abstract ManagedObject fetchIpAccessHostEtRef(SignedIntParameter var1, Coordinator var2) throws MoAccessException;

    public String getType() {
        return "DnsResolver";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(FROID)).getValue(coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        GetRequestContextImpl getRequestContextImpl = new GetRequestContextImpl(stringArray, coordinator);
        this.addParameterNames(getRequestContextImpl.getParameterNames());
        getRequestContextImpl.readAttributesFromProxy(this.froProxy, this.getFroId(coordinator), this.ATTRIBUTES_TO_REQUEST_FROM_FRO);
        Object[] objectArray = new Object[stringArray.length];
        PmRequestContextImpl pmRequestContextImpl = new PmRequestContextImpl((ManagedObject)this, this.myPmProxyFroIdMap, coordinator);
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            StringParameter stringParameter;
            String string;
            String[] stringArray2;
            StringParameter stringParameter2;
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
            } else if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
            } else if (stringArray[i].equalsIgnoreCase("defDomainName")) {
                stringParameter2 = (StringParameter)getRequestContextImpl.getParameter("defDomainName");
                if (stringParameter2 == null) {
                    throw new FroRequestFailedException("DnsResolver", "Missing parameter from FRO: defDomainName", "getAttributes", -1);
                }
                objectArray[i] = stringParameter2.getValue();
            } else if (stringArray[i].equalsIgnoreCase("dnsServerAddress")) {
                stringParameter2 = (ArrayParameter)getRequestContextImpl.getParameter("dnsServerAddress");
                if (stringParameter2 == null) {
                    throw new FroRequestFailedException("DnsResolver", "Missing parameter from FRO: dnsServerAddress", "getAttributes", -1);
                }
                stringArray2 = new String[stringParameter2.size()];
                string = null;
                stringParameter = null;
                for (n = 0; n < stringParameter2.size(); ++n) {
                    stringParameter = (StringParameter)stringParameter2.get(n);
                    stringArray2[n] = string = stringParameter.getValue();
                }
                objectArray[i] = stringArray2;
            } else if (stringArray[i].equalsIgnoreCase("isSubDomainName")) {
                stringParameter2 = (SignedIntParameter)getRequestContextImpl.getParameter("isSubDomainName");
                if (stringParameter2 == null) {
                    throw new FroRequestFailedException("DnsResolver", "Missing parameter from FRO: isSubDomainName", "getAttributes", -1);
                }
                objectArray[i] = stringParameter2.getBoolean();
            } else if (stringArray[i].equalsIgnoreCase("dnsServerAutoConfig")) {
                stringParameter2 = (SignedIntParameter)getRequestContextImpl.getParameter("dnsServerAutoConfig");
                if (stringParameter2 == null) {
                    throw new FroRequestFailedException("DnsResolver", "Missing parameter from FRO: dnsServerAutoConfig", "getAttributes", -1);
                }
                objectArray[i] = stringParameter2.getBoolean();
            } else if (stringArray[i].equalsIgnoreCase("dscp")) {
                stringParameter2 = (SignedIntParameter)getRequestContextImpl.getParameter("dscp");
                if (stringParameter2 == null) {
                    throw new FroRequestFailedException("DnsResolver", "Missing parameter from FRO: dscp", "getAttributes", -1);
                }
                objectArray[i] = new Integer(stringParameter2.getValue());
            } else if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                stringParameter2 = (SequenceAttribute)this.data.getAttribute("reservedBy");
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)stringParameter2, (Coordinator)coordinator);
            } else if (stringArray[i].equalsIgnoreCase("pmDnsResCounterStandardQueries")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmDnsResCounterStandardQueries", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmDnsResOptCounterNoResponses")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmDnsResOptCounterNoResponses", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("pmDnsResCounterNotExistResponses")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmDnsResCounterNotExistResponses", INTEGER_PM_TYPE);
            } else if (stringArray[i].equalsIgnoreCase("usedDnsServerAddress")) {
                stringParameter2 = (ArrayParameter)getRequestContextImpl.getParameter("usedDnsServerAddress");
                if (stringParameter2 == null) {
                    throw new FroRequestFailedException("DnsResolver", "Missing parameter from FRO: usedDnsServerAddress", "getAttributes", -1);
                }
                stringArray2 = new String[stringParameter2.size()];
                string = null;
                stringParameter = null;
                for (n = 0; n < stringParameter2.size(); ++n) {
                    stringParameter = (StringParameter)stringParameter2.get(n);
                    stringArray2[n] = string = stringParameter.getValue();
                }
                objectArray[i] = stringArray2;
            } else if (stringArray[i].equalsIgnoreCase("ipAccessHostEtRef")) {
                stringParameter2 = (SignedIntParameter)getRequestContextImpl.getParameter("ipAccessHostEtRef");
                if (stringParameter2 == null) {
                    throw new FroRequestFailedException("DnsResolver", "Missing parameter from FRO: ipAccessHostEtRef", "getAttributes", -1);
                }
                objectArray[i] = this.fetchIpAccessHostEtRef((SignedIntParameter)stringParameter2, null);
            } else {
                objectArray[i] = super.getAttribute(stringArray[i], coordinator);
            }
            objectArray[i] = this.onGetAttributes((GetRequestContext)getRequestContextImpl, stringArray[i], objectArray[i]);
        }
        this.onGetAttributes((GetRequestContext)getRequestContextImpl);
        return objectArray;
    }

    public void addParameterNames(ParameterNames parameterNames) {
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(stringArray, objectArray, coordinator);
        String string = null;
        Object object = null;
        setRequestContextImpl.assertNoDuplicateAttributes("DnsResolver");
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            object = objectArray[i];
            if (string.equalsIgnoreCase("userLabel")) {
                if (object instanceof String) {
                    String string2 = (String)object;
                    this.validateUserLabel(string2, (SetRequestContext)setRequestContextImpl);
                    ((StringAttribute)this.data.getAttribute("userLabel")).setValue(string2);
                    continue;
                }
                throw new WrongAttributeTypeException("userLabel", "DnsResolver");
            }
            if (string.equalsIgnoreCase("defDomainName")) {
                if (object instanceof String) {
                    String string3 = (String)object;
                    this.validateDefDomainName(string3, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new StringParameter("defDomainName", string3));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("defDomainName", "DnsResolver");
            }
            if (string.equalsIgnoreCase("dnsServerAddress")) {
                if (object instanceof String[]) {
                    String[] stringArray2 = (String[])object;
                    this.validateDnsServerAddress(stringArray2, (SetRequestContext)setRequestContextImpl);
                    ArrayParameter arrayParameter = null;
                    if (stringArray2 != null) {
                        arrayParameter = new ArrayParameter("dnsServerAddress");
                        StringParameter stringParameter = null;
                        for (int j = 0; j < stringArray2.length; ++j) {
                            stringParameter = new StringParameter("dnsServerAddress_member", stringArray2[j], 47);
                            arrayParameter.add((Parameter)stringParameter);
                        }
                    }
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)arrayParameter);
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("dnsServerAddress", "DnsResolver");
            }
            if (string.equalsIgnoreCase("isSubDomainName")) {
                if (object instanceof Boolean) {
                    boolean bl = (Boolean)object;
                    this.validateIsSubDomainName(bl, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("isSubDomainName", bl));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("isSubDomainName", "DnsResolver");
            }
            if (string.equalsIgnoreCase("dnsServerAutoConfig")) {
                if (object instanceof Boolean) {
                    boolean bl = (Boolean)object;
                    this.validateDnsServerAutoConfig(bl, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("dnsServerAutoConfig", bl));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("dnsServerAutoConfig", "DnsResolver");
            }
            if (string.equalsIgnoreCase("dscp")) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    this.validateDscp(n, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("dscp", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("dscp", "DnsResolver");
            }
            throw new NoSuchAttributeException(string, "DnsResolver");
        }
        this.onSetAttributes((SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.sendSetRequest(this.froProxy, this.getFroId(coordinator));
        setRequestContextImpl.sendAvcNotifications((ManagedObject)this);
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl();
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(DICTIONARY);
            Iterator iterator = map.keySet().iterator();
            String string = null;
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (string.equals("usedDnsServerAddress")) {
                    ArrayParameter arrayParameter = (ArrayParameter)map.get("usedDnsServerAddress");
                    String[] stringArray = new String[arrayParameter.size()];
                    String string2 = null;
                    StringParameter stringParameter = null;
                    for (int i = 0; i < arrayParameter.size(); ++i) {
                        stringParameter = (StringParameter)arrayParameter.get(i);
                        stringArray[i] = string2 = stringParameter.getValue();
                    }
                    setRequestContextImpl.addAvcNotification("usedDnsServerAddress", (Object)stringArray);
                    continue;
                }
                MessageLog.traceError(this.getClass(), (String)"Unknown attribute in parameterChanged()");
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag not found");
        }
        setRequestContextImpl.sendAvcNotifications((ManagedObject)this);
    }

    protected void validateUserLabel(String string, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkStringWithLength((String)string, (String)"userLabel", (int)128, (int)0, (String)"DnsResolver");
    }

    protected void validateDefDomainName(String string, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkStringWithLength((String)string, (String)"defDomainName", (int)255, (int)0, (String)"DnsResolver");
    }

    protected void validateDnsServerAddress(String[] stringArray, SetRequestContext setRequestContext) throws MoAccessException {
        if (stringArray.length > 3 || stringArray.length < 0) {
            throw new ValueOutOfRangeException("dnsServerAddress", "DnsResolver");
        }
        MoGenUtil.checkUniquenessOfArray((String)"dnsServerAddress", (Object)stringArray, (String)"DnsResolver");
    }

    protected void validateIsSubDomainName(boolean bl, SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void validateDnsServerAutoConfig(boolean bl, SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void validateDscp(int n, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkIntegerAttribute((String)"dscp", (int)n, (int)0, (int)63, (String)"DnsResolver");
    }

    protected void validateIpAccessHostEtRef(ManagedObject managedObject, SetRequestContext setRequestContext) throws MoAccessException {
        if (managedObject == null) {
            throw new ValueOutOfRangeException("ipAccessHostEtRef", "DnsResolver");
        }
        if (!(managedObject instanceof IpAccessHostEt)) {
            throw new WrongAttributeTypeException("ipAccessHostEtRef", "DnsResolver");
        }
    }
}

