/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.iptransport.DnsResolverMoGen;
import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.iptransport.IpAccessHostEtMoImpl;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.iptransport.VpnInterfaceBuildIF;
import se.ericsson.cello.mao.DomainNameFormatException;
import se.ericsson.cello.mao.DomainNameValidation;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.Ipv4AddressValidation;
import se.ericsson.cello.mao.Ipv6AddressValidation;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoGenUtil;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class DnsResolverMoImpl
extends DnsResolverMoGen {
    public DnsResolverMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler);
    }

    public DnsResolverMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        Coordinator coordinator = setRequestContext.getCoordinator();
        boolean bl = false;
        if (setRequestContext.isIncludedInRequest("dnsServerAutoConfig")) {
            bl = (Boolean)setRequestContext.getAttributeFromRequest("dnsServerAutoConfig");
        }
        ManagedObject managedObject = (ManagedObject)setRequestContext.getAttributeFromRequest("ipAccessHostEtRef");
        ManagedObject managedObject2 = ((IpAccessHostEtMoImpl)managedObject).getIpInterfaceMoRef(coordinator);
        String[] stringArray = new String[]{};
        if (setRequestContext.isIncludedInRequest("dnsServerAddress")) {
            stringArray = (String[])setRequestContext.getAttributeFromRequest("dnsServerAddress");
        }
        if (bl) {
            this.checkDnsServerAutoConfig(managedObject2, coordinator);
        } else {
            this.checkAddressesWhenServerAutoConfigIsFalse(bl, stringArray);
        }
        this.checkDnsServerAddress(stringArray, managedObject, managedObject2, coordinator);
    }

    private void checkAddressesWhenServerAutoConfigIsFalse(boolean bl, String[] stringArray) throws MoAccessException {
        if (stringArray.length <= 0) {
            throw new OperationNotAllowedException("dnsServerAddress cannot be empty if dnsServerAutoConfig=false", "DnsResolver");
        }
    }

    protected void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
        boolean bl = setRequestContext.isIncludedInRequest("dnsServerAutoConfig");
        boolean bl2 = setRequestContext.isIncludedInRequest("dnsServerAddress");
        if (bl || bl2) {
            Coordinator coordinator = setRequestContext.getCoordinator();
            ManagedObject managedObject = this.getIpAccessHostEtRef(coordinator);
            ManagedObject managedObject2 = ((IpAccessHostEtMoImpl)managedObject).getIpInterfaceMoRef(coordinator);
            if (bl) {
                boolean bl3 = (Boolean)setRequestContext.getAttributeFromRequest("dnsServerAutoConfig");
                if (bl3) {
                    this.checkDnsServerAutoConfig(managedObject2, coordinator);
                } else {
                    String[] stringArray = bl2 ? (String[])setRequestContext.getAttributeFromRequest("dnsServerAddress") : this.getDnsServerAddress(coordinator);
                    this.checkAddressesWhenServerAutoConfigIsFalse(bl3, stringArray);
                }
            }
            if (bl2) {
                String[] stringArray = (String[])setRequestContext.getAttributeFromRequest("dnsServerAddress");
                boolean bl4 = false;
                if (!bl && !(bl4 = this.getDnsServerAutoConfig(coordinator))) {
                    this.checkAddressesWhenServerAutoConfigIsFalse(bl4, stringArray);
                }
                this.checkDnsServerAddress(stringArray, managedObject, managedObject2, coordinator);
            }
        }
    }

    private void checkDnsServerAutoConfig(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        boolean bl = false;
        if (managedObject instanceof VpnInterfaceBuildIF && ((VpnInterfaceBuildIF)managedObject).getConfigurationMode(coordinator) == 1) {
            bl = true;
        } else if (managedObject instanceof IpInterfaceMo && ((IpInterfaceMo)managedObject).getConfigurationMode(coordinator) == 1) {
            bl = true;
        }
        if (!bl) {
            throw new IllegalAttributeValueException("dnsServerAutoConfig can be set to true only if referred IpAccessHostEt referes to VpnInterface with configurationMode=IKE or to IpInterface with configurationMode=DHCP", "DnsResolver");
        }
    }

    private void checkDnsServerAddress(String[] stringArray, ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        if (stringArray.length > 0) {
            MoGenUtil.checkUniquenessOfArray((String)"dnsServerAddress", (Object)stringArray, (String)"DnsResolver");
            this.validateIpAddressandVersion(managedObject2, stringArray, coordinator);
        }
    }

    private void validateIpAddressandVersion(ManagedObject managedObject, String[] stringArray, Coordinator coordinator) throws MoAccessException {
        int n = 0;
        if (managedObject instanceof VpnInterfaceBuildIF) {
            n = ((VpnInterfaceBuildIF)managedObject).getIpVersion(coordinator);
        } else if (managedObject instanceof IpInterfaceMo) {
            n = 0;
        } else if (managedObject instanceof Ipv6InterfaceMo) {
            n = 1;
        } else {
            throw new IllegalAttributeValueException("Invalid IpAccessHostEt reference", "DnsResolver");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (n == 0) {
                if (!Ipv4AddressValidation.isIpv4((String)string)) {
                    throw new IllegalAttributeValueException("The specified ipAddress should have the same ip version as IpAccessHostEtRef", "dnsServerAddress", "DnsResolver");
                }
                if (Ipv4AddressValidation.isValidIpv4Address((String)string)) continue;
                throw new IpFormatException("dnsServerAddress should be in valid ipv4 format");
            }
            if (!Ipv6AddressValidation.isIpv6((String)string)) {
                throw new IllegalAttributeValueException("The specified ipAddress should have the same ip version as IpAccessHostEtRef", "dnsServerAddress", "DnsResolver");
            }
            if (Ipv6AddressValidation.isValidIpv6Addres((String)string)) continue;
            throw new IpFormatException("dnsServerAddress should be in valid ipv6 format");
        }
    }

    public ManagedObject fetchIpAccessHostEtRef(SignedIntParameter signedIntParameter, Coordinator coordinator) throws MoAccessException {
        return MaoFroTypeConverter.froId2MaoInstance((String)"IpAccessHostEt", (int)signedIntParameter.getValue(), (Coordinator)coordinator);
    }

    protected void validateDefDomainName(String string, SetRequestContext setRequestContext) throws MoAccessException {
        if (!string.equals("")) {
            try {
                DomainNameValidation.validate((String)string);
            }
            catch (DomainNameFormatException domainNameFormatException) {
                throw new ValueOutOfRangeException("defDomainName", "DnsResolver", string + " is not valid domain name");
            }
        }
    }

    protected void validateIpAccessHostEtRef(ManagedObject managedObject, SetRequestContext setRequestContext) throws MoAccessException {
        if (!(managedObject instanceof IpAccessHostEtMo)) {
            throw new WrongAttributeTypeException("ipAccessHostEtRef", "DnsResolver");
        }
    }
}

