/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.iptransport.DscpPbit;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;

public class DscpPbitMap {
    private Map dscpPbitMap = null;
    private ArrayParameter parameter = null;
    private Struct[] moStructs = null;
    private static final int NUMBER_OF_ELEMENTS = 64;
    private static final int PBIT_0 = 0;
    private static final int PBIT_1 = 1;
    private static final int PBIT_3 = 3;
    private static final int PBIT_4 = 4;
    private static final int PBIT_5 = 5;
    private static final int PBIT_6 = 6;
    private static final int PBIT_7 = 7;

    protected DscpPbitMap() throws MoAccessException {
        this.dscpPbitMap = new HashMap(64);
        block7: for (int i = 0; i < 64; ++i) {
            switch (i) {
                case 10: 
                case 12: 
                case 14: {
                    this.dscpPbitMap.put(new Integer(i), new DscpPbit(i, 1));
                    continue block7;
                }
                case 18: 
                case 20: 
                case 22: {
                    this.dscpPbitMap.put(new Integer(i), new DscpPbit(i, 3));
                    continue block7;
                }
                case 26: 
                case 28: 
                case 30: {
                    this.dscpPbitMap.put(new Integer(i), new DscpPbit(i, 4));
                    continue block7;
                }
                case 34: 
                case 36: 
                case 38: {
                    this.dscpPbitMap.put(new Integer(i), new DscpPbit(i, 5));
                    continue block7;
                }
                case 46: {
                    this.dscpPbitMap.put(new Integer(i), new DscpPbit(i, 6));
                    continue block7;
                }
                default: {
                    this.dscpPbitMap.put(new Integer(i), new DscpPbit(i, 0));
                }
            }
        }
        this.parameter = this.createParameter();
        this.moStructs = this.createStructs();
    }

    public DscpPbitMap(Struct[] structArray) throws MoAccessException {
        if (!(structArray instanceof Struct[])) {
            throw new WrongAttributeTypeException("dscpPbitMap", "GigaBitEthernet");
        }
        if (structArray.length != 64) {
            throw new ValueOutOfRangeException("Missing element in dscpPbitMap", "GigaBitEthernet");
        }
        this.dscpPbitMap = new HashMap(64);
        for (int i = 0; i < 64; ++i) {
            this.dscpPbitMap.put(new Integer(i), new DscpPbit(structArray[i]));
        }
        this.checkRanges();
        this.parameter = this.createParameter();
    }

    public DscpPbitMap(ArrayParameter arrayParameter) throws MoAccessException {
        if (arrayParameter != null) {
            if (arrayParameter.size() != 64) {
                throw new ValueOutOfRangeException("Missing element in dscpPbitMap", "GigaBitEthernet");
            }
            this.dscpPbitMap = new HashMap(64);
            for (int i = 0; i < 64; ++i) {
                StructParameter structParameter = (StructParameter)arrayParameter.get(i);
                this.dscpPbitMap.put(new Integer(i), new DscpPbit(structParameter));
            }
        } else {
            throw new ConfigurationMismatchException("Cannot create DscpPbitMap with null parameter ", "GigaBitEthernet", "dscpPbitMap");
        }
        this.moStructs = this.createStructs();
        this.parameter = arrayParameter;
    }

    private Struct[] createStructs() throws MoAccessException {
        StructImpl[] structImplArray = new StructImpl[64];
        for (int i = 0; i < 64; ++i) {
            structImplArray[i] = ((DscpPbit)this.dscpPbitMap.get(new Integer(i))).toStruct();
        }
        return structImplArray;
    }

    public Struct[] toStructs() throws MoAccessException {
        return this.moStructs;
    }

    private void checkRanges() throws MoAccessException {
        int n = 0;
        DscpPbit dscpPbit = null;
        for (int i = 0; i < 64; ++i) {
            dscpPbit = (DscpPbit)this.dscpPbitMap.get(new Integer(i));
            n = (Integer)dscpPbit.getValue("dscp");
            if (n == i) continue;
            throw new ValueOutOfRangeException("The dscp values must be unique in the attribute dscpPbitMap", "GigaBitEthernet");
        }
    }

    public ArrayParameter toParameter() throws MoAccessException {
        return this.parameter;
    }

    private ArrayParameter createParameter() throws MoAccessException {
        ArrayParameter arrayParameter = new ArrayParameter("dscpPbitMap");
        for (int i = 0; i < 64; ++i) {
            arrayParameter.add((Parameter)((DscpPbit)this.dscpPbitMap.get(new Integer(i))).toParameter());
        }
        return arrayParameter;
    }

    protected void setDscpPbit(int n, int n2) throws MoAccessException {
        DscpPbit dscpPbit = new DscpPbit(n, n2);
        Integer n3 = new Integer(n);
        this.dscpPbitMap.remove(n3);
        this.dscpPbitMap.put(n3, dscpPbit);
        this.moStructs = this.createStructs();
        this.parameter = this.createParameter();
    }
}

