/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.TreeSet;
import se.ericsson.cello.equipment.PiuUtils;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.iptransport.DefaultRouterMo;
import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.iptransport.PathSupervisionMo;
import se.ericsson.cello.iptransport.PathSupervisionMoGen;
import se.ericsson.cello.iptransport.RpsProfileMo;
import se.ericsson.cello.iptransport.mom.Ipv6Interface;
import se.ericsson.cello.mao.AttrValueNotUniqueException;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.GetRequestContext;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.Ipv6AddressValidation;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class PathSupervisionMoImpl
extends PathSupervisionMoGen {
    public static final String OWN_IP_ADDRESS_DEFAULT = "::";

    public PathSupervisionMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler);
    }

    public PathSupervisionMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    protected void validateLinkSide(int n, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateLinkSide(n, setRequestContext);
        ManagedObject managedObject = this.getParent();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        treeSet.add(new Integer(n));
        if (managedObject instanceof Ipv6InterfaceMo) {
            MoIterator moIterator = managedObject.getChildren();
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject2 = moIterator.nextMo();
                if (managedObject2.equals(this) || !(managedObject2 instanceof PathSupervisionMo)) continue;
                Integer n2 = (Integer)managedObject2.getAttribute("linkSide", setRequestContext.getCoordinator());
                if (treeSet.contains(n2)) {
                    throw new AttrValueNotUniqueException("At most one PathSupervision can be ACTIVE/PASSIVE linkSide", "PathSupervision");
                }
                treeSet.add(n2);
            }
        }
    }

    protected void validateOwnIpAddress(String string, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateOwnIpAddress(string, setRequestContext);
        boolean bl = false;
        boolean bl2 = false;
        if (string.equals("") || string.equals(OWN_IP_ADDRESS_DEFAULT)) {
            string = OWN_IP_ADDRESS_DEFAULT;
            bl2 = true;
        } else {
            this.validateIpv6Format(string);
            bl = this.validateIpv6Type(string);
        }
        if (!bl2 && !bl) {
            throw new IllegalAttributeValueException("Address should be global if specified ownIpAddress", "PathSupervision");
        }
        this.validateNetPrefix(string, setRequestContext, bl2);
    }

    private void validateNetPrefix(String string, SetRequestContext setRequestContext, boolean bl) throws MoAccessException, NoSuchAttributeException, IpFormatException, IllegalAttributeValueException {
        Object object = setRequestContext.getAttributeFromRequest("networkPrefixLength");
        int n = 64;
        if (object != null) {
            n = (Integer)object;
        }
        boolean bl2 = this.validateAgainstPathSupervision(string, setRequestContext, bl, n);
        boolean bl3 = this.validateAgainstIpAccessHostEt(string, setRequestContext, bl, n);
        if (!bl2 || !bl3) {
            this.validateAgainstDefaultRouter(string, setRequestContext, bl, n);
        }
    }

    private void validateAgainstDefaultRouter(String string, SetRequestContext setRequestContext, boolean bl, int n) throws MoAccessException, NoSuchAttributeException, IpFormatException, IllegalAttributeValueException {
        ManagedObject managedObject = this.getParent();
        if (managedObject instanceof Ipv6InterfaceMo) {
            MoIterator moIterator = managedObject.getChildren();
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject2 = moIterator.nextMo();
                if (!(managedObject2 instanceof DefaultRouterMo)) continue;
                String string2 = (String)managedObject2.getAttribute("nextHopIpAddr", setRequestContext.getCoordinator());
                this.validateIsUnique(string, string2);
                if (bl) {
                    if (Ipv6AddressValidation.isLinkLocalIpv6((String)string2)) continue;
                    throw new IllegalAttributeValueException("ownIpAddressis unspecified but DefaultRouter MO nextHopIpAddr is not local ", "PathSupervision");
                }
                if (Ipv6AddressValidation.isGlobalUnicastIpv6((String)string2)) {
                    if (Ipv6AddressValidation.compareNetPrefix((String)string, (String)string2, (int)n)) continue;
                    throw new IllegalAttributeValueException("The network prefix of ownIpAddress and DefaultRouter MO nextHopIpAddr for the same Ipv6Interface MO must be the same ", "PathSupervision");
                }
                throw new IllegalAttributeValueException("ownIpAddressis specified but DefaultRouter MO nextHopIpAddr is local ", "PathSupervision");
            }
        }
    }

    private void validateIsUnique(String string, String string2) throws IpFormatException, AttrValueNotUniqueException {
        if (Ipv6AddressValidation.getIpv6Addres((String)string).equals(Ipv6AddressValidation.getIpv6Addres((String)string2))) {
            throw new AttrValueNotUniqueException("ownIpAddress must be unique", "PathSupervision");
        }
    }

    private boolean validateAgainstIpAccessHostEt(String string, SetRequestContext setRequestContext, boolean bl, int n) throws MoAccessException, NoSuchAttributeException, IpFormatException, IllegalAttributeValueException {
        boolean bl2 = false;
        ManagedObject managedObject = this.getParent();
        ManagedObject managedObject2 = null;
        if (!bl) {
            int n2 = (Integer)setRequestContext.getAttributeFromRequest("linkSide");
            if (managedObject instanceof Ipv6InterfaceMo) {
                ManagedObject[] managedObjectArray = ((Ipv6Interface)managedObject).getReservedBy(setRequestContext.getCoordinator());
                for (int i = 0; i < managedObjectArray.length; ++i) {
                    String string2;
                    String string3;
                    managedObject2 = managedObjectArray[i];
                    if (!managedObjectArray[i].getType().equals("IpAccessHostEt")) continue;
                    bl2 = true;
                    String string4 = (String)managedObject2.getAttribute("ipAddress", setRequestContext.getCoordinator());
                    int n3 = (Integer)managedObject2.getAttribute("networkPrefixLength", setRequestContext.getCoordinator());
                    String string5 = Ipv6AddressValidation.getNetworkPrefix((String)string, (int)n);
                    String string6 = Ipv6AddressValidation.getNetworkPrefix((String)string4, (int)n3);
                    if (n != n3 || !string5.equalsIgnoreCase(string6)) {
                        throw new IllegalAttributeValueException("The network prefix of IpAccessHostEtMo ipaddress and ownIpAddress for the same Ipv6Interface MO must be the same ", "PathSupervision");
                    }
                    if (n2 != 1 || !(string3 = Ipv6AddressValidation.getIpv6Addres((String)string).getHostAddress()).equalsIgnoreCase(string2 = Ipv6AddressValidation.getIpv6Addres((String)string4).getHostAddress())) continue;
                    throw new IllegalAttributeValueException("ownIpAddress for the pasive link, linkSide=PASSIVE,  must be unique.", "PathSupervision");
                }
            }
        }
        return bl2;
    }

    private boolean validateAgainstPathSupervision(String string, SetRequestContext setRequestContext, boolean bl, int n) throws MoAccessException, NoSuchAttributeException, IpFormatException, IllegalAttributeValueException {
        boolean bl2 = false;
        ManagedObject managedObject = this.getParent();
        if (managedObject instanceof Ipv6InterfaceMo) {
            MoIterator moIterator = managedObject.getChildren();
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject2 = moIterator.nextMo();
                if (managedObject2.equals(this) || !(managedObject2 instanceof PathSupervisionMo)) continue;
                bl2 = true;
                String string2 = (String)managedObject2.getAttribute("ownIpAddress", setRequestContext.getCoordinator());
                int n2 = (Integer)managedObject2.getAttribute("networkPrefixLength", setRequestContext.getCoordinator());
                if (!bl) {
                    this.validateIsUnique(string, string2);
                }
                if (Ipv6AddressValidation.isUnspecifiedIpv6((String)string2) && !bl) {
                    throw new IllegalAttributeValueException("The address must be either specified or unspecified for all PathSupervision MOs for the same Ipv6Interface MO ownIpAddress", "PathSupervision");
                }
                String string3 = Ipv6AddressValidation.getNetworkPrefix((String)string, (int)n);
                String string4 = Ipv6AddressValidation.getNetworkPrefix((String)string2, (int)n2);
                if (n == n2 && string3.equalsIgnoreCase(string4)) continue;
                throw new IllegalAttributeValueException("The network prefix of all PathSupervision MOs for ownIpAddress belonging to the same Ipv6Interface MO must be the same ", "PathSupervision");
            }
        }
        return bl2;
    }

    private void validateIpv6Format(String string) throws IpFormatException {
        if (!Ipv6AddressValidation.isValidIpv6Addres((String)string)) {
            throw new IpFormatException("Only Ipv6 address format is supported for ownIpAddress");
        }
    }

    private boolean validateIpv6Type(String string) throws IpFormatException, IllegalAttributeValueException {
        boolean bl = Ipv6AddressValidation.isGlobalUnicastIpv6((String)string);
        if (!Ipv6AddressValidation.isLinkLocalIpv6((String)string) && !bl) {
            throw new IllegalAttributeValueException("The addres type must be global unicast or link local unicast for ownIpAddress", "PathSupervision");
        }
        return bl;
    }

    public ManagedObject fetchSupervisionMethodMoRef(SignedIntParameter signedIntParameter, Coordinator coordinator) throws MoAccessException {
        RpsProfileMo rpsProfileMo = null;
        MoIterator moIterator = MoRepository.instance().lookupType("RpsProfile");
        while (moIterator != null && moIterator.hasMoreElements()) {
            rpsProfileMo = (RpsProfileMo)moIterator.nextElement();
            if (!(rpsProfileMo instanceof FroInfo) || ((FroInfo)rpsProfileMo).getFroId(coordinator) != signedIntParameter.getValue()) continue;
            return rpsProfileMo;
        }
        return null;
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        Coordinator coordinator = setRequestContext.getCoordinator();
        int n = 0;
        int n2 = 0;
        n = ((Ipv6InterfaceMo)this.getParent()).getFroId(coordinator);
        n2 = PiuUtils.findPiuParentFroId((ManagedObject)((Ipv6InterfaceMo)this.getParent()).getEthernetRef(coordinator));
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("ipIfFroId", n));
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("piuId", n2));
    }

    protected Object handleGetOwnIpAddress(GetRequestContext getRequestContext) throws MoAccessException {
        StringParameter stringParameter = (StringParameter)getRequestContext.getParameter("ownIpAddress");
        if (stringParameter == null) {
            throw new FroRequestFailedException("PathSupervision", "Missing parameter from FRO:ownIpAddress", "getAttributes", -1);
        }
        return stringParameter.getValue();
    }

    protected void handleSetOwnIpAddress(String string, SetRequestContext setRequestContext) throws MoAccessException {
        if (string == null || string.equals("")) {
            string = OWN_IP_ADDRESS_DEFAULT;
        }
        setRequestContext.addParameter(this.froProxy, (Parameter)new StringParameter("ownIpAddress", string));
    }

    protected void validateSupervisionMethodMoRef(ManagedObject managedObject, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateSupervisionMethodMoRef(managedObject, setRequestContext);
        if (!(managedObject instanceof RpsProfileMo)) {
            throw new WrongAttributeTypeException("supervisionMethodMoRef", "PathSupervision");
        }
    }
}

