/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.omf.aue.step1.actions;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public abstract class AbstractCorrectInvalidParentRef
extends AbstractConversionAction {
    private static final Class THIS_CLASS = AbstractCorrectInvalidParentRef.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected TableData tableData;
    protected TableHandler tableHandler;
    private static final String LDN_ATTR_NAME = "ldn";
    private static final String FRO_TYPE_ATTR_NAME = "froType";
    private static final String FRO_ID_ATTR_NAME = "froId";
    private static final String PARENT_REF_ATTR_TAG = "attr";
    private static final String PARENT_REF_NAME_ATTR = "name";
    private static final String PARENT_REF_VALUE_ATTR = "value";

    public void convert(AueContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String froTypeName = this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        this.tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            this.tableData = this.tableHandler.getTableData(froTypeName);
            if (this.tableData.doesAttributeExist("parentRef")) {
                Object[] parentRefList = this.tableData.getAttributeValues("parentRef");
                Object[] childLdnRefList = this.tableData.getAttributeValues(LDN_ATTR_NAME);
                for (int i = 0; i < parentRefList.length; ++i) {
                    String parentRefFroType;
                    String parentRefFroId;
                    Map attributes = this.getParentRefAttributesMap(parentRefList[i].toString());
                    String childLdn = childLdnRefList[i].toString();
                    String parentRefLdn = attributes.get(LDN_ATTR_NAME).toString();
                    String realParentLdn = LdnUtil.getParentLdn((String)childLdn);
                    String correctedParentRef = this.getCorrectedParentMoRef(realParentLdn, parentRefLdn, parentRefFroId = attributes.get(FRO_ID_ATTR_NAME).toString(), parentRefFroType = attributes.get(FRO_TYPE_ATTR_NAME).toString());
                    if (correctedParentRef != null) {
                        logger.traceDebug(((Object)((Object)this)).getClass(), "Will set new parentRef for " + froTypeName + "(" + i + "): " + correctedParentRef);
                        this.tableData.setAttributeValue(i, "parentRef", (Object)correctedParentRef);
                        continue;
                    }
                    logger.traceDebug(((Object)((Object)this)).getClass(), "Update is not needed");
                }
            } else {
                logger.traceDebug(THIS_CLASS, "The attribute parentRef does not existsin TableData");
            }
        }
        catch (TableDataException e) {
            throw new CrbsAueException("Failed to read/write TableData", (Throwable)e);
        }
        catch (Exception e) {
            throw new CrbsAueException("Conversion failed", (Throwable)e);
        }
    }

    private Map getParentRefAttributesMap(String xml) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(xml));
        Document d = builder.parse(is);
        NodeList nodeList = d.getElementsByTagName(PARENT_REF_ATTR_TAG);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String name = node.getAttributes().getNamedItem(PARENT_REF_NAME_ATTR).getNodeValue();
            String value = node.getAttributes().getNamedItem(PARENT_REF_VALUE_ATTR).getNodeValue();
            result.put(name, value);
        }
        return result;
    }

    protected String getParentMoRef(String ldn, String froId, String froType) {
        return "<moref name=\"parentRef\"><attr name=\"ldn\" type=\"STRING\" value=\"" + ldn + "\"/><attr name=\"froType\" type=\"S32\" value=\"" + froType + "\"/><attr name=\"froId\" type=\"S32\" value=\"" + froId + "\"/></moref>";
    }

    public abstract String getCorrectedParentMoRef(String var1, String var2, String var3, String var4) throws TableDataException, CrbsAueException;
}

