/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.omf.aue.step1.actions;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.actions.TableAlreadyExistsException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.common.xml.XmlArrayHelper;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.AddAttributeAction;
import se.ericsson.crbs.omf.aue.step1.actions.CreateOneInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.DeleteAllMoInstancesAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class CompleteIruFroConfigurationAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = CompleteIruFroConfigurationAction.class;
    private static TableHandler tableHandler;
    private static final AbstractLogger logger;
    private static final String AUX_PIU_MO_TYPE_NAME = "AuxPlugInUnit";
    private static final String DEV_GRP_MO_TYPE_NAME = "DeviceGroup";
    private static final String DEV_SET_MO_TYPE_NAME = "RdicDeviceSet";
    private static final String RDI_PORT_MO_TYPE_NAME = "RdiPort";
    private static final int AUX_PIU_FRO_TYPE_ID = 0x1000000;
    private static final int DEV_GRP_FRO_TYPE_ID = 0x1000001;
    private static final int RDI_PORT_FRO_TYPE_ID = 0x1000016;
    private static final int RDIC_DEV_SET_FRO_TYPE_ID = 0x1000017;
    private static final int NB_OF_RD_PER_IRU = 8;
    private static int dotId;
    private static int auxPiuRdiFroIdGenerator;
    private static int deviceGroupFroIdGenerator;
    private static int rdiPortFroIdGenerator;
    private static int rdicDevSetFroIdGenerator;
    private static int remoteRdiPortIdGenerator;
    private static final String AUX_PIU_RD_PARENT_LDN = "ManagedElement=1,Equipment=1";
    private static final String AUX_PIU_ADM_STATE_ATTR_NAME = "administrativeState";
    private static final String AUX_PIU_POS_REF_ATTR_NAME = "positionRef";
    private static final String AUX_PIU_PRO_DATA_ATTR_NAME = "productData";
    private static final String AUX_PIU_FRO_ID_ATTR_NAME = "piuFroId";
    private static final String AUX_PIU_RDI_PROD_NAME = "RD";
    private static final String AUX_PIU_IRU_PROD_NAME = "IRU";
    private static final String REMOTE_RDI_PORT_REF_ATTR_NAME = "remoteRdiPortRef";
    private static final String IRU_CONF_TO_BE_COMPLETED = "irusMoToBeCompleted";
    private static final int ADM_STATE_UNLOCKED = 1;
    private static final String DEV_GRP_IDENTITY = "rd";
    private static final String DEV_SET_IDENTITY = "rdic";
    private static final String LDN_ATTR_NAME = "ldn";
    private static final String RDI_PORT_REF_ATTR_TAG = "attr";
    private static final String RDI_PORT_REF_NAME_ATTR = "name";
    private static final String RDI_PORT_REF_VALUE_ATTR = "value";
    private static boolean firstDotRdiInstance;
    private TableData auxPiuTableData;
    private TableData devGrpTableData;
    private TableData rdiPortsTableData;
    private TableData rdicDevSetTableData;
    private Object[] auxPiuLDN;
    private Object[] devGrpLDN;
    private Object[] auxPiuProductData;

    public void convert(AueContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String irus = "";
        int prodNameIndex = 1;
        tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            DeleteAllMoInstancesAction deleteAllMoInstancesAction;
            String auxPiuProdName;
            int i;
            this.auxPiuTableData = tableHandler.getTableData(AUX_PIU_MO_TYPE_NAME);
            this.devGrpTableData = tableHandler.getTableData(DEV_GRP_MO_TYPE_NAME);
            this.rdiPortsTableData = tableHandler.getTableData(RDI_PORT_MO_TYPE_NAME);
            this.rdicDevSetTableData = tableHandler.getTableData(DEV_SET_MO_TYPE_NAME);
            if (!this.auxPiuTableData.isNotEmpty()) {
                logger.traceGeneral(THIS_CLASS, "Node has No boards connected. AUE will NOT be executed on this node.");
                return;
            }
            this.auxPiuLDN = this.auxPiuTableData.getAttributeValues(LDN_ATTR_NAME);
            this.auxPiuProductData = this.auxPiuTableData.getAttributeValues(AUX_PIU_PRO_DATA_ATTR_NAME);
            for (i = 0; i < this.auxPiuLDN.length; ++i) {
                auxPiuProdName = "";
                String auxPiuProdData = this.auxPiuProductData[i].toString();
                XmlArrayHelper xmlHelper = new XmlArrayHelper(auxPiuProdData);
                List auxPiuProdDataList = xmlHelper.getValueTypeList();
                Map map = (Map)auxPiuProdDataList.get(prodNameIndex);
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    Object type = iterator.next();
                    Object value = map.get(type);
                    String val = value.toString();
                    logger.traceGeneral(THIS_CLASS, "AUE1: Starting to check if any pre-existing RD already configured on node (checking on productName).");
                    logger.traceGeneral(THIS_CLASS, "AUE1: AUXPIU ProductName: " + val);
                    if (val.compareTo("") == 0 || val.length() <= 2 || (auxPiuProdName = val.substring(0, 2)).compareTo(AUX_PIU_RDI_PROD_NAME) != 0) continue;
                    logger.traceGeneral(THIS_CLASS, "AUE1: Pre-existing RD already configured on node (matched on ProductName). RD-related AUE will NOT be executed on this node.");
                    return;
                }
                String identity = LdnUtil.getRdnValue((String)this.auxPiuLDN[i].toString());
                String id = "";
                if (identity.length() > 1) {
                    id = identity.substring(0, 2);
                }
                logger.traceGeneral(THIS_CLASS, "AUE1: Starting to check if any pre-existing RD already configured on node (checking on RDN).");
                logger.traceGeneral(THIS_CLASS, "AUE1: AUXPIU RDN: " + identity);
                if (id.compareTo(AUX_PIU_RDI_PROD_NAME) != 0) continue;
                logger.traceGeneral(THIS_CLASS, "AUE1: Pre-existing RD already configured on node (matched on RDN). RD-related AUE will NOT be executed on this node.");
                return;
            }
            logger.traceGeneral(THIS_CLASS, "AUE1: No pre-existing RD on node, continuing AUE1 action.");
            if (this.rdiPortsTableData.getNumberOfRecords() > 0) {
                HashMap<String, String> rdiPortsMap = new HashMap<String, String>();
                rdiPortsMap.put("Mo", RDI_PORT_MO_TYPE_NAME);
                deleteAllMoInstancesAction = new DeleteAllMoInstancesAction();
                deleteAllMoInstancesAction.setMoActionArgs(rdiPortsMap);
                deleteAllMoInstancesAction.convert(context);
                firstDotRdiInstance = false;
            }
            if (this.rdicDevSetTableData.getNumberOfRecords() > 0) {
                HashMap<String, String> rdicDevSetMap = new HashMap<String, String>();
                rdicDevSetMap.put("Mo", DEV_SET_MO_TYPE_NAME);
                deleteAllMoInstancesAction = new DeleteAllMoInstancesAction();
                deleteAllMoInstancesAction.setMoActionArgs(rdicDevSetMap);
                deleteAllMoInstancesAction.convert(context);
            }
            if (this.devGrpTableData.isNotEmpty()) {
                this.devGrpLDN = this.devGrpTableData.getAttributeValues(LDN_ATTR_NAME);
            }
            auxPiuRdiFroIdGenerator += this.auxPiuLDN.length;
            deviceGroupFroIdGenerator += this.devGrpLDN.length;
            for (i = 0; i < this.auxPiuLDN.length; ++i) {
                auxPiuProdName = "";
                String auxPiuRdn = LdnUtil.getRdnValue((String)this.auxPiuLDN[i].toString());
                String auxPiuProdData = this.auxPiuProductData[i].toString();
                XmlArrayHelper xmlHelper = new XmlArrayHelper(auxPiuProdData);
                List auxPiuProdDataList = xmlHelper.getValueTypeList();
                Map map = (Map)auxPiuProdDataList.get(prodNameIndex);
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    Object type = iterator.next();
                    Object value = map.get(type);
                    String val = value.toString();
                    if (val.compareTo("") != 0 && val.length() > 3) {
                        auxPiuProdName = val.substring(0, 3);
                    }
                    if (auxPiuProdName.compareTo(AUX_PIU_IRU_PROD_NAME) != 0 && !auxPiuRdn.startsWith(AUX_PIU_IRU_PROD_NAME)) continue;
                    this.createRadioDots(this.auxPiuLDN[i].toString(), context);
                    this.createRdicDeviceSet(this.auxPiuLDN[i].toString(), context);
                    this.createIruRdiPorts(this.auxPiuLDN[i].toString(), context);
                    irus = irus + this.auxPiuLDN[i] + "\n";
                }
            }
            tableHandler.storeInAuePersistency("", IRU_CONF_TO_BE_COMPLETED, irus);
            this.updateAllRdiPortsMoRef();
        }
        catch (TableDataException e) {
            throw new CrbsAueException("Failed to read/write TableData", (Throwable)e);
        }
        catch (NoSuchTableException e) {
            throw new CrbsAueException("Failed to read/write TableData NoSuchTableException ", (Throwable)e);
        }
        catch (TableAlreadyExistsException e) {
            throw new CrbsAueException("Failed to read/write TableData TableAlreadyExistsException", (Throwable)e);
        }
        logger.traceReturn(THIS_CLASS, "convert() executed");
    }

    private void createRadioDots(String iruLdn, AueContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createRadioDots() with froTypeName:AuxPlugInUnit");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        FroAttributes[] froAttributes = this.getRadioDotSpecificFroAttributes();
        int remoteIndex = 0;
        for (int i = 0; i < 8; ++i) {
            remoteIndex = i + 1;
            paramMap.put(RDI_PORT_REF_NAME_ATTR, AUX_PIU_MO_TYPE_NAME);
            paramMap.put("frotype", Integer.toString(0x1000000));
            paramMap.put("rdnValue", "RD-" + Integer.toString(dotId));
            paramMap.put("parentldn", AUX_PIU_RD_PARENT_LDN);
            paramMap.put("froid", Integer.toString(auxPiuRdiFroIdGenerator));
            paramMap.put(AUX_PIU_POS_REF_ATTR_NAME, this.creatEmptyePositionRefStruct());
            paramMap.put(AUX_PIU_PRO_DATA_ATTR_NAME, this.createEmptyProductDataStruct());
            this.addRadioDotSpecAttributes(paramMap, froAttributes);
            logger.traceDebug(THIS_CLASS, "createRadioDots(): addRadioDotSpecAttributes executed.");
            CreateOneInstanceAction createOneInstanceAction = new CreateOneInstanceAction();
            createOneInstanceAction.setMoActionArgs(paramMap);
            createOneInstanceAction.convert(context);
            String DotRdiLdn = "ManagedElement=1,Equipment=1,AuxPlugInUnit=RD-" + dotId;
            this.createDeviceGroup(DotRdiLdn, ++auxPiuRdiFroIdGenerator, context);
            this.createRadioDotRdiPort(iruLdn, remoteIndex, DotRdiLdn, context);
            ++dotId;
        }
        logger.traceReturn(THIS_CLASS, "createRadioDots() executed: Radio Dot and RdiPort FRO are created.");
    }

    private void createDeviceGroup(String parentLdn, int piuFroId, AueContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createDeviceGroup() port belongning to DOT:" + parentLdn);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        FroAttributes[] froAttributes = this.getDevGroupSpecificFroAttributes();
        paramMap.put(RDI_PORT_REF_NAME_ATTR, DEV_GRP_MO_TYPE_NAME);
        paramMap.put("frotype", Integer.toString(0x1000001));
        paramMap.put("rdnValue", DEV_GRP_IDENTITY);
        paramMap.put("parentldn", parentLdn);
        paramMap.put("froid", Integer.toString(deviceGroupFroIdGenerator));
        paramMap.put(AUX_PIU_FRO_ID_ATTR_NAME, Integer.toString(piuFroId));
        this.addDevGroupSpecAttributes(paramMap, froAttributes);
        CreateOneInstanceAction createOneInstanceAction = new CreateOneInstanceAction();
        createOneInstanceAction.setMoActionArgs(paramMap);
        createOneInstanceAction.convert(context);
        ++deviceGroupFroIdGenerator;
        logger.traceReturn(THIS_CLASS, "createDeviceGroup() executed");
    }

    private void createRdicDeviceSet(String auxPiuLdn, AueContext context) throws CrbsAueException {
        String correctDevGrpLDN;
        block3: {
            logger.traceEnter(THIS_CLASS, "createRdicDeviceSet() port belongning to IRU:" + auxPiuLdn);
            String tmpLDN = "";
            correctDevGrpLDN = "";
            try {
                this.devGrpTableData = tableHandler.getTableData(DEV_GRP_MO_TYPE_NAME);
                if (!this.devGrpTableData.isNotEmpty()) break block3;
                Object[] devGrpLDN = this.devGrpTableData.getAttributeValues(LDN_ATTR_NAME);
                for (int i = 0; i < devGrpLDN.length; ++i) {
                    tmpLDN = devGrpLDN[i].toString();
                    if (!tmpLDN.startsWith(auxPiuLdn)) continue;
                    correctDevGrpLDN = tmpLDN;
                    break;
                }
            }
            catch (TableDataException e) {
                throw new CrbsAueException("Failed to read/write TableData", (Throwable)e);
            }
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put(RDI_PORT_REF_NAME_ATTR, DEV_SET_MO_TYPE_NAME);
        paramMap.put("frotype", Integer.toString(0x1000017));
        paramMap.put("rdnValue", DEV_SET_IDENTITY);
        paramMap.put("parentldn", correctDevGrpLDN);
        paramMap.put("froid", Integer.toString(rdicDevSetFroIdGenerator));
        CreateOneInstanceAction createOneInstanceAction = new CreateOneInstanceAction();
        createOneInstanceAction.setMoActionArgs(paramMap);
        createOneInstanceAction.convert(context);
        ++rdicDevSetFroIdGenerator;
        logger.traceReturn(THIS_CLASS, "createRdicDeviceSet() executed");
    }

    private void createRadioDotRdiPort(String iruLdn, int rdiIdentity, String radioDotLdn, AueContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createRadioDotRdiPort() port belongning to DOT:" + radioDotLdn);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        FroAttributes[] rdFroAttributes = this.getRdiPortSpecificFroAttributes();
        int rdiPortId = 1;
        String remoteRdiPortRef = iruLdn + "," + RDI_PORT_MO_TYPE_NAME + "=" + Integer.toString(rdiIdentity);
        paramMap.put(RDI_PORT_REF_NAME_ATTR, RDI_PORT_MO_TYPE_NAME);
        paramMap.put("frotype", Integer.toString(0x1000016));
        paramMap.put("rdnValue", Integer.toString(rdiPortId));
        paramMap.put("parentldn", radioDotLdn);
        paramMap.put("froid", Integer.toString(rdiPortFroIdGenerator));
        paramMap.put(REMOTE_RDI_PORT_REF_ATTR_NAME, remoteRdiPortRef);
        if (!firstDotRdiInstance) {
            logger.traceDebug(THIS_CLASS, "createOneInstance() addRdiSpecAttributes");
            this.addRdiPortSpecAttributes(paramMap, rdFroAttributes);
        }
        CreateOneInstanceAction createOneInstanceAction = new CreateOneInstanceAction();
        createOneInstanceAction.setMoActionArgs(paramMap);
        createOneInstanceAction.convert(context);
        ++rdiPortFroIdGenerator;
        if (firstDotRdiInstance) {
            logger.traceDebug(THIS_CLASS, "createOneInstance() addRdiSpecAttributes");
            this.addRdiPortSpecAttributes(paramMap, rdFroAttributes, context);
        }
        firstDotRdiInstance = false;
        logger.traceReturn(THIS_CLASS, "createRadioDotRdiPort() executed");
    }

    private void createIruRdiPorts(String iruLdn, AueContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createIruRdiPorts() For all rdi ports belongning to :" + iruLdn);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        FroAttributes[] rdFroAttributes = this.getRdiPortSpecificFroAttributes();
        boolean firstRdiPortInstance = false;
        int k = 0;
        for (int i = 0; i < 8; ++i) {
            k = i + 1;
            String remoteRdiPortRef = "ManagedElement=1,Equipment=1,AuxPlugInUnit=RD-" + Integer.toString(remoteRdiPortIdGenerator) + "," + RDI_PORT_MO_TYPE_NAME + "=1";
            paramMap.put(RDI_PORT_REF_NAME_ATTR, RDI_PORT_MO_TYPE_NAME);
            paramMap.put("frotype", Integer.toString(0x1000016));
            paramMap.put("rdnValue", Integer.toString(k));
            paramMap.put("parentldn", iruLdn);
            paramMap.put("froid", Integer.toString(rdiPortFroIdGenerator));
            paramMap.put(REMOTE_RDI_PORT_REF_ATTR_NAME, remoteRdiPortRef);
            if (!firstRdiPortInstance) {
                logger.traceDebug(THIS_CLASS, "createIruRdiPorts() addRdiSpecAttributes");
                this.addRdiPortSpecAttributes(paramMap, rdFroAttributes);
            }
            CreateOneInstanceAction createOneInstanceAction = new CreateOneInstanceAction();
            createOneInstanceAction.setMoActionArgs(paramMap);
            createOneInstanceAction.convert(context);
            ++rdiPortFroIdGenerator;
            ++remoteRdiPortIdGenerator;
            firstRdiPortInstance = false;
            logger.traceReturn(THIS_CLASS, "createIruRdiPorts() executed");
        }
    }

    private FroAttributes[] getRadioDotSpecificFroAttributes() {
        logger.traceEnter(THIS_CLASS, "getRadioDotSpecificFroAttributes() invoked");
        ArrayList<FroAttributes> result = new ArrayList<FroAttributes>();
        result.add(new FroAttributes(0x1000000, AUX_PIU_ADM_STATE_ATTR_NAME, new String("S32")));
        result.add(new FroAttributes(0x1000000, AUX_PIU_POS_REF_ATTR_NAME, new String("struct")));
        result.add(new FroAttributes(0x1000000, AUX_PIU_PRO_DATA_ATTR_NAME, new String("struct")));
        FroAttributes[] radioDotSpecificAttributes = result.toArray(new FroAttributes[result.size()]);
        logger.traceReturn(THIS_CLASS, "getRadioDotSpecificFroAttributes() executed");
        return radioDotSpecificAttributes;
    }

    private FroAttributes[] getDevGroupSpecificFroAttributes() {
        logger.traceEnter(THIS_CLASS, "getDevGroupSpecificFroAttributes() invoked");
        ArrayList<FroAttributes> result = new ArrayList<FroAttributes>();
        result.add(new FroAttributes(0x1000001, AUX_PIU_FRO_ID_ATTR_NAME, "S32"));
        FroAttributes[] rdiPortSpecificAttributes = result.toArray(new FroAttributes[result.size()]);
        logger.traceReturn(THIS_CLASS, "getDevGroupSpecificFroAttributes() executed");
        return rdiPortSpecificAttributes;
    }

    private FroAttributes[] getRdiPortSpecificFroAttributes() {
        logger.traceEnter(THIS_CLASS, "getRdiPortSpecificFroAttributes() invoked");
        ArrayList<FroAttributes> result = new ArrayList<FroAttributes>();
        result.add(new FroAttributes(0x1000016, REMOTE_RDI_PORT_REF_ATTR_NAME, "moref"));
        FroAttributes[] rdiPortSpecificAttributes = result.toArray(new FroAttributes[result.size()]);
        logger.traceReturn(THIS_CLASS, "getRdiPortSpecificFroAttributes() executed");
        return rdiPortSpecificAttributes;
    }

    private void addRadioDotSpecAttributes(Map paramMap, FroAttributes[] froAttributes) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addRadioDotSpecAttributes()");
        StringBuffer childAttributes = new StringBuffer("<attributes>");
        for (int a = 0; a < froAttributes.length; ++a) {
            String attrName = froAttributes[a].attrName;
            int froTypeId = froAttributes[a].froTypeId;
            logger.traceDebug(THIS_CLASS, "New attribute" + attrName + " added to fro with type " + froTypeId);
            if (attrName.equalsIgnoreCase(AUX_PIU_ADM_STATE_ATTR_NAME)) {
                childAttributes.append("<attr name=\"" + attrName + "\" type=\"" + froAttributes[a].attrType + "\" value=\"" + Integer.toString(1) + "\" />");
                continue;
            }
            if (attrName.equalsIgnoreCase(AUX_PIU_POS_REF_ATTR_NAME)) {
                childAttributes.append("<attr name=\"" + attrName + "\" type=\"" + froAttributes[a].attrType + "\" value=\"" + this.creatEmptyePositionRefStruct() + "\" />");
                continue;
            }
            if (!attrName.equalsIgnoreCase(AUX_PIU_PRO_DATA_ATTR_NAME)) continue;
            childAttributes.append("<attr name=\"" + attrName + "\" type=\"" + froAttributes[a].attrType + "\" value=\"" + this.createEmptyProductDataStruct() + "\" />");
        }
        childAttributes.append("</attributes>");
        paramMap.put("childAttributes", childAttributes.toString());
        logger.traceReturn(THIS_CLASS, "addRadioDotSpecAttributes()");
    }

    private void addDevGroupSpecAttributes(Map paramMap, FroAttributes[] froAttributes) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addDevGroupSpecAttributes()");
        StringBuffer childAttributes = new StringBuffer("<attributes>");
        for (int a = 0; a < froAttributes.length; ++a) {
            String attrName = froAttributes[a].attrName;
            int froTypeId = froAttributes[a].froTypeId;
            logger.traceDebug(THIS_CLASS, "New attribute: " + attrName + " added to fro with type " + froTypeId);
            if (!attrName.equalsIgnoreCase(AUX_PIU_FRO_ID_ATTR_NAME)) continue;
            childAttributes.append("<attr name=\"piuFroId\" type=\"S32\" value=\"" + paramMap.get(attrName).toString() + "\" />");
        }
        childAttributes.append("</attributes>");
        paramMap.put("childAttributes", childAttributes.toString());
        logger.traceReturn(THIS_CLASS, "addDevGroupSpecAttributes()");
    }

    private void addRdiPortSpecAttributes(Map paramMap, FroAttributes[] froAttributes) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addRdiPortSpecAttributes()");
        StringBuffer childAttributes = new StringBuffer("<attributes>");
        for (int a = 0; a < froAttributes.length; ++a) {
            String attrName = froAttributes[a].attrName;
            int froTypeId = froAttributes[a].froTypeId;
            logger.traceDebug(THIS_CLASS, "New attribute" + attrName + " added to fro with type " + froTypeId);
            if (!attrName.equalsIgnoreCase(REMOTE_RDI_PORT_REF_ATTR_NAME)) continue;
            childAttributes.append("<attr name=\"" + attrName + "\" type=\"" + froAttributes[a].attrType + "\" value=\"" + this.createMoRef(attrName, paramMap.get(attrName).toString(), "-1") + "\" />");
        }
        childAttributes.append("</attributes>");
        paramMap.put("childAttributes", childAttributes.toString());
        logger.traceReturn(THIS_CLASS, "addRdiPortSpecAttributes()");
    }

    private void addRdiPortSpecAttributes(Map oldParamMap, FroAttributes[] froAttributes, AueContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addRdiPortSpecAttributes()");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (int a = 0; a < froAttributes.length; ++a) {
            String attrName = froAttributes[a].attrName;
            paramMap.put("Mo", RDI_PORT_MO_TYPE_NAME);
            paramMap.put(RDI_PORT_REF_NAME_ATTR, attrName);
            paramMap.put("type", froAttributes[a].attrType);
            if (attrName.equalsIgnoreCase(REMOTE_RDI_PORT_REF_ATTR_NAME)) {
                paramMap.put("defaultValue", this.createMoRef(attrName, oldParamMap.get(attrName).toString(), "-1"));
            }
            AddAttributeAction addAttributeAction = new AddAttributeAction();
            addAttributeAction.setMoActionArgs(paramMap);
            addAttributeAction.convert(context);
            paramMap.clear();
        }
        logger.traceReturn(THIS_CLASS, "addRdiPortSpecAttributes()");
    }

    private String createMoRef(String attrName, String refLdn, String refFroId) throws CrbsAueException {
        String moRef = "<moref name=\"" + attrName + "\"><attr name=\"ldn\" type=\"STRING\" " + "value=\"" + refLdn + "\"/><attr name=\"froType\" type=\"S32\" value=\"" + 0x1000016 + "\"/>" + "<attr name=\"froId\" type=\"S32\" value=\"" + refFroId + "\"/></moref>";
        return moRef;
    }

    private void updateAllRdiPortsMoRef() throws CrbsAueException {
        try {
            TableData rdiPortTableData = tableHandler.getTableData(RDI_PORT_MO_TYPE_NAME);
            if (rdiPortTableData.hasColumns()) {
                Object[] froLDN = rdiPortTableData.getAttributeValues(LDN_ATTR_NAME);
                Object[] values = rdiPortTableData.getAttributeValues(REMOTE_RDI_PORT_REF_ATTR_NAME);
                if (froLDN != null && froLDN.length > 0) {
                    for (int index = 0; index < froLDN.length; ++index) {
                        Map attributes = this.getRdioPrtRefAttributesMap(values[index].toString());
                        String remoteRefLdn = attributes.get(LDN_ATTR_NAME).toString();
                        String remoteRdiPortFroId = this.getCorrectRdioPrtRefFroId(remoteRefLdn);
                        String correctedRemoteRiPortAttr = this.createMoRef(REMOTE_RDI_PORT_REF_ATTR_NAME, remoteRefLdn, remoteRdiPortFroId);
                        rdiPortTableData.setAttributeValue(index, REMOTE_RDI_PORT_REF_ATTR_NAME, (Object)correctedRemoteRiPortAttr);
                    }
                }
            }
        }
        catch (TableDataException e) {
            throw new CrbsAueException("updateAllRdiPortsMoRef: Error when reading rdiPort table data");
        }
        catch (Exception e) {
            throw new CrbsAueException("updateAllRdiPortsMoRef: Error reading remote rdiPort table data");
        }
    }

    private Map getRdioPrtRefAttributesMap(String xml) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(xml));
        Document d = builder.parse(is);
        NodeList nodeList = d.getElementsByTagName(RDI_PORT_REF_ATTR_TAG);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String name = node.getAttributes().getNamedItem(RDI_PORT_REF_NAME_ATTR).getNodeValue();
            String value = node.getAttributes().getNamedItem(RDI_PORT_REF_VALUE_ATTR).getNodeValue();
            value = node.getAttributes().getNamedItem(RDI_PORT_REF_VALUE_ATTR).getNodeValue();
            result.put(name, value);
        }
        return result;
    }

    private String getCorrectRdioPrtRefFroId(String ldn) throws Exception {
        String refFroId;
        block4: {
            refFroId = "";
            try {
                Object[] riPortLDN;
                TableData rdiPortTableData = tableHandler.getTableData(RDI_PORT_MO_TYPE_NAME);
                if (!rdiPortTableData.hasColumns() || (riPortLDN = rdiPortTableData.getAttributeValues(LDN_ATTR_NAME)) == null || riPortLDN.length <= 0) break block4;
                for (int index = 0; index < riPortLDN.length; ++index) {
                    String currRdiPortLdn = riPortLDN[index].toString();
                    if (currRdiPortLdn.compareTo(ldn) != 0) continue;
                    refFroId = Integer.toString(index);
                    break;
                }
            }
            catch (TableDataException e) {
                throw new CrbsAueException("Error when reading rdiPort table data");
            }
            catch (Exception e) {
                throw new CrbsAueException("Error reading remote rdiPort table data");
            }
        }
        return refFroId;
    }

    private String creatEmptyePositionRefStruct() {
        String positionRef = "<moref name=\"positionRef\"><attr name=\"ldn\" type=\"STRING\" value=\"\"/><attr name=\"froType\" type=\"S32\" value=\"-1\"/><attr name=\"froId\" type=\"S32\" value=\"-1\"/></moref>";
        return positionRef;
    }

    private String createEmptyProductDataStruct() {
        String productData = "<struct name=\"productData\"><attr name=\"productionDate\" type=\"STRING\" value=\"\"/><attr name=\"productName\" type=\"STRING\" value=\"RD \"/><attr name=\"productNumber\" type=\"STRING\" value=\"\"/><attr name=\"productRevision\" type=\"STRING\" value=\"\"/><attr name=\"serialNumber\" type=\"STRING\" value=\"\"/></struct>";
        return productData;
    }

    static {
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
        dotId = 1;
        auxPiuRdiFroIdGenerator = 0;
        deviceGroupFroIdGenerator = 0;
        rdiPortFroIdGenerator = 0;
        rdicDevSetFroIdGenerator = 0;
        remoteRdiPortIdGenerator = 1;
        firstDotRdiInstance = true;
    }

    private class FroAttributes {
        private final int froTypeId;
        private final String attrName;
        private final String attrType;

        private FroAttributes(int froTypeId, String attrName, String attrType) {
            this.froTypeId = froTypeId;
            this.attrName = attrName;
            this.attrType = attrType;
        }
    }
}

