/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.omf.aue.step1.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.AddAttributeAction;
import se.ericsson.crbs.omf.aue.step1.actions.CreateOneInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.TableDataUtil;

public class ConvertRiPortRefToRiLinkAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = ConvertRiPortRefToRiLinkAction.class;
    private static TableHandler tableHandler;
    private static final AbstractLogger logger;
    private static final String LDN_ATTR_NAME = "ldn";
    private static final String REMOTE_RI_PORT_REF_ATTR_NAME = "remoteRiPortRef";
    private static final String RI_PORT_MO_TYPE_NAME = "RiPort";
    private static final String RI_LINK_MO_TYPE_NAME = "RiLink";
    private static final int RI_LINK_FRO_TYPE_ID = 0x1000014;
    private static final int RI_PORT_FRO_TYPE_ID = 0x1000003;
    private static final String RI_LINK_TYPE_ATTR_NAME = "linkType";
    private static final String RI_PORT_REF1_ATTR_NAME = "riPortRef1";
    private static final String RI_PORT_REF2_ATTR_NAME = "riPortRef2";
    private static final String RI_LINK_DATA = "riLinkData";
    private static final int DEFAULT_RI_LINK_TYPE = 1;
    private static final String RI_LINK_PARENT_LDN = "ManagedElement=1,Equipment=1";
    private static final List SPECIFIC_XMU_IDS;
    private static final List ALLOWED_IDS;
    private TableData riPortTableData;
    private Object[] riPortsLDN;
    private Object[] riPortsRemoteRefLDN;
    private Object[] froIdColumnDatas;

    public void convert(AueContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        int id = 1;
        int froId = 0;
        boolean firstInstance = true;
        HashMap<String, String> riLinkAttrs = new HashMap<String, String>();
        String riLinkData = "";
        tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            this.riPortTableData = tableHandler.getTableData(RI_PORT_MO_TYPE_NAME);
            if (this.riPortTableData.isNotEmpty()) {
                this.riPortsLDN = this.riPortTableData.getAttributeValues(LDN_ATTR_NAME);
                this.riPortsRemoteRefLDN = this.riPortTableData.getAttributeValues(REMOTE_RI_PORT_REF_ATTR_NAME);
                this.froIdColumnDatas = this.riPortTableData.getAttributeValues("froid");
                ArrayList<String> alreadyConvertedLDN = new ArrayList<String>();
                for (int i = 0; i < this.riPortsLDN.length; ++i) {
                    String riPortRef1 = this.riPortsLDN[i].toString();
                    String riPortRef2 = TableDataUtil.getLdnFromMoRef((String)this.riPortsRemoteRefLDN[i].toString());
                    String riPortRef1_id = riPortRef1.substring(riPortRef1.lastIndexOf(61) + 1);
                    if (riPortRef1.compareTo("") == 0 || riPortRef2.compareTo("") == 0) continue;
                    boolean alreadyConverted = this.checkIfAlreadyConverted(riPortRef1, alreadyConvertedLDN);
                    boolean toBeSavedAsAuePeristencyData = false;
                    String identity = "";
                    String froIdStr = "";
                    String ldn = "";
                    String riLinkType = "";
                    if (SPECIFIC_XMU_IDS.contains(riPortRef1_id)) {
                        riLinkAttrs.put(RI_PORT_REF2_ATTR_NAME, riPortRef1);
                        riLinkData = riPortRef1 + "&" + riPortRef1;
                        toBeSavedAsAuePeristencyData = true;
                    } else if (ALLOWED_IDS.contains(riPortRef1_id) && !alreadyConverted) {
                        riLinkAttrs.put(RI_PORT_REF2_ATTR_NAME, riPortRef2);
                        riLinkData = riPortRef1 + "&" + riPortRef2;
                        toBeSavedAsAuePeristencyData = true;
                        alreadyConvertedLDN.add(riPortRef2);
                    }
                    if (!toBeSavedAsAuePeristencyData) continue;
                    try {
                        froIdStr = Integer.toString(froId++);
                        identity = Integer.toString(id++);
                        ldn = new String("ManagedElement=1,Equipment=1,RiLink=" + identity);
                        riLinkType = Integer.toString(1);
                        riLinkAttrs.put(LDN_ATTR_NAME, ldn);
                        riLinkAttrs.put("parentldn", RI_LINK_PARENT_LDN);
                        riLinkAttrs.put(RI_LINK_TYPE_ATTR_NAME, riLinkType);
                        riLinkAttrs.put(RI_PORT_REF1_ATTR_NAME, riPortRef1);
                        riLinkAttrs.put("froid", froIdStr);
                        riLinkAttrs.put("rdnValue", identity);
                        tableHandler.storeInAuePersistency("", RI_LINK_DATA + identity, riLinkData);
                        this.createOneInstance(firstInstance, riLinkAttrs, context);
                        firstInstance = false;
                        continue;
                    }
                    catch (TableDataException tde) {
                        throw new CrbsAueException(tde.getMessage(), (Throwable)tde);
                    }
                }
            }
        }
        catch (TableDataException e) {
            throw new CrbsAueException("Failed to read/write TableData", (Throwable)e);
        }
        logger.traceReturn(THIS_CLASS, "convert() executed");
    }

    private void createOneInstance(boolean firstInstance, Map values, AueContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createOneInstance() with froTypeName:RiLink");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        FroAttributes[] froAttributes = this.getRiLinkFroAttributes();
        paramMap.put("name", RI_LINK_MO_TYPE_NAME);
        paramMap.put("frotype", Integer.toString(0x1000014));
        paramMap.put("rdnValue", (String)values.get("rdnValue"));
        paramMap.put("parentldn", (String)values.get("parentldn"));
        paramMap.put("froid", (String)values.get("froid"));
        paramMap.put(RI_LINK_TYPE_ATTR_NAME, (String)values.get(RI_LINK_TYPE_ATTR_NAME));
        paramMap.put(RI_PORT_REF1_ATTR_NAME, (String)values.get(RI_PORT_REF1_ATTR_NAME));
        paramMap.put(RI_PORT_REF2_ATTR_NAME, (String)values.get(RI_PORT_REF2_ATTR_NAME));
        if (!firstInstance) {
            logger.traceDebug(THIS_CLASS, "createOneInstance() addMoTypeSpecificAttributesAsChildAttributes");
            this.addMoTypeSpecificAttributes(paramMap, froAttributes);
        }
        CreateOneInstanceAction createOneInstanceAction = new CreateOneInstanceAction();
        createOneInstanceAction.setMoActionArgs(paramMap);
        createOneInstanceAction.convert(context);
        if (firstInstance) {
            logger.traceDebug(THIS_CLASS, "createOneInstance() addMoTypeSpecificAttributes");
            this.addMoTypeSpecificAttributes(paramMap, froAttributes, context);
        }
        logger.traceReturn(THIS_CLASS, "createOneInstance() executed");
    }

    private FroAttributes[] getRiLinkFroAttributes() {
        logger.traceEnter(THIS_CLASS, "getRiLinkFroAttributes() invoked");
        ArrayList<FroAttributes> result = new ArrayList<FroAttributes>();
        result.add(new FroAttributes(0x1000014, RI_LINK_TYPE_ATTR_NAME, new String("S32")));
        result.add(new FroAttributes(0x1000014, RI_PORT_REF1_ATTR_NAME, new String("moRef")));
        result.add(new FroAttributes(0x1000014, RI_PORT_REF2_ATTR_NAME, new String("moRef")));
        FroAttributes[] riLinkAttributes = result.toArray(new FroAttributes[result.size()]);
        logger.traceReturn(THIS_CLASS, "getRiLinkFroAttributes() executed");
        return riLinkAttributes;
    }

    private boolean checkIfAlreadyConverted(String riLinkRef2, List riPortsLDN) {
        boolean alreadyConverted = false;
        for (int i = 0; i < riPortsLDN.size(); ++i) {
            if (riLinkRef2.compareTo(riPortsLDN.get(i)) != 0) continue;
            alreadyConverted = true;
        }
        return alreadyConverted;
    }

    private void addMoTypeSpecificAttributes(Map paramMap, FroAttributes[] froAttributes) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addMoTypeSpecificAttributes()");
        StringBuffer childAttributes = new StringBuffer("<attributes>");
        for (int a = 0; a < froAttributes.length; ++a) {
            String attrName = froAttributes[a].attrName;
            int froTypeId = froAttributes[a].froTypeId;
            logger.traceDebug(THIS_CLASS, "New attribute" + attrName + " added to fro with type " + froTypeId);
            if (attrName.equalsIgnoreCase(RI_LINK_TYPE_ATTR_NAME)) {
                childAttributes.append("<attr name=\"" + attrName + "\" type=\"" + froAttributes[a].attrType + "\" value=\"" + paramMap.get(attrName) + "\" />");
                continue;
            }
            if (!attrName.equalsIgnoreCase(RI_PORT_REF1_ATTR_NAME) && !attrName.equalsIgnoreCase(RI_PORT_REF2_ATTR_NAME)) continue;
            childAttributes.append("<attr name=\"" + attrName + "\" type=\"" + froAttributes[a].attrType + "\" value=\"" + this.createMoRef(attrName, paramMap.get(attrName).toString()) + "\" />");
        }
        childAttributes.append("</attributes>");
        paramMap.put("childAttributes", childAttributes.toString());
        logger.traceReturn(THIS_CLASS, "addMoTypeSpecificAttributes()");
    }

    private void addMoTypeSpecificAttributes(Map oldParamMap, FroAttributes[] froAttributes, AueContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addMoTypeSpecificAttributes()");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (int a = 0; a < froAttributes.length; ++a) {
            String attrName = froAttributes[a].attrName;
            paramMap.put("Mo", RI_LINK_MO_TYPE_NAME);
            paramMap.put("name", attrName);
            paramMap.put("type", froAttributes[a].attrType);
            if (attrName.equalsIgnoreCase(RI_LINK_TYPE_ATTR_NAME)) {
                paramMap.put("defaultValue", (String)oldParamMap.get(attrName));
            } else if (attrName.equalsIgnoreCase(RI_PORT_REF1_ATTR_NAME) || attrName.equalsIgnoreCase(RI_PORT_REF2_ATTR_NAME)) {
                paramMap.put("defaultValue", this.createMoRef(attrName, oldParamMap.get(attrName).toString()));
            }
            AddAttributeAction addAttributeAction = new AddAttributeAction();
            addAttributeAction.setMoActionArgs(paramMap);
            addAttributeAction.convert(context);
            paramMap.clear();
        }
        logger.traceReturn(THIS_CLASS, "addMoTypeSpecificAttributes()");
    }

    private String createMoRef(String attrName, String refLdn) throws CrbsAueException {
        String refFroType = Integer.toString(0x1000003);
        String refFroId = "1";
        try {
            TableData refTableData = tableHandler.getTableData(RI_PORT_MO_TYPE_NAME);
            if (refTableData.hasColumns()) {
                refFroId = this.getRefFroId(refLdn);
            }
        }
        catch (TableDataException e) {
            throw new CrbsAueException("Error getting parent table data");
        }
        String moRef = "<moref name=\"" + attrName + "\"><attr name=\"ldn\" type=\"STRING\" value=\"" + refLdn + "\"/><attr name=\"froType\" type=\"S32\" value=\"" + refFroType + "\"/><attr name=\"froId\" type=\"S32\" value=\"" + refFroId + "\"/></moref>";
        return moRef;
    }

    private String getRefFroId(String refLdn) throws CrbsAueException, TableDataException {
        String froId = null;
        for (int row = 0; row < this.riPortsLDN.length; ++row) {
            if (!this.riPortsLDN[row].toString().equalsIgnoreCase(refLdn)) continue;
            froId = this.froIdColumnDatas[row].toString();
        }
        if (froId == null) {
            throw new CrbsAueException("The froId for MO with LDN:  " + refLdn + " could not be found in the database");
        }
        return froId;
    }

    static {
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
        SPECIFIC_XMU_IDS = new ArrayList(2);
        SPECIFIC_XMU_IDS.add("B1");
        SPECIFIC_XMU_IDS.add("B2");
        ALLOWED_IDS = new ArrayList(14);
        ALLOWED_IDS.add("A");
        ALLOWED_IDS.add("B");
        ALLOWED_IDS.add("C");
        ALLOWED_IDS.add("D");
        ALLOWED_IDS.add("E");
        ALLOWED_IDS.add("F");
        ALLOWED_IDS.add("C1");
        ALLOWED_IDS.add("C2");
        ALLOWED_IDS.add("C3");
        ALLOWED_IDS.add("C4");
        ALLOWED_IDS.add("C5");
        ALLOWED_IDS.add("C6");
        ALLOWED_IDS.add("DATA_1");
        ALLOWED_IDS.add("DATA_2");
    }

    private class FroAttributes {
        private final int froTypeId;
        private final String attrName;
        private final String attrType;

        private FroAttributes(int froTypeId, String attrName, String attrType) {
            this.froTypeId = froTypeId;
            this.attrName = attrName;
            this.attrType = attrType;
        }
    }
}

