/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.omf.aue.step1.actions;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class CopyConfOutputPowerToConfiguredOutputPowerAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = CopyConfOutputPowerToConfiguredOutputPowerAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String CONF_OUTPUT_POWER = "confOutputPower";
    private static final String CONFIGURED_OUTPUT_POWER = "configuredOutputPower";

    public void convert(AueContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String froTypeName = this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        TableHandler tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            TableData tableData = tableHandler.getTableData(froTypeName);
            Object[] oldValues = tableData.getAttributeValues(CONF_OUTPUT_POWER);
            try {
                for (int i = 0; i < oldValues.length; ++i) {
                    tableData.setAttributeValue(i, CONFIGURED_OUTPUT_POWER, (Object)new Integer((Integer)oldValues[i] * 1000));
                }
            }
            catch (TableDataException e) {
                throw new CrbsAueException("It is not possible to set : " + froTypeName, (Throwable)e);
            }
        }
        catch (TableDataException noTableData) {
            logger.traceDebug(THIS_CLASS, "There is no table data for " + froTypeName);
        }
    }
}

