/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.omf.aue.step1.actions;

import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.actions.TableAlreadyExistsException;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.DbWrapperFactory;
import se.ericsson.crbs.omf.aue.common.db.sql.Sql;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.AddAttributeAction;
import se.ericsson.crbs.omf.aue.step1.actions.ChangeAttributeValueAction;
import se.ericsson.crbs.omf.aue.step1.actions.CreateOneInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class CopyLteCapacityFeatureToGlmsAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = CopyLteCapacityFeatureToGlmsAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String NOAM_FRO_VERSIONS = "fro_versions";
    private static final String NOAM_FRO_VERSIONS_UPGR = "fro_versions_new";
    private static final String PARENT_LDN = "ManagedElement=1,SystemFunctions=1,Licensing=1";
    private static final String GRACE_PERIOD_ACTIVE = "gracePeriodActive";
    private static final String GRACE_PERIOD_AVAILABLE = "gracePeriodAvailable";
    private static final String GRACE_PERIOD_ORIGINAL_LICENSE_LIMIT = "gracePeriodOriginalLicenseLimit";
    private static final String GRACE_PERIOD_TIME_LEFT = "gracePeriodTimeLeft";
    private static final String GRACE_PERIOD_ACTIVATION_THRESHOLD = "gracePeriodActivationThreshold";
    private static final String GRACE_PERIOD_LENGTH = "gracePeriodLength";
    private static final String GRACE_PERIOD_RESET_THRESHOLD = "gracePeriodResetThreshold";
    private static final int GLMS_FRO_TYPE_ID = 0x1020001;
    private static final String GLMS_MO_TYPE_NAME = "CapacityFeatureLicense";
    private static final String[] GLMS_ATTR_NAMES_ARRAY = new String[]{"userLabel", "keyId", "capacityType", "capacityUnit", "gracePeriod", "gracePeriodActivationThreshold", "gracePeriodLength", "gracePeriodResetThreshold", "markedForDeletion"};
    private static final String[] GLMS_ATTR_TYPES_ARRAY = new String[]{"STRING", "STRING", "S32", "STRING", "struct", "S32", "S32", "S32", "STRING"};
    private static final String[] GLMS_ATTR_VALUES_ARRAY = new String[]{"", "0", "0", "", "", "0", "0", "0", ""};
    private boolean glmsFroDataTableExists = false;
    private boolean glmsInstanceExists = false;

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String legacyMoTypeName = this.getAndCheckParamMapString("fromMo", this.paramMap, "The Legacy License MO Type name is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        String glmsInstanceName = this.getAndCheckParamMapString("rdnValue", this.paramMap, "The Glms Instance name is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        String keyId = this.getAndCheckParamMapString("keyId", this.paramMap, "The Key Id is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        if (legacyMoTypeName.equals("CapacityConnectedUsers")) {
            DbWrapper dbWrapper;
            TableData glmsTableData;
            logger.traceDebug(THIS_CLASS, "convert connected user related capacity license");
            CopyLteCapacityFeatureToGlmsAction.GLMS_ATTR_VALUES_ARRAY[0] = glmsInstanceName;
            CopyLteCapacityFeatureToGlmsAction.GLMS_ATTR_VALUES_ARRAY[1] = keyId;
            CopyLteCapacityFeatureToGlmsAction.GLMS_ATTR_VALUES_ARRAY[2] = "0";
            CopyLteCapacityFeatureToGlmsAction.GLMS_ATTR_VALUES_ARRAY[3] = "Number of Connected Users";
            try {
                TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
                glmsTableData = tableHandler.getTableData(GLMS_MO_TYPE_NAME);
                dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
            }
            catch (TableDataException tde) {
                throw new CrbsAueException("Failed to read Glms FRO table for " + glmsInstanceName, (Throwable)tde);
            }
            try {
                this.checkGlmsFroData(keyId, glmsTableData);
            }
            catch (TableDataException tde) {
                throw new CrbsAueException("Failed to read Glms FRO table for " + glmsInstanceName, (Throwable)tde);
            }
            if (this.glmsFroDataTableExists) {
                if (this.glmsInstanceExists) {
                    logger.traceDebug(THIS_CLASS, "GLMS Instance already exists.");
                } else {
                    logger.traceDebug(THIS_CLASS, "GLMS Instance does not exist but GLMS table exists.");
                }
            } else {
                logger.traceDebug(THIS_CLASS, "GLMS table does not exists");
            }
            String froDataTableName = null;
            try {
                froDataTableName = this.getLegacyFroDataTableName(legacyMoTypeName, dbWrapper);
                if (froDataTableName != null) {
                    String capacityData;
                    CopyLteCapacityFeatureToGlmsAction.GLMS_ATTR_VALUES_ARRAY[4] = capacityData = this.readLegacyAttributeValue(froDataTableName, dbWrapper);
                }
            }
            catch (SQLException sqlException) {
                logger.traceError(THIS_CLASS, "Failed to read grace period attributes from " + legacyMoTypeName, (Throwable)sqlException);
            }
            try {
                froDataTableName = this.getLegacyFroDataTableName("CapacityLicenses", dbWrapper);
                if (froDataTableName != null) {
                    String[] gracePeriodData = this.readLegacyParentAttributeValue(froDataTableName, dbWrapper);
                    for (int i = 0; i < 3; ++i) {
                        CopyLteCapacityFeatureToGlmsAction.GLMS_ATTR_VALUES_ARRAY[i + 5] = gracePeriodData[i];
                    }
                }
            }
            catch (SQLException sqlException) {
                logger.traceError(THIS_CLASS, "Failed to read grace period attributes from CapacityLicenses", (Throwable)sqlException);
            }
            try {
                if (this.glmsInstanceExists) {
                    this.changeMoTypeSpecificAttributes(aueContext, glmsInstanceName);
                    logger.traceGeneral(THIS_CLASS, "Glmo Mo Instance " + glmsInstanceName + " value updated.");
                } else {
                    this.createOneInstance(glmsInstanceName, aueContext);
                    logger.traceGeneral(THIS_CLASS, "Glms Mo Instance " + glmsInstanceName + " successfully created.");
                }
            }
            catch (Exception exception) {
                throw new CrbsAueException("Failed to create Glms Mo instance " + glmsInstanceName, (Throwable)exception);
            }
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLegacyFroDataTableName(String froTypeName, DbWrapper dbWrapper) throws SQLException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getLegacyFroDataTableName() for froTypeName: " + froTypeName);
        String froDataTableName = null;
        String noamFroVersions = dbWrapper.doTableExist(NOAM_FRO_VERSIONS_UPGR) ? NOAM_FRO_VERSIONS_UPGR : NOAM_FRO_VERSIONS;
        Sql.Select selectFroVersions = new Sql.Select(noamFroVersions, new Sql.Select.ColumnValue("frotypename", (Object)froTypeName));
        ResultSet resultSet = dbWrapper.executeQuery(selectFroVersions);
        try {
            if (resultSet.next()) {
                froDataTableName = resultSet.getString(3);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        logger.traceReturn(THIS_CLASS, "getLegacyFroDataTableName()");
        return froDataTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readLegacyAttributeValue(String froDataTableName, DbWrapper dbWrapper) throws SQLException, CrbsAueException {
        String result;
        block7: {
            logger.traceEnter(THIS_CLASS, "readLegacyAttributeValue()");
            Sql.Select selectFroData = new Sql.Select(froDataTableName);
            ResultSet froData = dbWrapper.executeQuery(selectFroData);
            result = "";
            try {
                if (!froData.next()) break block7;
                int column = froData.findColumn(GRACE_PERIOD_ACTIVE);
                Object value = froData.getObject(column);
                String valueString = value.toString();
                boolean gracePeriodActive = !valueString.trim().equals("0");
                logger.traceDebug(THIS_CLASS, "GracePeriodActive converted from: " + valueString + " to: " + gracePeriodActive);
                column = froData.findColumn(GRACE_PERIOD_AVAILABLE);
                value = froData.getObject(column);
                valueString = value.toString();
                boolean gracePeriodAvailable = !valueString.trim().equals("0");
                logger.traceDebug(THIS_CLASS, "GracePeriodAvailable converted from: " + valueString + "to: " + gracePeriodAvailable);
                column = froData.findColumn(GRACE_PERIOD_ORIGINAL_LICENSE_LIMIT);
                value = froData.getObject(column);
                long gracePeriodOriginalLicenseLimit = Long.parseLong(value.toString());
                column = froData.findColumn(GRACE_PERIOD_TIME_LEFT);
                long gracePeriodTimeLeft = 0L;
                value = froData.getObject(column);
                if (value != null && value.toString().length() != 0) {
                    try {
                        gracePeriodTimeLeft = Long.parseLong(value.toString());
                    }
                    catch (Exception e) {
                        logger.traceDebug(THIS_CLASS, "Have difficulty to parse the gracePeriodTimeLife attribute: " + value);
                    }
                }
                result = this.constructGracePeriod(gracePeriodActive, gracePeriodAvailable, gracePeriodOriginalLicenseLimit, gracePeriodTimeLeft);
            }
            finally {
                if (froData != null) {
                    froData.close();
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "readLegacyAttributeValue()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] readLegacyParentAttributeValue(String froDataTableName, DbWrapper dbWrapper) throws SQLException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "readLegacyParentAttributeValue()");
        Sql.Select selectFroData = new Sql.Select(froDataTableName);
        ResultSet froData = dbWrapper.executeQuery(selectFroData);
        String[] result = new String[3];
        String[] columnName = new String[]{GRACE_PERIOD_ACTIVATION_THRESHOLD, GRACE_PERIOD_LENGTH, GRACE_PERIOD_RESET_THRESHOLD};
        try {
            if (froData.next()) {
                Object value = null;
                for (int i = 0; i < columnName.length; ++i) {
                    int column = froData.findColumn(columnName[i]);
                    value = froData.getObject(column);
                    result[i] = value.toString();
                }
            }
        }
        finally {
            if (froData != null) {
                froData.close();
            }
        }
        logger.traceReturn(THIS_CLASS, "readLegacyParentAttributeValue()");
        return result;
    }

    private void checkGlmsFroData(String keyId, TableData glmsTableData) throws TableDataException {
        if (!"".equals(glmsTableData.getTableName())) {
            this.glmsFroDataTableExists = true;
        }
        if (glmsTableData.isNotEmpty()) {
            Object[] keyIds = glmsTableData.getAttributeValues("keyId");
            for (int i = 0; i < keyIds.length; ++i) {
                if (!keyId.equals(keyIds[i])) continue;
                this.glmsInstanceExists = true;
            }
        }
    }

    private void createOneInstance(String glmsId, AueContext aueContext) throws CrbsAueException, SQLException, NoSuchTableException, TableAlreadyExistsException {
        logger.traceEnter(THIS_CLASS, "createOneInstance() froTypeName:CapacityFeatureLicense");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("name", GLMS_MO_TYPE_NAME);
        paramMap.put("frotype", Integer.toString(0x1020001));
        paramMap.put("rdnValue", glmsId);
        paramMap.put("parentldn", PARENT_LDN);
        if (this.glmsFroDataTableExists) {
            this.addMoTypeSpecificAttributesAsChildAttributes(paramMap);
        }
        CreateOneInstanceAction createOneInstanceAction = new CreateOneInstanceAction();
        createOneInstanceAction.setMoActionArgs(paramMap);
        createOneInstanceAction.convert(aueContext);
        if (!this.glmsFroDataTableExists) {
            this.addMoTypeSpecificAttributes(aueContext);
        }
        logger.traceReturn(THIS_CLASS, "createOneInstance()");
    }

    private void changeMoTypeSpecificAttributes(AueContext context, String glmsId) throws SQLException, CrbsAueException, NoSuchTableException, TableAlreadyExistsException {
        logger.traceEnter(THIS_CLASS, "changeMoTypeSpecificAttributes()");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (int a = 4; a < 8; ++a) {
            paramMap.put("Mo", GLMS_MO_TYPE_NAME);
            paramMap.put("rdnValue", glmsId);
            paramMap.put("attribute", GLMS_ATTR_NAMES_ARRAY[a]);
            paramMap.put("newAttributeValue", GLMS_ATTR_VALUES_ARRAY[a]);
            ChangeAttributeValueAction changeAttributeValueAction = new ChangeAttributeValueAction();
            changeAttributeValueAction.setMoActionArgs(paramMap);
            changeAttributeValueAction.convert(context);
            paramMap.clear();
            logger.traceReturn(THIS_CLASS, "changeMoTypeSpecificAttributes()");
        }
    }

    private void addMoTypeSpecificAttributesAsChildAttributes(Map paramMap) throws SQLException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addMoTypeSpecificAttributesAsChildAttributes()");
        StringBuffer childAttributes = new StringBuffer("<attributes>");
        for (int a = 0; a < GLMS_ATTR_NAMES_ARRAY.length; ++a) {
            childAttributes.append("<attr name=\"" + GLMS_ATTR_NAMES_ARRAY[a] + "\" type=\"" + GLMS_ATTR_TYPES_ARRAY[a] + "\" value=\"" + GLMS_ATTR_VALUES_ARRAY[a] + "\" />");
        }
        childAttributes.append("</attributes>");
        paramMap.put("childAttributes", childAttributes.toString());
        logger.traceReturn(THIS_CLASS, "addMoTypeSpecificAttributesAsChildAttributes()");
    }

    private void addMoTypeSpecificAttributes(AueContext context) throws SQLException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addMoTypeSpecificAttributes()");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (int a = 0; a < GLMS_ATTR_NAMES_ARRAY.length; ++a) {
            paramMap.put("Mo", GLMS_MO_TYPE_NAME);
            paramMap.put("name", GLMS_ATTR_NAMES_ARRAY[a]);
            paramMap.put("type", GLMS_ATTR_TYPES_ARRAY[a]);
            paramMap.put("defaultValue", GLMS_ATTR_VALUES_ARRAY[a]);
            AddAttributeAction addAttributeAction = new AddAttributeAction();
            addAttributeAction.setMoActionArgs(paramMap);
            addAttributeAction.convert(context);
            paramMap.clear();
        }
        logger.traceReturn(THIS_CLASS, "addMoTypeSpecificAttributes()");
    }

    private String constructGracePeriod(boolean gracePeriodActive, boolean gracePeriodAvailable, long gracePeriodOriginalLicenseLimit, long gracePeriodTimeLeft) {
        logger.traceEnter(THIS_CLASS, "constructGracePeriod()");
        int gracePeriodState = 0;
        gracePeriodState = !gracePeriodActive ? (!gracePeriodAvailable ? (gracePeriodOriginalLicenseLimit == 0L ? 0 : 4) : 1) : 2;
        String gracePeriodStartDate = "";
        String gracePeriodStopDate = "";
        if (gracePeriodActive) {
            long hourInMillis = 3600000L;
            Date currentDate = new Date();
            Date startDate = new Date(currentDate.getTime() - (gracePeriodOriginalLicenseLimit - gracePeriodTimeLeft) * 3600000L);
            Date stopDate = new Date(currentDate.getTime() + gracePeriodTimeLeft * 3600000L);
            gracePeriodStartDate = startDate.toString();
            gracePeriodStopDate = stopDate.toString();
        }
        StringBuffer structString = new StringBuffer("<struct name=\"gracePeriod\">");
        structString.append("<attr name=\"startDate\" type=\"STRING\" value=\"");
        structString.append(gracePeriodStartDate);
        structString.append("\"/>");
        structString.append("<attr name=\"stopDate\" type=\"STRING\" value=\"");
        structString.append(gracePeriodStopDate);
        structString.append("\"/>");
        structString.append("<attr name=\"gracePeriodState\" type=\"S32\" value=\"");
        structString.append(String.valueOf(gracePeriodState));
        structString.append("\"/>");
        structString.append("<attr name=\"isGracePeriodControlled\" type=\"S32\" value=\"1\"/>");
        structString.append("<attr name=\"originalLicenseLimit\" type=\"S32\" value=\"");
        structString.append(String.valueOf(gracePeriodOriginalLicenseLimit));
        structString.append("\"/>");
        structString.append("</struct>");
        logger.traceReturn(THIS_CLASS, "constructGracePeriod(): " + structString.toString());
        return structString.toString();
    }
}

