/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.omf.aue.step1.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.cat.omf.aue.step1.util.MoRef;
import se.ericsson.crbs.cat.omf.aue.step1.util.MoRefArrayParser;
import se.ericsson.crbs.cat.omf.aue.step1.util.MoRefParser;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.common.xml.XmlArrayHelper;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.AddAttributeAction;
import se.ericsson.crbs.omf.aue.step1.actions.CreateOneInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class CorrectFroRadioDotAntennaConnectionAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = CorrectFroRadioDotAntennaConnectionAction.class;
    private static TableHandler tableHandler;
    private static final AbstractLogger logger;
    private static final String AUX_PIU_IRU_PROD_NAME = "IRU";
    private TableData auxPlugInUnitTableData;
    private TableData deviceGroupTableData;
    private TableData rfPortTableData;
    private TableData rfBranchTableData;
    private TableData auPortTableData;
    private TableData antennaSubunitTableData;
    private TableData antennaUnitTableData;
    private TableData rdiPortTableData;
    private TableData transceiverTableData;
    private TableData multicastAntennaBranchTableData;
    private TableData sectorEquipmentFunctionTableData = null;
    private Object[] auxPlugInUnitLdns;
    private Object[] rfPortLdns;
    private Object[] rfBranchLdns;
    private Object[] auPortLdns;
    private Object[] antennaSubunitLdns;
    private Object[] antennaUnitLdns;
    private Object[] rdiPortLdns;
    private Object[] rdiPortRefs;
    private Object[] rfBranchAuPortRefs;
    private Object[] rfBranchRfPortRefs;
    private Object[] sectorEquipmentFunctionRfBranchRefs;
    private Object[] auxPiuProductData;
    private int transceiverFroId = 0;
    boolean transceiverFirstInstance = true;
    private int multicastAntBranchFroId = 0;
    private boolean multicastAntBranchFirstInstance = true;
    private String iruDeviceGroupLdn = "";
    private String rfPortALdn = "";
    private String rfPortBLdn = "";
    private String rfBranch1Ldn = "";
    private String rfBranch2Ldn = "";
    private String auPort1Ldn = "";
    private String auPort2Ldn = "";
    private String antennaSubunitLdn = "";
    private String antennaUnitLdn = "";
    private String antennaUnitGroupLdn = "";
    private String iruRdiPortRemoteRdiPortRefLdn = "";
    private String rdAuxPlugInUnitLdn = "";
    private String rdDeviceGroupLdn = "";
    private int notConnectedRemoteRdiPortRefsOnIruRdiPorts = 0;
    private int notConnectedRdDeviceGroups = 0;

    public void convert(AueContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert() entered");
        String irus = "";
        tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            this.auxPlugInUnitTableData = tableHandler.getTableData("AuxPlugInUnit");
            this.deviceGroupTableData = tableHandler.getTableData("DeviceGroup");
            this.rfPortTableData = tableHandler.getTableData("RfPort");
            this.rfBranchTableData = tableHandler.getTableData("RfBranch");
            this.auPortTableData = tableHandler.getTableData("AuPort");
            this.antennaSubunitTableData = tableHandler.getTableData("AntennaSubunit");
            this.antennaUnitTableData = tableHandler.getTableData("AntennaUnit");
            this.rdiPortTableData = tableHandler.getTableData("RdiPort");
            this.sectorEquipmentFunctionTableData = tableHandler.getTableData("SectorEquipmentFunction");
            this.transceiverTableData = tableHandler.getTableData("Transceiver");
            this.multicastAntennaBranchTableData = tableHandler.getTableData("MulticastAntennaBranch");
            if (this.auxPlugInUnitTableData.isNotEmpty()) {
                if (this.transceiverTableData.isNotEmpty() || this.multicastAntennaBranchTableData.isNotEmpty()) {
                    logger.traceGeneral(THIS_CLASS, "Either Transceiver or MulticastAntennaBranch FROs exist. No AUE can be done.");
                    return;
                }
                if (this.auxPlugInUnitTableData.isNotEmpty() && this.deviceGroupTableData.isNotEmpty() && this.rfPortTableData.isNotEmpty() && this.rfBranchTableData.isNotEmpty() && this.auPortTableData.isNotEmpty() && this.antennaSubunitTableData.isNotEmpty() && this.antennaUnitTableData.isNotEmpty() && this.rdiPortTableData.isNotEmpty() && this.sectorEquipmentFunctionTableData.isNotEmpty()) {
                    this.auxPlugInUnitLdns = this.auxPlugInUnitTableData.getAttributeValues("ldn");
                    for (int i = 0; i < this.auxPlugInUnitLdns.length; ++i) {
                        boolean multicastAntennaBranchCreated = false;
                        boolean iruConfig = this.checkIfThisIsAnIRUAuxPiu(this.auxPlugInUnitLdns[i].toString());
                        if (!iruConfig) continue;
                        this.notConnectedRemoteRdiPortRefsOnIruRdiPorts = 0;
                        this.notConnectedRdDeviceGroups = 0;
                        List iruRdiPortList = new ArrayList();
                        ArrayList<String> transceiverLdnList = new ArrayList<String>();
                        ArrayList<String> transceiverFroIdList = new ArrayList<String>();
                        String multicastAntennaBranch1Ldn = "";
                        String multicastAntennaBranch2Ldn = "";
                        String multicastAntennaBranch1froId = "-1";
                        String multicastAntennaBranch2froId = "-1";
                        this.auxPlugInUnitTableData = tableHandler.getTableData("AuxPlugInUnit");
                        this.deviceGroupTableData = tableHandler.getTableData("DeviceGroup");
                        this.rfPortTableData = tableHandler.getTableData("RfPort");
                        this.rfBranchTableData = tableHandler.getTableData("RfBranch");
                        this.auPortTableData = tableHandler.getTableData("AuPort");
                        this.antennaSubunitTableData = tableHandler.getTableData("AntennaSubunit");
                        this.antennaUnitTableData = tableHandler.getTableData("AntennaUnit");
                        this.rdiPortTableData = tableHandler.getTableData("RdiPort");
                        this.sectorEquipmentFunctionTableData = tableHandler.getTableData("SectorEquipmentFunction");
                        this.transceiverTableData = tableHandler.getTableData("Transceiver");
                        this.multicastAntennaBranchTableData = tableHandler.getTableData("MulticastAntennaBranch");
                        this.antennaSubunitLdns = this.antennaSubunitTableData.getAttributeValues("ldn");
                        this.antennaUnitLdns = this.antennaUnitTableData.getAttributeValues("ldn");
                        this.rdiPortLdns = this.rdiPortTableData.getAttributeValues("ldn");
                        this.rfPortLdns = this.rfPortTableData.getAttributeValues("ldn");
                        this.rfBranchLdns = this.rfBranchTableData.getAttributeValues("ldn");
                        this.auPortLdns = this.auPortTableData.getAttributeValues("ldn");
                        this.rdiPortRefs = this.rdiPortTableData.getAttributeValues("remoteRdiPortRef");
                        this.rfBranchAuPortRefs = this.rfBranchTableData.getAttributeValues("auPortRef");
                        this.rfBranchRfPortRefs = this.rfBranchTableData.getAttributeValues("rfPortRef");
                        if (!this.fetchAndCheckMulticastAntennaBranchCableWalkMos(this.auxPlugInUnitLdns[i].toString())) continue;
                        String multicastAntBranchAandBStr = "<array name=\"rfBranchRef\">\n";
                        iruRdiPortList = this.fetchIruRdiPorts(this.auxPlugInUnitLdns[i].toString());
                        for (int j = 0; j < iruRdiPortList.size(); ++j) {
                            if (!this.fetchAndCheckTransceiverCableWalkMos((String)iruRdiPortList.get(j))) continue;
                            String transceiverLdn = this.rdDeviceGroupLdn + "," + "Transceiver" + "=1";
                            transceiverLdnList.add(transceiverLdn);
                            transceiverFroIdList.add(Integer.toString(this.transceiverFroId));
                            this.createNewTransceiver(this.rdDeviceGroupLdn, Integer.toString(this.transceiverFroId), context);
                            this.transceiverFirstInstance = false;
                            ++this.transceiverFroId;
                        }
                        if (iruRdiPortList.size() == 0) {
                            logger.traceGeneral(THIS_CLASS, "No AUE1 action will be be performed for the following IRU, since NO IRU RdiPorts at all are connected to it: " + this.auxPlugInUnitLdns[i].toString());
                            continue;
                        }
                        if (iruRdiPortList.size() == this.notConnectedRemoteRdiPortRefsOnIruRdiPorts + this.notConnectedRdDeviceGroups) {
                            logger.traceGeneral(THIS_CLASS, "Total notConnectedRemoteRdiPortRefsOnIruRdiPorts: " + this.notConnectedRemoteRdiPortRefsOnIruRdiPorts + " | Total notConnectedRdDeviceGroups: " + this.notConnectedRdDeviceGroups + " | Total iruRdiPorts: " + iruRdiPortList.size());
                            logger.traceGeneral(THIS_CLASS, "No AUE1 action will be be performed for the following IRU, since NO RDs (no iruRemoteRdiPortRefs + no RdDevGrpLdns) at all are connected to it: " + this.auxPlugInUnitLdns[i].toString());
                            continue;
                        }
                        this.rfPortTableData.deleteRowData(this.fetchRowIndex(this.rfPortALdn, this.rfPortLdns));
                        this.auPortTableData.deleteRowData(this.fetchRowIndex(this.auPort1Ldn, this.auPortLdns));
                        this.rfBranchTableData.deleteRowData(this.fetchRowIndex(this.rfBranch1Ldn, this.rfBranchLdns));
                        this.rfPortLdns = this.rfPortTableData.getAttributeValues("ldn");
                        this.auPortLdns = this.auPortTableData.getAttributeValues("ldn");
                        this.rfBranchLdns = this.rfBranchTableData.getAttributeValues("ldn");
                        this.antennaSubunitLdns = this.antennaSubunitTableData.getAttributeValues("ldn");
                        this.antennaUnitLdns = this.antennaUnitTableData.getAttributeValues("ldn");
                        this.rfPortTableData.deleteRowData(this.fetchRowIndex(this.rfPortBLdn, this.rfPortLdns));
                        this.auPortTableData.deleteRowData(this.fetchRowIndex(this.auPort2Ldn, this.auPortLdns));
                        this.rfBranchTableData.deleteRowData(this.fetchRowIndex(this.rfBranch2Ldn, this.rfBranchLdns));
                        if (!this.checkExtraChildren(this.antennaSubunitLdn, "AuPort")) {
                            this.antennaSubunitTableData.deleteRowData(this.fetchRowIndex(this.antennaSubunitLdn, this.antennaSubunitLdns));
                            if (!this.checkExtraChildren(this.antennaUnitLdn, "AntennaSubunit")) {
                                this.antennaUnitTableData.deleteRowData(this.fetchRowIndex(this.antennaUnitLdn, this.antennaUnitLdns));
                            } else {
                                logger.traceGeneral(THIS_CLASS, "Extra (unwanted) childMOs found for specified AntennaUnit, will therefore NOT delete AntennaUnit.");
                            }
                        } else {
                            logger.traceGeneral(THIS_CLASS, "Extra (unwanted) childMOs found for specified AntennaSubunit,  will therefore NOT delete AntennaSubunit nor its parent AntennaUnit.");
                        }
                        this.rfPortLdns = this.rfPortTableData.getAttributeValues("ldn");
                        this.auPortLdns = this.auPortTableData.getAttributeValues("ldn");
                        this.rfBranchLdns = this.rfBranchTableData.getAttributeValues("ldn");
                        this.antennaSubunitLdns = this.antennaSubunitTableData.getAttributeValues("ldn");
                        this.antennaUnitLdns = this.antennaUnitTableData.getAttributeValues("ldn");
                        int multicastAntBranchId = 1;
                        if (!multicastAntennaBranchCreated) {
                            this.createNewMulticastAntBranch(this.antennaUnitGroupLdn, transceiverLdnList, transceiverFroIdList, Integer.toString(multicastAntBranchId), Integer.toString(this.multicastAntBranchFroId), context);
                            multicastAntennaBranch1Ldn = this.antennaUnitGroupLdn + "," + "MulticastAntennaBranch" + "=" + Integer.toString(multicastAntBranchId);
                            multicastAntennaBranch1froId = Integer.toString(this.multicastAntBranchFroId);
                            this.multicastAntBranchFirstInstance = false;
                            ++this.multicastAntBranchFroId;
                            this.createNewMulticastAntBranch(this.antennaUnitGroupLdn, transceiverLdnList, transceiverFroIdList, Integer.toString(++multicastAntBranchId), Integer.toString(this.multicastAntBranchFroId), context);
                            multicastAntennaBranch2Ldn = this.antennaUnitGroupLdn + "," + "MulticastAntennaBranch" + "=" + Integer.toString(multicastAntBranchId);
                            multicastAntennaBranch2froId = Integer.toString(this.multicastAntBranchFroId);
                            ++this.multicastAntBranchFroId;
                        }
                        transceiverLdnList = new ArrayList();
                        transceiverFroIdList = new ArrayList();
                        multicastAntennaBranchCreated = true;
                        multicastAntBranchAandBStr = multicastAntBranchAandBStr + this.createMoRef(multicastAntennaBranch1Ldn, Integer.toString(0x101000D), multicastAntennaBranch1froId);
                        multicastAntBranchAandBStr = multicastAntBranchAandBStr + this.createMoRef(multicastAntennaBranch2Ldn, Integer.toString(0x101000D), multicastAntennaBranch2froId);
                        multicastAntBranchAandBStr = "\n" + multicastAntBranchAandBStr + "</array>";
                        this.replaceBranchRefAandBWithMulticastAntBr(this.rfBranch1Ldn, this.rfBranch2Ldn, multicastAntBranchAandBStr);
                        irus = irus + this.auxPlugInUnitLdns[i].toString() + "\n";
                    }
                    tableHandler.storeInAuePersistency("", "irusMoToBeCompleted", irus);
                    logger.traceGeneral(THIS_CLASS, "irus variable saved in persistent table (to be used in AUE2): " + irus.replace('\n', '|'));
                    logger.traceGeneral(THIS_CLASS, "Length of the irus variable: " + irus.length());
                }
            }
        }
        catch (TableDataException e) {
            throw new CrbsAueException("Failed to read/write TableData", (Throwable)e);
        }
        logger.traceReturn(THIS_CLASS, "convert() executed");
    }

    private boolean checkExtraChildren(String parentLdn, String childType) throws CrbsAueException, TableDataException {
        logger.traceEnter(THIS_CLASS, "checkExtraChildren() entered");
        String parentLdnPrefix = parentLdn + ",";
        TableData childTableData = tableHandler.getTableData(childType);
        Object[] childLdns = childTableData.getAttributeValues("ldn");
        for (int i = 0; i < childLdns.length; ++i) {
            if (childLdns[i].toString().compareTo("") == 0) {
                logger.traceGeneral(THIS_CLASS, "Empty child LDN found among existing child LDNs of childType: " + childType);
                continue;
            }
            if (!childLdns[i].toString().startsWith(parentLdnPrefix)) continue;
            logger.traceReturn(THIS_CLASS, "checkExtraChildren() found childMOs. checkExtraChildren() returned.");
            return true;
        }
        logger.traceReturn(THIS_CLASS, "checkExtraChildren() found NO childMOs. checkExtraChildren() returned.");
        return false;
    }

    private String fetchParentLdn(String childLdn, String parentType) throws TableDataException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "fetchParentLdn() entered");
        String confirmedParentLdn = "";
        String constructedParentLdn = "";
        TableData parentTableData = tableHandler.getTableData(parentType);
        Object[] parentLdns = parentTableData.getAttributeValues("ldn");
        if (childLdn.compareTo("") == 0) {
            logger.traceGeneral(THIS_CLASS, "Empty childLdn specified, thus unable to find its parent of type: " + parentType);
        } else {
            for (int i = 0; i < parentLdns.length; ++i) {
                if (parentLdns[i].toString().compareTo("") == 0) {
                    logger.traceGeneral(THIS_CLASS, "Empty parent (" + parentType + ") LDN found among existing parent (" + parentType + ") LDNs!");
                    continue;
                }
                constructedParentLdn = this.getParentLdn(childLdn);
                if (constructedParentLdn.compareTo(parentLdns[i].toString()) != 0) continue;
                confirmedParentLdn = parentLdns[i].toString();
                break;
            }
        }
        logger.traceReturn(THIS_CLASS, "fetchParentLdn() executed");
        return confirmedParentLdn;
    }

    private boolean fetchAndCheckTransceiverCableWalkMos(String iruRdiPortLdn) throws TableDataException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "fetchAndCheckTransceiverCableWalkMos() entered");
        logger.traceGeneral(THIS_CLASS, "Fetching and checking relevant cablewalk MOs for IRU RdiPort: " + iruRdiPortLdn);
        this.iruRdiPortRemoteRdiPortRefLdn = "";
        this.rdAuxPlugInUnitLdn = "";
        this.rdDeviceGroupLdn = "";
        boolean result = true;
        this.iruRdiPortRemoteRdiPortRefLdn = this.fetchRemoteRdiPortRefOnIruRdiPort(iruRdiPortLdn);
        if (this.iruRdiPortRemoteRdiPortRefLdn.compareTo("") == 0) {
            logger.traceGeneral(THIS_CLASS, "Empty iruRdiPortRemoteRdiPortRefLdn for current iruRdiPort. Continuing to check rest of iruRdiPorts.");
            logger.traceGeneral(THIS_CLASS, "AUE action is therefore skipped ONLY for this iruRdiPort: " + iruRdiPortLdn);
            ++this.notConnectedRemoteRdiPortRefsOnIruRdiPorts;
            result = false;
        } else {
            this.rdAuxPlugInUnitLdn = this.fetchParentLdn(this.iruRdiPortRemoteRdiPortRefLdn, "AuxPlugInUnit");
            this.rdDeviceGroupLdn = this.fetchChildLdn(this.rdAuxPlugInUnitLdn, "DeviceGroup", "rd");
            if (this.rdDeviceGroupLdn.compareTo("") == 0) {
                logger.traceGeneral(THIS_CLASS, "Empty rdDeviceGroupLdn for current iruRdiPortLdn. Continuing to check rest of iruRdiPorts.");
                logger.traceGeneral(THIS_CLASS, "AUE action is therefore skipped ONLY for this iruRdiPort: " + iruRdiPortLdn);
                ++this.notConnectedRdDeviceGroups;
                result = false;
            }
        }
        logger.traceReturn(THIS_CLASS, "fetchAndCheckMulticastAntennaBranchCableWalkMos() executed");
        return result;
    }

    private boolean fetchAndCheckMulticastAntennaBranchCableWalkMos(String iruAuxPlugInUnitLdn) throws TableDataException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "fetchAndCheckMulticastAntennaBranchCableWalkMos() entered");
        logger.traceGeneral(THIS_CLASS, "Fetching and checking relevant cablewalk MOs for IRU: " + iruAuxPlugInUnitLdn);
        this.iruDeviceGroupLdn = "";
        this.rfPortALdn = "";
        this.rfPortBLdn = "";
        this.rfBranch1Ldn = "";
        this.rfBranch2Ldn = "";
        this.auPort1Ldn = "";
        this.auPort2Ldn = "";
        this.antennaSubunitLdn = "";
        this.antennaUnitLdn = "";
        this.antennaUnitGroupLdn = "";
        int sectorEquipmentFunctionIndexForRfBranch1 = -1;
        int sectorEquipmentFunctionIndexForRfBranch2 = -1;
        boolean result = true;
        this.iruDeviceGroupLdn = this.fetchChildLdn(iruAuxPlugInUnitLdn, "DeviceGroup", "ru");
        if (this.iruDeviceGroupLdn.compareTo("") == 0) {
            logger.traceGeneral(THIS_CLASS, "Empty iruDeviceGroupLdn. AUE action will not be performed for IRU: " + iruAuxPlugInUnitLdn);
            result = false;
        } else {
            this.rfPortALdn = this.fetchRfPort(this.iruDeviceGroupLdn, true);
            this.rfPortBLdn = this.fetchRfPort(this.iruDeviceGroupLdn, false);
            if (this.rfPortALdn.compareTo("") == 0 || this.rfPortBLdn.compareTo("") == 0) {
                logger.traceGeneral(THIS_CLASS, "Empty rfPortLdn (for at least 1 RfPort). AUE action will not be performed for IRU: " + iruAuxPlugInUnitLdn);
                result = false;
            } else {
                this.rfBranch1Ldn = this.fetchRfBranch(this.rfPortALdn);
                this.rfBranch2Ldn = this.fetchRfBranch(this.rfPortBLdn);
                if (this.rfBranch1Ldn.compareTo("") == 0 || this.rfBranch2Ldn.compareTo("") == 0) {
                    logger.traceGeneral(THIS_CLASS, "Empty rfBranchLdn (for at least 1 RfBranch). AUE action will not be performed for IRU: " + iruAuxPlugInUnitLdn);
                    result = false;
                }
                sectorEquipmentFunctionIndexForRfBranch1 = this.fetchSecEqFunctionIndex(this.rfBranch1Ldn);
                sectorEquipmentFunctionIndexForRfBranch2 = this.fetchSecEqFunctionIndex(this.rfBranch2Ldn);
                if (sectorEquipmentFunctionIndexForRfBranch1 == -1 && sectorEquipmentFunctionIndexForRfBranch2 == -1) {
                    logger.traceGeneral(THIS_CLASS, "Both specified rfBranchLdns cannot be found as SectorEquipmentFunction.RfBranchRefs. AUE action will not be performed for IRU: " + iruAuxPlugInUnitLdn);
                    result = false;
                } else {
                    this.auPort1Ldn = this.fetchAuPortRefFromRfBranch(this.rfBranch1Ldn);
                    this.auPort2Ldn = this.fetchAuPortRefFromRfBranch(this.rfBranch2Ldn);
                    if (this.auPort1Ldn.compareTo("") == 0 || this.auPort2Ldn.compareTo("") == 0) {
                        logger.traceGeneral(THIS_CLASS, "Empty auPortLdn (for at least 1 AuPort). AUE action will not be performed for IRU: " + iruAuxPlugInUnitLdn);
                        result = false;
                    } else {
                        this.antennaSubunitLdn = this.fetchParentLdn(this.auPort1Ldn, "AntennaSubunit");
                        if (this.antennaSubunitLdn.compareTo("") == 0) {
                            logger.traceGeneral(THIS_CLASS, "Empty antennaSubunitLdn. AUE action will not be performed for IRU: " + iruAuxPlugInUnitLdn);
                            result = false;
                        } else {
                            this.antennaUnitLdn = this.fetchParentLdn(this.antennaSubunitLdn, "AntennaUnit");
                            if (this.antennaUnitLdn.compareTo("") == 0) {
                                logger.traceGeneral(THIS_CLASS, "Empty antennaUnitLdn. AUE action will not be performed for IRU: " + iruAuxPlugInUnitLdn);
                                result = false;
                            } else {
                                this.antennaUnitGroupLdn = this.fetchParentLdn(this.antennaUnitLdn, "AntennaUnitGroup");
                                if (this.antennaUnitGroupLdn.compareTo("") == 0) {
                                    logger.traceGeneral(THIS_CLASS, "Empty antennaUnitGroupLdn. AUE action will not be performed for IRU: " + iruAuxPlugInUnitLdn);
                                    result = false;
                                }
                            }
                        }
                    }
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "fetchAndCheckMulticastAntennaBranchCableWalkMos() executed");
        return result;
    }

    private void createNewTransceiver(String rdDeviceGroupLdn, String froIdStr, AueContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createNewTransceiver() entered");
        String identity = "1";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("name", "Transceiver");
        paramMap.put("frotype", Integer.toString(0x101000C));
        paramMap.put("rdnValue", identity);
        paramMap.put("parentldn", rdDeviceGroupLdn);
        paramMap.put("froid", froIdStr);
        paramMap.put("requestedRelativeOutputPower", Integer.toString(100));
        if (!this.transceiverFirstInstance) {
            StringBuffer childAttributes = new StringBuffer("<attributes>");
            childAttributes.append("<attr name=\"requestedRelativeOutputPower\" type=\"S32\" value=\"" + Integer.toString(100) + "\" />");
            childAttributes.append("</attributes>");
            paramMap.put("childAttributes", childAttributes.toString());
        }
        CreateOneInstanceAction createOneInstanceAction = new CreateOneInstanceAction();
        createOneInstanceAction.setMoActionArgs(paramMap);
        createOneInstanceAction.convert(context);
        if (this.transceiverFirstInstance) {
            paramMap.put("Mo", "Transceiver");
            paramMap.put("name", "requestedRelativeOutputPower");
            paramMap.put("type", "S32");
            paramMap.put("defaultValue", Integer.toString(100));
            AddAttributeAction addAttributeAction = new AddAttributeAction();
            addAttributeAction.setMoActionArgs(paramMap);
            addAttributeAction.convert(context);
            paramMap.clear();
        }
        logger.traceReturn(THIS_CLASS, "createNewTransceiver() executed");
    }

    private void createNewMulticastAntBranch(String antennaUnitGroupLdn, ArrayList transceivers, ArrayList transceiverFroIdList, String identity, String froIdStr, AueContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createNewMulticastAntBranch() entered");
        String transceiverRef = "";
        String arrayTransceiverRef = "";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (int i = 0; i < transceivers.size(); ++i) {
            String transRef = this.createMoRef(transceivers.get(i).toString(), Integer.toString(0x101000C), transceiverFroIdList.get(i).toString());
            transceiverRef = transceiverRef + "\n" + transRef;
        }
        arrayTransceiverRef = "<array name=\"transceiverRef\">" + transceiverRef + "\n</array>";
        paramMap.put("name", "MulticastAntennaBranch");
        paramMap.put("frotype", Integer.toString(0x101000D));
        paramMap.put("rdnValue", identity);
        paramMap.put("parentldn", antennaUnitGroupLdn);
        paramMap.put("froid", froIdStr);
        paramMap.put("transceiverRef", arrayTransceiverRef);
        if (!this.multicastAntBranchFirstInstance) {
            logger.traceDebug(THIS_CLASS, "createOneInstance() addMoTypeSpecificAttributesAsChildAttributes");
            StringBuffer childAttributes = new StringBuffer("<attributes>");
            childAttributes.append("<attr name=\"transceiverRef\" type=\"array\" value=\"" + arrayTransceiverRef + "\" />");
            childAttributes.append("</attributes>");
            paramMap.put("childAttributes", childAttributes.toString());
        }
        CreateOneInstanceAction createOneInstanceAction = new CreateOneInstanceAction();
        createOneInstanceAction.setMoActionArgs(paramMap);
        createOneInstanceAction.convert(context);
        if (this.multicastAntBranchFirstInstance) {
            logger.traceDebug(THIS_CLASS, "createOneInstance() addMoTypeSpecificAttributes");
            paramMap.put("Mo", "MulticastAntennaBranch");
            paramMap.put("name", "transceiverRef");
            paramMap.put("type", "array");
            paramMap.put("defaultValue", arrayTransceiverRef);
            AddAttributeAction addAttributeAction = new AddAttributeAction();
            addAttributeAction.setMoActionArgs(paramMap);
            addAttributeAction.convert(context);
            paramMap.clear();
        }
        logger.traceReturn(THIS_CLASS, "createNewMulticastAntBranch() executed");
    }

    private String fetchLdnFromRef(String refXmlStr) {
        logger.traceEnter(THIS_CLASS, "fetchLdnFromRef() entered");
        String ldnStr = "";
        int rfBranchRefIndex = 0;
        if (refXmlStr.compareTo("") != 0 || refXmlStr != null) {
            XmlArrayHelper xmlHelper1 = new XmlArrayHelper(refXmlStr);
            List rfBranchAuPortList = xmlHelper1.getValueTypeList();
            if (rfBranchAuPortList.isEmpty()) {
                logger.traceGeneral(THIS_CLASS, "String parameter refXmlStr does not have any LDN value.");
                logger.traceReturn(THIS_CLASS, "fetchLdnFromRef() returned");
                return ldnStr;
            }
            Map map1 = (Map)rfBranchAuPortList.get(rfBranchRefIndex);
            Iterator iterator1 = map1.keySet().iterator();
            while (iterator1.hasNext()) {
                Object type = iterator1.next();
                Object value = map1.get(type);
                ldnStr = value.toString();
            }
        }
        logger.traceReturn(THIS_CLASS, "fetchLdnFromRef() returned");
        return ldnStr;
    }

    private int fetchSecEqFunctionIndex(String rfBranchLdn) throws TableDataException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "fetchSecEqFunctionIndex() entered");
        int index = -1;
        this.sectorEquipmentFunctionRfBranchRefs = this.sectorEquipmentFunctionTableData.getAttributeValues("rfBranchRef");
        if (this.sectorEquipmentFunctionRfBranchRefs != null && this.sectorEquipmentFunctionRfBranchRefs.length > 0) {
            block0: for (int k = 0; k < this.sectorEquipmentFunctionRfBranchRefs.length; ++k) {
                List moRefList = MoRefArrayParser.parseMoRefArray(this.sectorEquipmentFunctionRfBranchRefs[k].toString()).getMoRefList();
                Iterator itMoRef = moRefList.iterator();
                while (itMoRef.hasNext()) {
                    MoRef moRef = (MoRef)itMoRef.next();
                    if (moRef.ldn.compareTo(rfBranchLdn) != 0) continue;
                    index = k;
                    continue block0;
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "fetchSecEqFunctionIndex() returned");
        return index;
    }

    private void replaceBranchRefAandBWithMulticastAntBr(String rfBranchALdn, String rfBranchBLdn, String multicatAntBranchRefs) throws TableDataException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "replaceBranchRefAandBWithMulticastAntBr() entered");
        Object[] curRfBranchRefAttributeValues = this.sectorEquipmentFunctionTableData.getAttributeValues("rfBranchRef");
        if (curRfBranchRefAttributeValues != null) {
            int index = this.fetchSecEqFunctionIndex(rfBranchALdn);
            if (index == -1) {
                logger.traceGeneral(THIS_CLASS, "RfBranch=1 is missing in sectorEquipmentFunction RfBranchRef attribute. We have to check if RfBranchRef RfBranch=2 exists");
                index = this.fetchSecEqFunctionIndex(rfBranchBLdn);
            }
            this.sectorEquipmentFunctionTableData.setAttributeValue(index, "rfBranchRef", (Object)multicatAntBranchRefs);
        }
        logger.traceReturn(THIS_CLASS, "replaceBranchRefAandBWithMulticastAntBr() returned");
    }

    private boolean checkIfThisIsAnIRUAuxPiu(String auxPlugInUnitLdn) throws TableDataException {
        logger.traceEnter(THIS_CLASS, "checkIfThisIsAnIRUAuxPiu() entered");
        boolean iruAuxPluInUnit = false;
        int prodNameIndex = 1;
        this.auxPiuProductData = this.auxPlugInUnitTableData.getAttributeValues("productData");
        block0: for (int i = 0; i < this.auxPlugInUnitLdns.length; ++i) {
            if (this.auxPlugInUnitLdns[i].toString().compareTo(auxPlugInUnitLdn) != 0) continue;
            String auxPiuProdName = "";
            String auxPiuProdData = this.auxPiuProductData[i].toString();
            XmlArrayHelper xmlHelper = new XmlArrayHelper(auxPiuProdData);
            List auxPiuProdDataList = xmlHelper.getValueTypeList();
            Map map = (Map)auxPiuProdDataList.get(prodNameIndex);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object type = iterator.next();
                Object value = map.get(type);
                String val = value.toString();
                if (val.compareTo("") == 0) {
                    logger.traceGeneral(THIS_CLASS, "AUE1: Found empty productName when searching for IRU productName. Now trying to find IRU in RDN instead.");
                    String identity = LdnUtil.getRdnValue((String)this.auxPlugInUnitLdns[i].toString());
                    String id = "";
                    if (identity.length() > 1) {
                        id = identity.substring(0, 3);
                    }
                    logger.traceGeneral(THIS_CLASS, "AUE1: Starting to check if this AuxPlugInUnit is an IRU (by checking on RDN). RDN: " + identity);
                    if (id.compareTo(AUX_PIU_IRU_PROD_NAME) == 0) {
                        logger.traceGeneral(THIS_CLASS, "AUE1: Found correct IRU RDN: " + id);
                        iruAuxPluInUnit = true;
                        i = this.auxPlugInUnitLdns.length;
                        continue block0;
                    }
                    logger.traceAbnormal(THIS_CLASS, "AUE1: Double unknown: Empty productName and no IRU RDN-name found.");
                    continue block0;
                }
                logger.traceGeneral(THIS_CLASS, "AUE1: Starting to check if this AuxPlugInUnit is an IRU (checking on productName). productName: " + val);
                auxPiuProdName = val.substring(0, 3);
                if (auxPiuProdName.compareTo(AUX_PIU_IRU_PROD_NAME) != 0) continue;
                logger.traceGeneral(THIS_CLASS, "AUE1: Found correct IRU productName: " + auxPiuProdName);
                iruAuxPluInUnit = true;
                i = this.auxPlugInUnitLdns.length;
                continue block0;
            }
        }
        logger.traceReturn(THIS_CLASS, "checkIfThisIsAnIRUAuxPiu() executed");
        return iruAuxPluInUnit;
    }

    private String fetchRfBranch(String rfPortLdn) {
        logger.traceEnter(THIS_CLASS, "fetchRfBranch() entered");
        String rfBranchLdn = "";
        for (int i = 0; i < this.rfBranchRfPortRefs.length; ++i) {
            if (rfPortLdn.compareTo(this.fetchLdnFromRef(this.rfBranchRfPortRefs[i].toString())) != 0) continue;
            rfBranchLdn = this.rfBranchLdns[i].toString();
            break;
        }
        logger.traceReturn(THIS_CLASS, "fetchRfBranch() executed");
        return rfBranchLdn;
    }

    private String fetchAuPortRefFromRfBranch(String rfBranchLdn) {
        logger.traceEnter(THIS_CLASS, "fetchAuPortRefFromRfBranch() entered");
        String auPorLdn = "";
        for (int i = 0; i < this.rfBranchLdns.length; ++i) {
            if (rfBranchLdn.compareTo(this.rfBranchLdns[i].toString()) != 0) continue;
            auPorLdn = this.fetchLdnFromRef(this.rfBranchAuPortRefs[i].toString());
            break;
        }
        logger.traceReturn(THIS_CLASS, "fetchAuPortRefFromRfBranch() executed");
        return auPorLdn;
    }

    private String fetchRemoteRdiPortRefOnIruRdiPort(String iruRdiPortLdn) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "fetchRemoteRdiPortRefOnIruRdiPort() entered");
        String rdRdiPortLdn = "";
        for (int i = 0; i < this.rdiPortLdns.length; ++i) {
            if (iruRdiPortLdn.compareTo(this.rdiPortLdns[i].toString()) != 0) continue;
            MoRef iruRdiPortRef = MoRefParser.parseMoRef(this.rdiPortRefs[i].toString());
            rdRdiPortLdn = iruRdiPortRef.ldn;
            break;
        }
        logger.traceReturn(THIS_CLASS, "fetchRemoteRdiPortRefOnIruRdiPort() executed");
        return rdRdiPortLdn;
    }

    private String fetchChildLdn(String parentLdn, String childType, String childSubString) throws CrbsAueException, TableDataException {
        logger.traceEnter(THIS_CLASS, "fetchChildLdn() entered");
        String confirmedChildLdn = "";
        String constructedChildLdn = parentLdn + "," + childType + "=" + childSubString;
        TableData childTableData = tableHandler.getTableData(childType);
        Object[] childLdns = childTableData.getAttributeValues("ldn");
        for (int i = 0; i < childLdns.length; ++i) {
            if (childLdns[i].toString().compareTo("") == 0) {
                logger.traceGeneral(THIS_CLASS, "Empty child LDN found among existing child LDNs of childType: " + childType);
                continue;
            }
            if (childLdns[i].toString().compareTo(constructedChildLdn) != 0) continue;
            confirmedChildLdn = constructedChildLdn;
            break;
        }
        logger.traceReturn(THIS_CLASS, "fetchChildLdn() executed");
        return confirmedChildLdn;
    }

    private String fetchRfPort(String devGroupLdn, boolean firstRfPortInstance) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "fetchRfPort() entered");
        String rfPortString = "";
        boolean first = true;
        for (int i = 0; i < this.rfPortLdns.length; ++i) {
            if (this.rfPortLdns[i].toString().compareTo("") == 0) {
                logger.traceGeneral(THIS_CLASS, "Empty RfPort LDN found among existing RfPort LDNs.");
                continue;
            }
            if (first && this.getParentLdn(this.rfPortLdns[i].toString()).compareTo(devGroupLdn) == 0) {
                first = false;
                if (!firstRfPortInstance) continue;
                rfPortString = this.rfPortLdns[i].toString();
                break;
            }
            if (first || this.getParentLdn(this.rfPortLdns[i].toString()).compareTo(devGroupLdn) != 0) continue;
            first = true;
            if (firstRfPortInstance) continue;
            rfPortString = this.rfPortLdns[i].toString();
            break;
        }
        logger.traceReturn(THIS_CLASS, "fetchRfPort() executed");
        return rfPortString;
    }

    private List fetchIruRdiPorts(String auxPlugInUnitLdn) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "fetchIruRdiPorts() entered");
        ArrayList<String> resultList = new ArrayList<String>();
        for (int i = 0; i < this.rdiPortLdns.length; ++i) {
            String tmpAuxPiuLDN = this.getParentLdn(this.rdiPortLdns[i].toString());
            if (tmpAuxPiuLDN.compareTo(auxPlugInUnitLdn) != 0) continue;
            resultList.add(this.rdiPortLdns[i].toString());
        }
        logger.traceReturn(THIS_CLASS, "fetchIruRdiPorts() executed");
        return resultList;
    }

    private int fetchRowIndex(String ldn, Object[] ldns) {
        logger.traceEnter(THIS_CLASS, "fetchRowIndex() entered");
        int index = -1;
        if (ldns.length > 0) {
            for (int i = 0; i < ldns.length; ++i) {
                if (ldns[i].toString().compareTo(ldn) != 0) continue;
                index = i;
                break;
            }
        }
        logger.traceReturn(THIS_CLASS, "fetchRowIndex() executed");
        return index;
    }

    public String createMoRef(String refLdn, String refFroType, String refFroId) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createMoRef() entered");
        String moRef = "<moref>\n<attr name=\"ldn\" type=\"STRING\" value=\"" + refLdn + "\"/>\n<attr name=\"froType\" type=\"S32\" value=\"" + refFroType + "\"/>\n<attr name=\"froId\" type=\"S32\" value=\"" + refFroId + "\"/>\n" + "</moref>";
        logger.traceReturn(THIS_CLASS, "createMoRef() executed");
        return moRef;
    }

    static {
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    }
}

