/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.omf.aue.step1.actions;

import se.ericsson.crbs.cat.omf.aue.step1.actions.AbstractCorrectInvalidParentRef;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;

public class CorrectInvalidCatMOParentRef
extends AbstractCorrectInvalidParentRef {
    private static final Class THIS_CLASS = CorrectInvalidCatMOParentRef.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    private String getParentFroId(String parentLdn, String parentFroType, TableData parentTableData) throws CrbsAueException, TableDataException {
        String froId = null;
        Object[] ldnTableColumnData = parentTableData.getAttributeValues("ldn");
        Object[] froIdColumnDatas = parentTableData.getAttributeValues("froid");
        for (int row = 0; row < ldnTableColumnData.length; ++row) {
            if (!ldnTableColumnData[row].toString().equalsIgnoreCase(parentLdn)) continue;
            froId = froIdColumnDatas[row].toString();
        }
        if (froId == null) {
            throw new CrbsAueException("The froId for parent MO " + parentFroType + " could not be found in the database");
        }
        return froId;
    }

    public String getCorrectedParentMoRef(String realParentLdn, String parentRefLdn, String parentRefFroId, String parentRefFroType) throws TableDataException, CrbsAueException {
        TableData parentTableData = this.tableHandler.getTableData(this.getFroTypeFromLdn(realParentLdn));
        String realParentFroType = parentTableData.getFroTypeId().toString();
        String realParentFroId = this.getParentFroId(realParentLdn, realParentFroType, parentTableData);
        if (!(parentRefFroId.equals(realParentFroId) && parentRefFroType.equals(realParentFroType) && parentRefLdn.equals(realParentLdn))) {
            logger.traceDebug(THIS_CLASS, "Found inconsistency during inspection of parentRef attribute for " + this.tableData.getTableName() + " expected froId = " + parentRefFroId + " and froType = " + parentRefFroType + " but found " + realParentFroId + " and " + realParentFroType);
            return this.getParentMoRef(realParentLdn, realParentFroId, realParentFroType);
        }
        return null;
    }
}

