/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.omf.aue.step1.actions;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.crbs.cat.omf.aue.step1.actions.AbstractCorrectInvalidParentRef;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.step1.MoRepositoryWrapper;
import se.ericsson.crbs.omf.aue.step1.MoRepositoryWrapperFactory;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;

public class CorrectInvalidPiuParentRef
extends AbstractCorrectInvalidParentRef {
    private static final Class THIS_CLASS = CorrectInvalidPiuParentRef.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String PLUG_IN_UNIT_MO_TYPE = "PlugInUnit";
    private static final String PLUG_IN_UNIT_FRO_ID_ATTR_NAME = "resourceId";

    public String getCorrectedParentMoRef(String realParentLdn, String parentRefLdn, String parentRefFroId, String parentRefFroType) throws TableDataException {
        String parentRef = null;
        if (LdnUtil.getMoType((String)realParentLdn).equals(PLUG_IN_UNIT_MO_TYPE)) {
            String realParentFroId = this.getPiuFroId(realParentLdn);
            if (realParentFroId == null) {
                logger.traceAbnormal(THIS_CLASS, "Could not read froId from " + realParentLdn + ", correction not possible");
                return null;
            }
            if (!parentRefFroId.equals(realParentFroId)) {
                logger.traceDebug(THIS_CLASS, "Found inconsistency during inspection of parentRef attribute for " + this.tableData.getTableName() + " expected froId = " + realParentFroId + " but found " + parentRefFroId);
                parentRef = this.getParentMoRef(realParentLdn, realParentFroId, parentRefFroType);
            } else {
                logger.traceDebug(THIS_CLASS, "parentRef is correct, no update needed");
            }
        } else {
            logger.traceDebug(THIS_CLASS, "parent is not a PlugInUnit MO, no correction needed");
        }
        return parentRef;
    }

    private String getPiuFroId(String ldn) {
        MoRepositoryWrapper moRepository = MoRepositoryWrapperFactory.getMoRepositoryWrapper();
        MoIterator moIt = moRepository.lookupType(PLUG_IN_UNIT_MO_TYPE);
        String froId = null;
        while (moIt.hasMoreElements()) {
            ManagedObject mo = moIt.nextMo();
            if (!mo.getLocalDistinguishedName().equals(ldn)) continue;
            try {
                Integer attribute = (Integer)mo.getAttribute(PLUG_IN_UNIT_FRO_ID_ATTR_NAME, null);
                froId = String.valueOf(attribute);
                break;
            }
            catch (MoAccessException e) {
                logger.traceError(THIS_CLASS, "Could not fetch attribute resourceId", (Throwable)e);
            }
        }
        return froId;
    }
}

