/*
 * Decompiled with CFR 0.152.
 */
package com.jtheory.jdring;

import com.jtheory.jdring.AlarmEntry;
import com.jtheory.jdring.AlarmListener;
import com.jtheory.jdring.AlarmWaiter;
import com.jtheory.jdring.PastDateException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class AlarmManager {
    protected AlarmWaiter waiter;
    protected SortedSet queue = new TreeSet();
    private boolean debug = false;

    private void debug(String string) {
        if (this.debug) {
            System.out.println("[" + Thread.currentThread().getName() + "] AlarmManager: " + string);
        }
    }

    public AlarmManager(boolean bl, String string) {
        this.waiter = new AlarmWaiter(this, bl, string);
    }

    public AlarmManager() {
        this(false, "AlarmManager");
    }

    public synchronized AlarmEntry addAlarm(String string, Date date, AlarmListener alarmListener) throws PastDateException {
        AlarmEntry alarmEntry = new AlarmEntry(string, date, alarmListener);
        this.addAlarm(alarmEntry);
        return alarmEntry;
    }

    public AlarmEntry addAlarm(Date date, AlarmListener alarmListener) throws PastDateException {
        return this.addAlarm(null, date, alarmListener);
    }

    public synchronized AlarmEntry addAlarm(String string, int n, boolean bl, AlarmListener alarmListener) throws PastDateException {
        AlarmEntry alarmEntry = new AlarmEntry(string, n, bl, alarmListener);
        this.addAlarm(alarmEntry);
        return alarmEntry;
    }

    public AlarmEntry addAlarm(int n, boolean bl, AlarmListener alarmListener) throws PastDateException {
        return this.addAlarm(null, n, bl, alarmListener);
    }

    public synchronized AlarmEntry addAlarm(String string, int n, int n2, int n3, int n4, int n5, int n6, AlarmListener alarmListener) throws PastDateException {
        AlarmEntry alarmEntry = new AlarmEntry(string, n, n2, n3, n4, n5, n6, alarmListener);
        this.addAlarm(alarmEntry);
        return alarmEntry;
    }

    public AlarmEntry addAlarm(int n, int n2, int n3, int n4, int n5, int n6, AlarmListener alarmListener) throws PastDateException {
        return this.addAlarm(n, n2, n3, n4, n5, n6, alarmListener);
    }

    public synchronized AlarmEntry addAlarm(String string, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int n, AlarmListener alarmListener) throws PastDateException {
        AlarmEntry alarmEntry = new AlarmEntry(string, nArray, nArray2, nArray3, nArray4, nArray5, n, alarmListener);
        this.addAlarm(alarmEntry);
        return alarmEntry;
    }

    public AlarmEntry addAlarm(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int n, AlarmListener alarmListener) throws PastDateException {
        return this.addAlarm(null, nArray, nArray2, nArray3, nArray4, nArray5, n, alarmListener);
    }

    public synchronized void addAlarm(AlarmEntry alarmEntry) throws PastDateException {
        this.debug("Add a new alarm entry : " + alarmEntry);
        this.queue.add(alarmEntry);
        if (this.queue.first().equals(alarmEntry)) {
            this.debug("This new alarm is the top one, update the waiter thread");
            this.waiter.update(alarmEntry.alarmTime);
        }
    }

    public synchronized boolean removeAlarm(AlarmEntry alarmEntry) {
        boolean bl = false;
        if (!this.queue.isEmpty()) {
            AlarmEntry alarmEntry2 = (AlarmEntry)this.queue.first();
            bl = this.queue.remove(alarmEntry);
            if (!this.queue.isEmpty() && alarmEntry.equals(alarmEntry2)) {
                this.waiter.update(((AlarmEntry)this.queue.first()).alarmTime);
            }
        }
        return bl;
    }

    public synchronized void removeAllAlarms() {
        this.queue.clear();
    }

    public synchronized void removeAllAlarmsAndStop() {
        this.waiter.stop();
        this.waiter = null;
        this.queue.clear();
    }

    public boolean isStopped() {
        return this.waiter == null;
    }

    public synchronized boolean containsAlarm(AlarmEntry alarmEntry) {
        return this.queue.contains(alarmEntry);
    }

    public synchronized List getAllAlarms() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.queue.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    protected synchronized void ringNextAlarm() {
        this.debug("ringing next alarm");
        if (this.queue.isEmpty()) {
            return;
        }
        AlarmEntry alarmEntry = (AlarmEntry)this.queue.first();
        this.queue.remove(alarmEntry);
        if (alarmEntry.isRingInNewThread()) {
            new Thread(new RunnableRinger(alarmEntry)).start();
        } else {
            try {
                alarmEntry.ringAlarm();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (alarmEntry.isRepeating) {
            alarmEntry.updateAlarmTime();
            this.queue.add(alarmEntry);
        }
        if (this.queue.isEmpty()) {
            this.debug("no more alarms to handle; queue is empty");
        } else {
            long l = ((AlarmEntry)this.queue.first()).alarmTime;
            if (l - System.currentTimeMillis() < 0L) {
                this.debug("next alarm is within 1 sec or already past - ring it without waiting");
                this.ringNextAlarm();
            } else {
                this.debug("updating the waiter for next alarm: " + this.queue.first());
                this.waiter.restart(l);
            }
        }
    }

    public void finalize() {
        if (this.waiter != null) {
            this.waiter.stop();
        }
    }

    private class RunnableRinger
    implements Runnable {
        AlarmEntry entry = null;

        RunnableRinger(AlarmEntry alarmEntry) {
            this.entry = alarmEntry;
        }

        public void run() {
            try {
                this.entry.ringAlarm();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

