/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.log;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.log.ObjectWriter;

class FileElement {
    static final boolean DEBUG = false;
    private static final byte LIVE_OBJECT = 0;
    private static final byte REMOVED_OBJECT = 1;
    private static final byte EMPTY_INDEX = 3;
    private static final long NEXT_OBJECT_NUMBER_POSITION = 0L;
    private static final long DATA_START = 4L;
    private static final int INDEX_ENTRY_LENGTH = 13;
    private IndexEntry idxEntry = new IndexEntry();
    private int nextObjNum;
    private RandomAccessFile file;

    int addObject(Object object) throws IOException {
        try {
            ObjectWriter objectWriter = new ObjectWriter(object);
            int n = objectWriter.getDataLength();
            int n2 = this.getNextObjectNumber();
            this.idxEntry.init(n2);
            this.idxEntry.setDataLength(n);
            if (!this.idxEntry.isRoom()) {
                return -1;
            }
            this.file.seek(this.idxEntry.getDataPosition());
            objectWriter.writeTo(this.file);
            this.idxEntry.writeToFile();
            this.incNextObjectNumber();
            this.idxEntry.reset();
            return n2;
        }
        catch (NotSerializableException notSerializableException) {
            throw new IOException(notSerializableException.toString());
        }
    }

    void deleteObject(int n) throws IOException {
        this.idxEntry.init(n);
        if (this.idxEntry.exists()) {
            this.idxEntry.delete();
            this.idxEntry.writeToFile();
        }
    }

    Object readObject(int n) throws IOException, ClassNotFoundException {
        this.idxEntry.init(n);
        if (this.idxEntry.isDeleted() || !this.idxEntry.exists()) {
            return null;
        }
        int n2 = this.idxEntry.getDataLength();
        this.file.seek(this.idxEntry.getDataPosition());
        byte[] byArray = new byte[n2];
        this.file.readFully(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    int getObjectCount() throws IOException {
        return this.getNextObjectNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (IOException iOException) {
            MessageLog.traceError(FileElement.class, "Could not close file element.", iOException);
        }
        finally {
            this.file = null;
        }
    }

    boolean isClosed() {
        return this.file == null;
    }

    protected int getNextObjectNumber() throws IOException {
        this.file.seek(0L);
        return this.file.readInt();
    }

    protected void incNextObjectNumber() throws IOException {
        int n = this.getNextObjectNumber();
        this.file.seek(0L);
        this.file.writeInt(++n);
    }

    public static FileElement create(File file, int n) throws IOException {
        file.delete();
        return new FileElement(file, n);
    }

    public static FileElement open(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("File + " + file.getName() + " does not exist.");
        }
        return new FileElement(file);
    }

    private FileElement(File file, int n) throws IOException {
        if (file.exists()) {
            throw new RuntimeException("FileElement.FileElement(): File " + file.getName() + " exists.");
        }
        this.file = new RandomAccessFile(file, "rw");
        this.file.write(new byte[n]);
        this.file.seek(0L);
        this.file.writeInt(0);
    }

    private FileElement(File file) throws IOException {
        if (!file.exists()) {
            throw new RuntimeException("FileElement.FileElement(): File " + file.getName() + " does not exists.");
        }
        this.file = new RandomAccessFile(file, "rw");
    }

    private class IndexEntry {
        private long indexPos;
        private long dataPos;
        private int dataLength;
        private int objNumCount;
        private int objNum;
        private byte status;

        IndexEntry() {
            this.reset();
        }

        void init(int n) throws IOException {
            this.objNum = n;
            this.objNumCount = FileElement.this.getNextObjectNumber();
            if (n < 0 || n > this.objNumCount) {
                this.reset();
                return;
            }
            this.indexPos = this.getIndexPosition(n);
            if (n == this.objNumCount) {
                this.dataLength = 0;
                this.status = 0;
                if (n == 0) {
                    this.dataPos = 4L;
                } else {
                    FileElement.this.file.seek(this.getIndexPosition(n - 1));
                    this.dataPos = FileElement.this.file.readLong() + (long)FileElement.this.file.readInt();
                }
            } else {
                FileElement.this.file.seek(this.indexPos);
                this.dataPos = FileElement.this.file.readLong();
                this.dataLength = FileElement.this.file.readInt();
                this.status = FileElement.this.file.readByte();
            }
        }

        void writeToFile() throws IOException {
            FileElement.this.file.seek(this.indexPos);
            FileElement.this.file.writeLong(this.dataPos);
            FileElement.this.file.writeInt(this.dataLength);
            FileElement.this.file.writeByte(this.status);
        }

        void setDataLength(int n) {
            this.dataLength = n;
        }

        long getDataPosition() {
            return this.dataPos;
        }

        int getDataLength() {
            return this.dataLength;
        }

        void delete() {
            this.status = 1;
        }

        boolean isDeleted() {
            return this.status == 1;
        }

        boolean isRoom() throws IOException {
            if (4L + (long)this.dataLength > FileElement.this.file.length() - 13L) {
                throw new IOException("Object too large (object size = " + this.dataLength + ", file length = " + FileElement.this.file.length() + ")");
            }
            return this.dataPos + (long)this.dataLength < this.indexPos;
        }

        boolean exists() {
            return this.objNum >= 0 && this.objNum < this.objNumCount;
        }

        private void reset() {
            this.objNum = -1;
            this.status = (byte)3;
        }

        private long getIndexPosition(int n) throws IOException {
            return FileElement.this.file.length() - (long)((n + 1) * 13);
        }
    }
}

