/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Vector;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.log.FileElement;
import se.ericsson.cello.support.log.FilesData;
import se.ericsson.cello.support.log.Filter;
import se.ericsson.cello.support.log.ObjectLog;

class FileElementDir
implements ObjectLog {
    private FilesData filesdata;
    private static final String FILES_DATA_FILENAME = "files.metadata";
    private static Hashtable logsCatalog = new Hashtable();
    private static final boolean DEBUG = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized long append(Object object) throws IOException {
        File file = this.filesdata.getCurrentFile();
        FileElement fileElement = this.openFileElement(file);
        try {
            int n = fileElement.addObject(object);
            int n2 = this.filesdata.getCurrentFileNum();
            if (n >= 0) {
                long l = FileElementDir.encodeId(n, n2);
                return l;
            }
        }
        finally {
            fileElement.close();
        }
        if (this.filesdata.isLast()) {
            if (!this.filesdata.isWrapper()) return -1L;
            this.filesdata.deleteOldestFile();
            if (!this.filesdata.addNewFile()) {
                throw new IOException("FileElementDir: Failed to add a new file.");
            }
        } else if (!this.filesdata.addNewFile()) {
            throw new IOException("FileElementDir: Failed to add a new file.");
        }
        this.store();
        return this.append(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean remove(long l) throws IOException {
        File file = this.filesdata.getFile(this.filesdata.getIndex(FileElementDir.decodeFileNum(l)));
        if (file == null || !file.exists()) {
            return false;
        }
        FileElement fileElement = null;
        try {
            fileElement = this.openFileElement(file);
            fileElement.deleteObject(FileElementDir.decodeObjNum(l));
        }
        finally {
            fileElement.close();
        }
        return true;
    }

    public synchronized Object fetch(long l) throws IOException {
        Object object = null;
        File file = null;
        FileElement fileElement = null;
        try {
            file = this.filesdata.getFile(this.filesdata.getIndex(FileElementDir.decodeFileNum(l)));
            if (file == null || !file.exists()) {
                Object var6_5 = null;
                return var6_5;
            }
            fileElement = this.openFileElement(file);
            object = fileElement.readObject(FileElementDir.decodeObjNum(l));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.toString());
        }
        finally {
            if (fileElement != null) {
                fileElement.close();
            }
        }
        return object;
    }

    public synchronized long[] search(Filter filter) throws IOException {
        Vector<Long> vector = new Vector<Long>();
        int n = 0;
        int n2 = 0;
        Object var5_5 = null;
        FileElement fileElement = null;
        File file = null;
        try {
            for (int i = 0; i < this.filesdata.getFileCount(); ++i) {
                file = this.filesdata.getFile(i);
                fileElement = this.openFileElement(file);
                for (n2 = 0; n2 < fileElement.getObjectCount(); ++n2) {
                    if (!filter.isSelected(fileElement.readObject(n2))) continue;
                    n = this.filesdata.getFileNum(i);
                    vector.addElement(new Long(FileElementDir.encodeId(n2, n)));
                }
                fileElement.close();
            }
            long[] lArray = new long[vector.size()];
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = (Long)vector.elementAt(i);
            }
            long[] lArray2 = lArray;
            return lArray2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.toString());
        }
        finally {
            fileElement.close();
        }
    }

    public synchronized void close() {
    }

    public synchronized void resize(int n) {
    }

    public synchronized int getSize() {
        return this.filesdata.getTotalSize();
    }

    public synchronized void delete() {
        this.filesdata.deleteAll();
        File file = new File(this.filesdata.getDirectory(), FILES_DATA_FILENAME);
        file.delete();
        logsCatalog.remove(this.filesdata.getDirectory());
    }

    public synchronized boolean isFull() {
        return this.filesdata.isLast();
    }

    protected FileElement openFileElement(File file) throws IOException {
        FileElement fileElement = null;
        fileElement = file.exists() ? FileElement.open(file) : FileElement.create(file, this.filesdata.getFileSize());
        return fileElement;
    }

    protected static long encodeId(int n, int n2) {
        long l = ((long)n2 << 32) + (long)n;
        return l;
    }

    protected static int decodeObjNum(long l) {
        int n = (int)l;
        return n;
    }

    protected static int decodeFileNum(long l) {
        int n = (int)(l >> 32);
        return n;
    }

    /*
     * Loose catch block
     */
    public void store() throws IOException {
        block8: {
            File file = new File(this.filesdata.getDirectory(), FILES_DATA_FILENAME);
            ObjectOutputStream objectOutputStream = null;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.filesdata);
            objectOutputStream.flush();
            Object var5_6 = null;
            try {
                objectOutputStream.close();
            }
            catch (Exception exception) {
                MessageLog.traceError(FileElementDir.class, "Could not close.", exception);
            }
            break block8;
            {
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Exception exception) {
                    throw new IOException("Could not store meta data object. (" + exception.getClass().getName() + ")");
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    objectOutputStream.close();
                }
                catch (Exception exception) {
                    MessageLog.traceError(FileElementDir.class, "Could not close.", exception);
                }
                throw throwable;
            }
        }
    }

    static FileElementDir create(File file, int n, int n2, boolean bl) throws IOException {
        Assert.cppAssert(file.isDirectory(), "Not a directory in FileElementDir.create()");
        File file2 = new File(file, FILES_DATA_FILENAME);
        file2.delete();
        FileElementDir fileElementDir = new FileElementDir(file, n, n2, bl);
        logsCatalog.put(file, fileElementDir);
        return fileElementDir;
    }

    /*
     * Loose catch block
     */
    static FileElementDir load(File file) throws IOException {
        Object object;
        FilesData filesData;
        block9: {
            Assert.cppAssert(file.isDirectory(), "Not a directory in FileElementDir.load()");
            if (logsCatalog.containsKey(file)) {
                return (FileElementDir)logsCatalog.get(file);
            }
            filesData = null;
            ObjectInputStream objectInputStream = null;
            File file2 = new File(file, FILES_DATA_FILENAME);
            if (!file2.exists()) {
                throw new IOException("FileElementDir.load(): Meta data does not exist.");
            }
            object = new FileInputStream(file2);
            objectInputStream = new ObjectInputStream((InputStream)object);
            filesData = (FilesData)objectInputStream.readObject();
            Object var6_6 = null;
            try {
                objectInputStream.close();
            }
            catch (Exception exception) {
                MessageLog.traceError(FileElementDir.class, "Could not close.", exception);
            }
            break block9;
            {
                catch (Exception exception) {
                    throw new IOException("Could not load meta data object. (" + exception.toString() + ")");
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    objectInputStream.close();
                }
                catch (Exception exception) {
                    MessageLog.traceError(FileElementDir.class, "Could not close.", exception);
                }
                throw throwable;
            }
        }
        object = new FileElementDir(filesData);
        logsCatalog.put(file, object);
        return object;
    }

    private FileElementDir(File file, int n, int n2, boolean bl) throws IOException {
        this.filesdata = new FilesData(file, n, n2, bl);
        this.store();
    }

    private FileElementDir(FilesData filesData) {
        this.filesdata = filesData;
    }
}

