/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.thread;

import java.util.Vector;

public class BlockingQueue {
    private Vector queue = new Vector();
    private int waitingThreads;
    private int size;

    public BlockingQueue() {
        this(Integer.MAX_VALUE);
    }

    public BlockingQueue(int n) {
        this.size = n;
    }

    public final synchronized boolean enqueue(Object object) {
        if (this.isFull()) {
            return false;
        }
        this.queue.addElement(object);
        this.notify();
        return true;
    }

    public synchronized Object dequeue() throws InterruptedException {
        if (this.isEmpty()) {
            ++this.waitingThreads;
            while (this.queue.size() <= 0) {
                this.wait();
            }
            --this.waitingThreads;
        }
        Object e = this.queue.firstElement();
        this.queue.removeElementAt(this.queue.indexOf(e));
        return e;
    }

    public final synchronized void clear() {
        this.queue.clear();
    }

    public final boolean isEmpty() {
        return this.queue.size() <= 0;
    }

    public final boolean isFull() {
        return this.queue.size() >= this.size;
    }

    public final int getNoOfWaitingThreads() {
        return this.waitingThreads;
    }
}

