/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import se.ericsson.crbs.common.FileHelper;
import se.ericsson.crbs.common.StringHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class ZipFileHelper
extends FileHelper {
    protected static final Class THIS_CLASS = class$se$ericsson$crbs$common$ZipFileHelper == null ? (class$se$ericsson$crbs$common$ZipFileHelper = ZipFileHelper.class$("se.ericsson.crbs.common.ZipFileHelper")) : class$se$ericsson$crbs$common$ZipFileHelper;
    protected static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    static /* synthetic */ Class class$se$ericsson$crbs$common$ZipFileHelper;

    public static void unzipFile(String fileToBeUnzipped, String targetDirectory) throws FileHelper.FileException {
        logger.traceEnter(THIS_CLASS, "unzipFile()");
        try {
            byte[] bytesIn = new byte[4096];
            FileHelper.createDirectoryTree(targetDirectory);
            ZipFile zipFile = new ZipFile(fileToBeUnzipped);
            Enumeration<? extends ZipEntry> zipEnum = zipFile.entries();
            while (zipEnum.hasMoreElements()) {
                ZipEntry item = zipEnum.nextElement();
                if (item.isDirectory()) {
                    File newDir = new File(targetDirectory, item.getName());
                    if (newDir.exists()) continue;
                    newDir.mkdirs();
                    continue;
                }
                String newFileStr = targetDirectory + File.separator + item.getName();
                InputStream inputStream = zipFile.getInputStream(item);
                File newFile = new File(newFileStr);
                if (!newFile.getParentFile().exists()) {
                    newFile.getParentFile().mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(newFile);
                int length = inputStream.read(bytesIn);
                while (length >= 0) {
                    fos.write(bytesIn, 0, length);
                    length = inputStream.read(bytesIn);
                }
                inputStream.close();
                fos.close();
            }
            zipFile.close();
        }
        catch (FileHelper.FileException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FileHelper.FileException("Could not unzip file " + StringHelper.doubleQuote(fileToBeUnzipped) + " to directory " + StringHelper.doubleQuote(targetDirectory), e);
        }
        logger.traceReturn(THIS_CLASS, "unzipFile()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

