/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.logging;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.OutSignal;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import se.ericsson.crbs.common.DateTimeHelper;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.FileLogger;
import se.ericsson.crbs.logging.LogFileWriter;
import se.ericsson.crbs.logging.TraceGroup;

public class FileLoggerImpl
implements AbstractLogger,
FileLogger {
    private static final String LOG_FILE_PATH_SYSTEM_PROP_NAME = "autointegration_logfilepath";
    private static final String DEFAULT_FILE_PATH = "/c/logfiles/autointegration/Autointegration_report.log";
    private static final String USER_HOME = "user.home";
    private static final String FILE_SEPARATOR = "file.separator";
    private LogFileWriter logFileWriter = null;
    private List packagesList;
    private static final String COLON_STRING = ":";
    private AbstractLogger logger;
    private static String pathfilename = null;

    public void connectLogFileWriter(LogFileWriter name) {
        this.logFileWriter = name;
    }

    public void stopLogListner() {
        if (this.logger != null) {
            this.logger.removeListeningLogger(this);
        }
    }

    public void addListeningLogger(AbstractLogger logger) {
        if (this.logger != null && logger != null) {
            this.logger.addListeningLogger(logger);
        }
    }

    public void removeListeningLogger(AbstractLogger logger) {
        if (this.logger != null && logger != null) {
            this.logger.removeListeningLogger(logger);
        }
    }

    public void info(Class clazz, String message) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("INFO :");
        stringbuffer.append(FileLoggerImpl.getClassAndTreadInfo(clazz)).append(' ');
        stringbuffer.append(message);
        this.writeToFile(clazz, stringbuffer.toString());
    }

    public void traceAbnormal(Class clazz, String message) {
        this.trace(TraceGroup.ABNORMAL, clazz, message);
    }

    public void traceDebug(Class clazz, String message) {
        this.trace(TraceGroup.DEBUG, clazz, message);
    }

    public void traceDebugStackTrace(Class clazz, Throwable throwable) {
        this.trace(TraceGroup.DEBUG, clazz, ExceptionHelper.convertToString(throwable));
    }

    public void traceEnter(Class clazz, String message) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("ENTER:");
        stringbuffer.append(FileLoggerImpl.getClassAndTreadInfo(clazz)).append(' ');
        stringbuffer.append(message);
        this.writeToFile(clazz, stringbuffer.toString());
    }

    public void traceError(Class clazz, String message) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("ERROR:");
        stringbuffer.append(FileLoggerImpl.getClassAndTreadInfo(clazz)).append(' ');
        stringbuffer.append(message);
        this.writeToFile(clazz, stringbuffer.toString());
    }

    public void traceError(Class clazz, String message, Throwable throwable) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("ERROR:");
        stringbuffer.append(FileLoggerImpl.getClassAndTreadInfo(clazz)).append(' ');
        stringbuffer.append(message).append(' ');
        stringbuffer.append(ExceptionHelper.convertToString(throwable));
        this.writeToFile(clazz, stringbuffer.toString());
    }

    public void traceGeneral(Class clazz, String message) {
        this.trace(TraceGroup.GENERAL, clazz, message);
    }

    public void traceParam(Class clazz, String message) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("PARAM:");
        stringbuffer.append(FileLoggerImpl.getClassAndTreadInfo(clazz)).append(' ');
        stringbuffer.append(message);
        this.writeToFile(clazz, stringbuffer.toString());
    }

    public void traceRecSig(Class clazz, String message, InSignal insignal) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("RESIG:");
        stringbuffer.append(FileLoggerImpl.getClassAndTreadInfo(clazz)).append(' ');
        stringbuffer.append(message);
        try {
            int sigNo = insignal.getSigNo();
            stringbuffer.append(", SigNo: ");
            stringbuffer.append(sigNo);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        this.writeToFile(clazz, stringbuffer.toString());
    }

    public void traceReturn(Class clazz, String message) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("RETRN:");
        stringbuffer.append(FileLoggerImpl.getClassAndTreadInfo(clazz)).append(' ');
        stringbuffer.append(message);
        this.writeToFile(clazz, stringbuffer.toString());
    }

    public void traceSendSig(Class clazz, String message, OutSignal outsignal, OseProcess oseprocess) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("SESIG:");
        stringbuffer.append(FileLoggerImpl.getClassAndTreadInfo(clazz)).append(' ');
        stringbuffer.append(message);
        try {
            int sigNo = outsignal.javaToOse();
            stringbuffer.append(", SigNo: ");
            stringbuffer.append(sigNo);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        this.writeToFile(clazz, stringbuffer.toString());
    }

    public void traceState(Class clazz, String message) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("STATE:");
        stringbuffer.append(FileLoggerImpl.getClassAndTreadInfo(clazz)).append(' ');
        stringbuffer.append(message);
        this.writeToFile(clazz, stringbuffer.toString());
    }

    public void traceTimer(Class clazz, String message) {
        this.trace(TraceGroup.TIMER, clazz, message);
    }

    private void trace(TraceGroup tracegroup, Class clazz, String message) {
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("TRACE:");
        stringbuffer.append(tracegroup).append(' ');
        stringbuffer.append(FileLoggerImpl.getClassAndTreadInfo(clazz)).append(' ');
        stringbuffer.append(message);
        this.writeToFile(clazz, stringbuffer.toString());
    }

    private static String getClassAndTreadInfo(Class clazz) {
        String packagageName = clazz.getPackage().getName();
        String threadName = Thread.currentThread().getName();
        String className = packagageName.length() > 0 ? clazz.getName().substring(packagageName.length() + 1) : clazz.getName();
        return packagageName + COLON_STRING + threadName + " " + className;
    }

    public void startLogListner(List nameOfPackages, AbstractLogger mylogger) {
        if (mylogger != null) {
            this.logger = mylogger;
        }
        this.packagesList = new ArrayList(nameOfPackages);
        this.logger.addListeningLogger(this);
    }

    private void writeToFile(Class clazz, String message) {
        Package packageName = clazz.getPackage();
        if (LogFileWriter.logAllMessages() || this.logCurrentPackage(packageName)) {
            String timeStamp = DateTimeHelper.dateToString(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault());
            String messageToBeLogged = timeStamp + "-" + message;
            this.writeToFile(messageToBeLogged);
        }
    }

    protected void writeToFile(String messageToBeLogged) {
        String logThis = messageToBeLogged;
        if (!logThis.endsWith("\n")) {
            logThis = logThis + "\n";
        }
        if (this.logFileWriter != null) {
            this.logFileWriter.writeToFile(logThis);
        } else {
            this.logger.removeListeningLogger(this);
            this.logger.traceDebug(this.getClass(), "logFileWriter is null");
        }
    }

    private boolean logCurrentPackage(Package packageName) {
        boolean logPackage = false;
        ListIterator myIterator = this.packagesList.listIterator();
        while (myIterator.hasNext()) {
            String name = "";
            Object o = myIterator.next();
            if (o instanceof String) {
                name = (String)o;
            }
            if (!packageName.getName().startsWith(name)) continue;
            logPackage = true;
            break;
        }
        return logPackage;
    }

    public void integrationFinishedOrFailed() {
        try {
            this.logger.removeListeningLogger(this);
            this.logFileWriter.stopIt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List getDefaultNameOfPackages() {
        ArrayList<String> defaultNamesPackagesList = new ArrayList<String>();
        defaultNamesPackagesList.add("se.ericsson.crbs.cat.mao.rbsconfiguration");
        defaultNamesPackagesList.add("se.ericsson.crbs.cat.mao.antennanearunit");
        defaultNamesPackagesList.add("se.ericsson.crbs.cat.mao.antennasubunit");
        defaultNamesPackagesList.add("se.ericsson.crbs.cat.mao.antennasystemconfiguration");
        defaultNamesPackagesList.add("se.ericsson.crbs.cat.mao.antennaunit");
        defaultNamesPackagesList.add("se.ericsson.crbs.cat.mao.retsubunit");
        return defaultNamesPackagesList;
    }

    public String getDefaultFileLogPath() {
        String propertyLogFileDir = System.getProperty(LOG_FILE_PATH_SYSTEM_PROP_NAME);
        String unitTestString = System.getProperty("UNIT_TEST", "false");
        if (pathfilename == null) {
            if ("true".equalsIgnoreCase(unitTestString)) {
                if (propertyLogFileDir == null) {
                    String path = System.getProperty(USER_HOME);
                    pathfilename = path + System.getProperty(FILE_SEPARATOR) + System.currentTimeMillis() + ".log";
                } else {
                    pathfilename = propertyLogFileDir;
                }
            } else {
                pathfilename = DEFAULT_FILE_PATH;
            }
        }
        return pathfilename;
    }
}

