/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import se.ericsson.crbs.common.DateTimeHelper;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.common.FileHelper;
import se.ericsson.crbs.common.StringHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class LogFileWriter
extends Thread {
    public static final String LOG_ALL_SYSTEM_PROP_NAME = "autointegration_log_all";
    private final long maxFileSize;
    private final int maxFileNum;
    protected static final int MAX_BUFFER_SIZE = 10000;
    protected static final String THREAD_NAME = "CrbsGoamLm_LogFileWriterFlushingThread";
    private static final Class THIS_CLASS = class$se$ericsson$crbs$logging$LogFileWriter == null ? (class$se$ericsson$crbs$logging$LogFileWriter = LogFileWriter.class$("se.ericsson.crbs.logging.LogFileWriter")) : class$se$ericsson$crbs$logging$LogFileWriter;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private static final Object THREAD_TERMINATED_MUTEX_OBJECT = new Object();
    private static final Object THREAD_MUTEX_OBJECT = new Object();
    private static final Object BUFFER_MUTEX_OBJECT = new Object();
    private final long waitingPeriod = "TRUE".equalsIgnoreCase(System.getProperty("UNIT_TEST")) ? 5L : 5000L;
    private boolean keepRunning = true;
    private boolean running = true;
    private LogFile currentLogFile;
    private final String[] logFilePathList;
    private int currentPosition = 0;
    private StringBuffer logFileBuffer;
    static /* synthetic */ Class class$se$ericsson$crbs$logging$LogFileWriter;

    public LogFileWriter(LogFile progressReportWritingFile) throws IOException {
        super(THREAD_NAME);
        this.currentLogFile = progressReportWritingFile;
        this.maxFileSize = (long)(1048576.0 * Double.parseDouble(System.getProperty("ai.report.file.maxsize.", "4")));
        this.maxFileNum = Integer.parseInt(System.getProperty("ai.report.file.maxnum.", "2"));
        this.logFilePathList = new String[this.maxFileNum];
        this.initLogFileListFromDisk();
        try {
            if (progressReportWritingFile.doAppend() && this.currentLogFile.exists()) {
                this.logFileBuffer = new StringBuffer(10000);
                this.writeToFile("####################### Integration of RBS continued #######################\n\n");
            } else {
                this.logFileBuffer = new StringBuffer(10000);
                FileHelper.createDirectoryTree(this.currentLogFile.getParent());
                if (!this.currentLogFile.exists()) {
                    this.currentLogFile.createNewFile();
                } else {
                    this.currentLogFile.delete();
                    this.currentLogFile.createNewFile();
                }
                this.writeToFile("####################### Integration of RBS started #######################\n\n");
                this.writeToFile("Start logging in " + this.currentLogFile.getAbsolutePath() + ". Max file size = " + (double)this.maxFileSize / 1024.0 + " KB. Max backup file number = " + this.maxFileNum + ".\n");
            }
            Runtime.getRuntime().addShutdownHook(new ShutDownFlushingThread(this));
        }
        catch (Exception e) {
            String errorMsg = "Failed to create file path for log files: " + StringHelper.doubleQuote(this.currentLogFile.getAbsolutePath());
            errorMsg = ExceptionHelper.appendReason(errorMsg, e);
            throw new IOException(errorMsg);
        }
        this.setDaemon(true);
        this.startIt();
    }

    private void initLogFileListFromDisk() {
        File logDir = new File(this.currentLogFile.getParent());
        File[] fileList = logDir.listFiles();
        if (fileList == null) {
            return;
        }
        ArrayList<String> logFileList = new ArrayList<String>();
        for (int i = 0; i < fileList.length; ++i) {
            if (fileList[i].getName().indexOf(".aibak") <= 0) continue;
            logFileList.add(logDir.getAbsoluteFile() + File.separator + fileList[i].getName());
        }
        this.currentPosition = 0;
        if (logFileList.size() > 0) {
            int i;
            int numOfLogToRemove = logFileList.size() - this.maxFileNum;
            Collections.sort(logFileList);
            int startIdx = 0;
            if (numOfLogToRemove > 0) {
                for (i = 0; i < numOfLogToRemove && i < logFileList.size(); ++i) {
                    new File(logFileList.get(i).toString()).delete();
                }
                startIdx = numOfLogToRemove;
            }
            for (i = startIdx; i < logFileList.size() && this.currentPosition < this.maxFileNum; ++i) {
                this.logFilePathList[this.currentPosition++] = logFileList.get(i).toString();
            }
            if (this.currentPosition == this.logFilePathList.length) {
                this.currentPosition = 0;
            }
        }
    }

    protected static boolean logAllMessages() {
        String propertyLogAllString = System.getProperty(LOG_ALL_SYSTEM_PROP_NAME, "false");
        return "true".equalsIgnoreCase(propertyLogAllString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToFile(String messageToBeLogged) {
        long fileLength = this.currentLogFile.length() + (long)this.logFileBuffer.length();
        if (!LogFileWriter.logAllMessages() && fileLength + (long)messageToBeLogged.length() > this.maxFileSize) {
            this.swapLogFile();
        }
        Object object = BUFFER_MUTEX_OBJECT;
        synchronized (object) {
            this.logFileBuffer.append(messageToBeLogged);
        }
        if (this.logFileBuffer.length() >= 10000) {
            this.flushBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapLogFile() {
        if (this.currentPosition >= this.logFilePathList.length) {
            this.currentPosition = 0;
        }
        String currentFilePath = this.currentLogFile.getAbsolutePath();
        String archiveFilePath = currentFilePath + "_" + DateTimeHelper.getDateTime() + ".aibak";
        File archiveFile = new File(archiveFilePath);
        while (archiveFile.exists()) {
            archiveFilePath = archiveFilePath + "_";
            archiveFile = new File(archiveFilePath);
        }
        if (this.logFilePathList[this.currentPosition] != null) {
            new File(this.logFilePathList[this.currentPosition]).delete();
        }
        Object object = THREAD_MUTEX_OBJECT;
        synchronized (object) {
            new File(currentFilePath).renameTo(archiveFile);
            FileHelper.writeToFile(currentFilePath, "Continue logging after " + archiveFilePath + "\n", false);
            FileHelper.writeToFile(archiveFilePath, "The file size reached limit: " + (double)this.maxFileSize / 1024.0 + " KB. Continue logging in new file.\n", true);
        }
        this.logFilePathList[this.currentPosition++] = archiveFilePath;
        if (this.currentPosition >= this.logFilePathList.length) {
            this.currentPosition = 0;
        }
    }

    private void startIt() {
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopIt() {
        if (this.keepRunning) {
            this.writeToFile("\n\n####################### Integration of RBS stopped #######################\n\n");
            Object object = THREAD_TERMINATED_MUTEX_OBJECT;
            synchronized (object) {
                Object object2 = THREAD_MUTEX_OBJECT;
                synchronized (object2) {
                    THREAD_MUTEX_OBJECT.notifyAll();
                }
                if (this.running) {
                    try {
                        object2 = THREAD_MUTEX_OBJECT;
                        synchronized (object2) {
                            this.keepRunning = false;
                        }
                        THREAD_TERMINATED_MUTEX_OBJECT.wait(this.waitingPeriod * 2L);
                    }
                    catch (InterruptedException ie) {
                        logger.traceAbnormal(THIS_CLASS, "Interrupted while waiting. " + ie);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flushBuffer() {
        Object object = THREAD_MUTEX_OBJECT;
        synchronized (object) {
            THREAD_MUTEX_OBJECT.notifyAll();
        }
    }

    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = THREAD_MUTEX_OBJECT;
        synchronized (object) {
            this.running = true;
            while (this.keepRunning) {
                try {
                    THREAD_MUTEX_OBJECT.wait(this.waitingPeriod);
                    this.writeToFile();
                }
                catch (InterruptedException ie) {
                    logger.traceAbnormal(THIS_CLASS, "Interrupted while waiting. " + ie);
                }
                catch (IOException ioe) {
                    logger.traceAbnormal(THIS_CLASS, "Data could not be written. " + ioe);
                }
            }
            try {
                this.writeToFile();
            }
            catch (IOException ioe) {
                logger.traceAbnormal(THIS_CLASS, "Data could not be written. " + ioe);
            }
        }
        object = THREAD_TERMINATED_MUTEX_OBJECT;
        synchronized (object) {
            this.running = false;
            THREAD_TERMINATED_MUTEX_OBJECT.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile() throws IOException {
        StringBuffer unwrittenData = new StringBuffer();
        Object object = BUFFER_MUTEX_OBJECT;
        synchronized (object) {
            if (this.logFileBuffer.length() > 0) {
                unwrittenData.append(this.logFileBuffer);
                this.logFileBuffer.setLength(0);
            }
            this.currentLogFile.write(unwrittenData.toString().getBytes());
        }
    }

    protected boolean exists() {
        return this.currentLogFile.doAppend();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class LogFile
    extends File {
        private static final long serialVersionUID = 1L;
        private final boolean appendToFile;

        public LogFile(String filePath, boolean inputAppendToFile) throws IOException {
            super(filePath);
            this.appendToFile = inputAppendToFile;
        }

        public boolean doAppend() {
            return this.appendToFile;
        }

        public void write(byte[] unwrittenData) throws IOException {
            FileOutputStream fos = new FileOutputStream(this, true);
            fos.write(unwrittenData);
            fos.flush();
            fos.close();
        }
    }

    public static class ShutDownFlushingThread
    extends Thread {
        private final LogFileWriter progressReportFileWriter;

        public ShutDownFlushingThread(LogFileWriter inputProgressReportFileWriter) {
            super("CRBS_lmCatOamLmU_ShutdownFlushingThread");
            this.progressReportFileWriter = inputProgressReportFileWriter;
        }

        public void run() {
            try {
                this.progressReportFileWriter.flushBuffer();
                this.progressReportFileWriter.stopIt();
            }
            catch (Exception e) {
                logger.traceDebug(THIS_CLASS, "Unexepected exception. " + e);
            }
        }
    }
}

