/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.commonmo.validation;

import se.ericsson.cello.moframework.AttrNotSettableException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.Definitions;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.metadata.AttributeMetaData;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.commonmo.metadata.types.AttributeDataType;
import se.ericsson.crbs.omf.mao.commonmo.mo.GenericManagedObject;
import se.ericsson.crbs.omf.mao.commonmo.validation.AttributeMetaDataValidator;
import se.ericsson.crbs.omf.mao.commonmo.validation.MoAttrNotSettableException;
import se.ericsson.crbs.omf.mao.commonmo.validation.ValidatorAttributeVisitor;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

class AttributeMetaDataValidatorImpl
implements AttributeMetaDataValidator {
    private static final Class THIS_CLASS = AttributeMetaDataValidatorImpl.class;
    private static AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private static final String LONG_TYPE = "long";
    private final ValidatorAttributeVisitor visitor;
    private final MoMetaDataFinder moMetaDataFinder;
    private final MoRepositoryWrapper moRepositoryWrapper;

    public AttributeMetaDataValidatorImpl(String moType, MoMetaDataFinder aMoMetaDataFinder, MoRepositoryWrapper aMoRepositoryWrapper) {
        this.visitor = new ValidatorAttributeVisitor(moType, aMoMetaDataFinder, aMoRepositoryWrapper);
        this.moMetaDataFinder = aMoMetaDataFinder;
        this.moRepositoryWrapper = aMoRepositoryWrapper;
    }

    public void checkAttribute(AttributeDataType dataType, String attributeName, Object attributeValue, boolean isMandatory) throws MoAccessException {
        dataType.accept(this.visitor, attributeName, attributeValue, isMandatory);
    }

    public void checkSingleRefAttribute(AttributeDataType dataType, String attributeName, Object attributeValue, Object currentValue, boolean isMandatory) throws MoAccessException {
        if (currentValue != null) {
            String msg = "Attempt to set reservedBy failed.  overall reservedBy limit of one exceeded ";
            logger.traceAbnormal(THIS_CLASS, "Attempt to set reservedBy failed.  overall reservedBy limit of one exceeded ");
            throw new ProcessingFailureException("Attempt to set reservedBy failed.  overall reservedBy limit of one exceeded ");
        }
        this.checkAttribute(dataType, attributeName, attributeValue, isMandatory);
    }

    public void checkUniqueInNode(String moType, String attributeName, Object attributeValue, AttributeMetaData attrMetaData, GenericManagedObject myMo, Coordinator coord) throws NoSuchAttributeException, ProcessingFailureException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "checkUniqueInNode() - " + attributeName);
        if (attrMetaData.isUniqueInNode() && attrMetaData.getData().getJavaReturnType().equals("Integer")) {
            String msg = "Checking uniqueness of " + attributeName + " = " + attributeValue.toString();
            logger.traceDebug(THIS_CLASS, msg);
            if (!this.checkUniquenessInNode(moType, attributeName, attributeValue, LONG_TYPE, coord, myMo.getLocalDistinguishedName())) {
                throw new ProcessingFailureException("Attribute " + attributeName + " in " + moType + " MO is not unique. ");
            }
        }
        logger.traceReturn(THIS_CLASS, "checkUniqueInNode() - " + attributeName);
    }

    public boolean checkUniquenessInNode(String moType, String attributeName, Object attributeValue, String attributeType, Coordinator coord, String moLdn) throws NoSuchAttributeException, MoAccessException {
        String msg = "checkUniquenessInNode(" + moType + ", " + attributeName + ")";
        logger.traceEnter(THIS_CLASS, msg);
        boolean result = true;
        MoIterator iterator = this.moRepositoryWrapper.lookupType(moType);
        if (iterator == null) {
            result = true;
        } else {
            while (iterator.hasMoreElements()) {
                ManagedObject managedObject = (ManagedObject)iterator.nextElement();
                Object attributeValueToCompare = managedObject.getAttribute(attributeName, coord);
                int attToCompare = -1;
                int attValue = -1;
                if (attributeType.indexOf(LONG_TYPE) != -1) {
                    attToCompare = (Integer)attributeValueToCompare;
                    attValue = (Integer)attributeValue;
                    String genMsg = "Attribute type and value are " + attributeType + " " + attToCompare;
                    logger.traceGeneral(THIS_CLASS, genMsg);
                }
                if (attToCompare != attValue || managedObject.getLocalDistinguishedName().equalsIgnoreCase(moLdn)) continue;
                logger.traceReturn(THIS_CLASS, msg);
                result = false;
                break;
            }
        }
        logger.traceReturn(THIS_CLASS, msg);
        return result;
    }

    public final void verifyAtGet(String moName, String attributeName) throws NoSuchAttributeException, ProcessingFailureException {
        String msg = "verifyAtGet() " + moName + ", " + attributeName;
        logger.traceEnter(THIS_CLASS, msg);
        AttributeMetaData metaData = this.moMetaDataFinder.getMoAttributes(moName, attributeName);
        if (metaData == null || Definitions.isPmAttribute(attributeName)) {
            throw new NoSuchAttributeException(attributeName, moName);
        }
        logger.traceReturn(THIS_CLASS, msg);
    }

    public final void verifyAtSet(String moType, String attributeName, Object value, AttributeMetaData attrMetaData, boolean isSystemWriteableOnly) throws ValueOutOfRangeException, NoSuchAttributeException, WrongAttributeTypeException, MoNotFoundException, AttrNotSettableException, ProcessingFailureException, MoAccessException {
        if ((attrMetaData.isReadOnly() || attrMetaData.isSystemWriteableOnly()) && !isSystemWriteableOnly) {
            String reason = "Trying to set read-only attribute on MO ";
            logger.traceAbnormal(THIS_CLASS, "Trying to set read-only attribute on MO " + moType + ", attribute " + attributeName);
            throw new MoAttrNotSettableException(moType, attributeName, "Trying to set read-only attribute on MO ");
        }
        if ((attrMetaData.isRestricted() || attrMetaData.isSystemWriteableOnly()) && !isSystemWriteableOnly) {
            String reason = "Trying to set a restricted attribute on MO " + moType;
            logger.traceAbnormal(THIS_CLASS, reason + moType + ", attribute " + attributeName);
            throw new MoAttrNotSettableException(moType, attributeName, reason);
        }
        if (attrMetaData.isMandatory() && value == null) {
            String msg = "Cannot set mandatory attribute " + moType + " to null.";
            logger.traceAbnormal(THIS_CLASS, msg);
            throw new ProcessingFailureException(msg);
        }
        this.checkAttribute(attrMetaData.getData(), attributeName, value, attrMetaData.isMandatory());
    }
}

