/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.xml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.xml.Parser;
import se.ericsson.crbs.omf.mao.xml.XMLElement;
import se.ericsson.crbs.omf.mao.xml.XMLElementFactoryImpl;
import se.ericsson.crbs.omf.mao.xml.XmlElementsReadable;
import se.ericsson.crbs.omf.mao.xml.XmlFileResolver;
import se.ericsson.crbs.omf.mao.xml.XmlFileResolverFactory;
import se.ericsson.crbs.omf.mao.xml.XmlFileResolverImpl;

class ParserImpl
implements XmlElementsReadable,
Parser {
    private static final String TEMP_DIR = "/c/tmp/";
    private static final String DTD_STRING = ".dtd";
    private static final String XSD_STRING = ".xsd";
    private static final String NO_NAMESPACE_SCHEMA_LOCATION_STRING = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    private static final String FEATURES_VALIDATION_SCHEMA_STRING = "http://apache.org/xml/features/validation/schema";
    private static final String ORG_APACHE_XERCES_PARSERS_SAX_PARSER_STRING = "org.apache.xerces.parsers.SAXParser";
    private boolean isClosed = false;
    private static final AbstractLogger logger = LoggingService.getLogger();
    private static final XmlFileResolverFactory xmlFileResolverFactory = new XmlFileResolverFactory();
    private final transient List xmlElementInParsedFile = new ArrayList();

    ParserImpl(String xmlFileName, String filePath) throws IOException {
        this.parseSchema(xmlFileName, filePath, null, null, false);
    }

    ParserImpl(String xmlFileName, String filePath, String schemaFilePath) throws IOException {
        this.parseSchema(xmlFileName, filePath, null, schemaFilePath, true);
    }

    private XMLElement domElementToXMLElement(Element elementToTransform) {
        String elementText = elementToTransform.getText();
        XMLElement domElementAsXMLElement = XMLElementFactoryImpl.createXMLElement(elementToTransform.getName(), elementText);
        List domElementAttributes = elementToTransform.getAttributes();
        Iterator attributeIter = domElementAttributes.iterator();
        while (attributeIter.hasNext()) {
            Attribute currentAttribute = (Attribute)attributeIter.next();
            domElementAsXMLElement.addAttribute(currentAttribute.getName(), currentAttribute.getValue());
        }
        List domElementChildren = elementToTransform.getChildren();
        this.processChildrenForElement(domElementChildren, domElementAsXMLElement);
        return domElementAsXMLElement;
    }

    public List getXMLelements() {
        if (this.isClosed) {
            throw new IllegalStateException("Parser is allready closed!");
        }
        return this.xmlElementInParsedFile;
    }

    private void parseSchema(String xmlFileName, String filePath, URL xmlURL, String schemaFileName, boolean validate) throws IOException {
        SAXBuilder builder = new SAXBuilder(ORG_APACHE_XERCES_PARSERS_SAX_PARSER_STRING, validate);
        XmlFileResolver resolver = xmlFileResolverFactory.createXmlFileResolver(filePath);
        builder.setEntityResolver(resolver);
        String localXmlFileName = xmlFileName;
        String localFilePath = filePath;
        if (validate) {
            builder.setFeature(FEATURES_VALIDATION_SCHEMA_STRING, true);
            if (schemaFileName.toLowerCase(Locale.getDefault()).endsWith(XSD_STRING)) {
                builder.setProperty(NO_NAMESPACE_SCHEMA_LOCATION_STRING, schemaFileName);
            } else if (schemaFileName.toLowerCase(Locale.getDefault()).endsWith(DTD_STRING)) {
                File xmlFile = new File(localFilePath + File.separator + xmlFileName);
                if (localFilePath == null || "".equals(localFilePath)) {
                    xmlFile = new File(xmlFileName);
                }
                xmlFile = this.createModifiedXmlFile(xmlFile, xmlFileName);
                localXmlFileName = xmlFile.getName();
                localFilePath = xmlFile.getParent();
                resolver = xmlFileResolverFactory.createXmlFileResolver(localFilePath);
                builder.setEntityResolver(resolver);
                ((XmlFileResolverImpl)resolver).setDtdFilePath(schemaFileName);
            }
        }
        try {
            Document schemaDoc = null;
            if (localXmlFileName == null) {
                logger.traceDebug(this.getClass(), "Starting build " + xmlURL);
                schemaDoc = builder.build(xmlURL);
                logger.traceDebug(this.getClass(), "finished build " + xmlURL);
            } else {
                logger.traceDebug(this.getClass(), "Starting build " + localXmlFileName);
                InputSource src = resolver.resolveEntity("", localXmlFileName);
                schemaDoc = builder.build(src);
                logger.traceDebug(this.getClass(), "finished build " + localXmlFileName);
            }
            Element root = schemaDoc.getRootElement();
            List children = root.getChildren();
            this.processChildrenForRoot(children);
        }
        catch (JDOMException e) {
            logger.traceError(this.getClass(), "", e);
            IOException ioe = new IOException("Problems occurred:" + e.getMessage());
            throw ioe;
        }
        catch (SAXException e) {
            logger.traceError(this.getClass(), "Error when...", e);
            throw new IOException("Problems occurred:" + e.getMessage());
        }
    }

    private void processChildrenForElement(List children, XMLElement parent) {
        Iterator childIter = children.iterator();
        while (childIter.hasNext()) {
            Element currentChild = (Element)childIter.next();
            XMLElement currentChildAsXMLElement = this.domElementToXMLElement(currentChild);
            parent.addChild(currentChildAsXMLElement);
        }
    }

    private void processChildrenForRoot(List children) {
        Iterator childIter = children.iterator();
        while (childIter.hasNext()) {
            Element currentChild = (Element)childIter.next();
            XMLElement currentChildAsXMLElement = this.domElementToXMLElement(currentChild);
            this.xmlElementInParsedFile.add(currentChildAsXMLElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File createModifiedXmlFile(File xmlFile, String originalXmlFile) throws IOException {
        File tempXmlFile = null;
        try {
            String tmpDirPath = this.getTempDirPath();
            File tmpDir = new File(tmpDirPath);
            if (!tmpDir.exists()) {
                throw new IOException("Could not find temporary directory: " + tmpDirPath);
            }
            tempXmlFile = File.createTempFile("modifiedXml", ".xml", tmpDir);
            BufferedWriter writer = new BufferedWriter(new FileWriter(tempXmlFile));
            BufferedReader reader = new BufferedReader(new FileReader(xmlFile));
            try {
                tempXmlFile.deleteOnExit();
                String line = null;
                line = reader.readLine();
                while (line != null) {
                    String standAloneString = "standalone=\"yes\"";
                    int standAloneIndex = line.toLowerCase(Locale.getDefault()).indexOf("standalone=\"yes\"");
                    if (standAloneIndex != -1) {
                        line = line.substring(0, standAloneIndex) + line.substring(standAloneIndex + "standalone=\"yes\"".length());
                    }
                    writer.write(line);
                    writer.write("\n");
                    line = reader.readLine();
                }
            }
            finally {
                reader.close();
                writer.flush();
                writer.close();
            }
        }
        catch (IOException ex) {
            throw new IOException("Unable to parse file: " + originalXmlFile + "Message: " + ex.getMessage());
        }
        return tempXmlFile;
    }

    private String getTempDirPath() {
        String tempDirPath = TEMP_DIR;
        if ("TRUE".equalsIgnoreCase(System.getProperty("UNIT_TEST")) && !(tempDirPath = System.getProperty("user.home")).endsWith(File.separator)) {
            tempDirPath = tempDirPath + File.separator;
        }
        return tempDirPath;
    }

    public void close() {
        this.xmlElementInParsedFile.clear();
        this.isClosed = true;
    }
}

